/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class CardLayoutSupport
extends AbstractLayoutSupport {
    private CardConstraints currentCard;

    public Class getSupportedClass() {
        return CardLayout.class;
    }

    public void addComponents(CodeExpression[] codeExpressionArray, LayoutConstraints[] layoutConstraintsArray, int n) {
        super.addComponents(codeExpressionArray, layoutConstraintsArray, n);
        n = n < 0 ? this.getComponentCount() - 1 : (n += codeExpressionArray.length - 1);
        if (this.currentCard == null && n >= 0 && n < this.getComponentCount()) {
            this.currentCard = (CardConstraints)this.getConstraints(n);
        }
    }

    public void selectComponent(int n) {
        LayoutConstraints layoutConstraints = this.getConstraints(n);
        if (layoutConstraints instanceof CardConstraints) {
            this.currentCard = (CardConstraints)layoutConstraints;
        }
    }

    public void arrangeContainer(Container container, Container container2) {
        LayoutManager layoutManager = container2.getLayout();
        if (!(layoutManager instanceof CardLayout) || this.currentCard == null) {
            return;
        }
        ((CardLayout)layoutManager).show(container2, (String)this.currentCard.getConstraintsObject());
    }

    public int getNewIndex(Container container, Container container2, Component component, int n, Point point, Point point2) {
        if (!(container2.getLayout() instanceof CardLayout)) {
            return -1;
        }
        return container2.getComponentCount();
    }

    public String getAssistantContext() {
        return "cardLayout";
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        if (!(container2.getLayout() instanceof CardLayout)) {
            return false;
        }
        Dimension dimension = container2.getSize();
        Insets insets = container2.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        graphics.drawRect(0, 0, dimension.width, dimension.height);
        return true;
    }

    protected LayoutConstraints readConstraintsCode(CodeExpression codeExpression, CodeGroup codeGroup, CodeExpression codeExpression2) {
        CardConstraints cardConstraints = new CardConstraints("card");
        FormCodeSupport.readPropertyExpression(codeExpression, cardConstraints.getProperties()[0], false);
        return cardConstraints;
    }

    protected CodeExpression createConstraintsCode(CodeGroup codeGroup, LayoutConstraints layoutConstraints, CodeExpression codeExpression, int n) {
        if (!(layoutConstraints instanceof CardConstraints)) {
            return null;
        }
        return this.getCodeStructure().createExpression(FormCodeSupport.createOrigin(layoutConstraints.getProperties()[0]));
    }

    protected LayoutConstraints createDefaultConstraints() {
        return new CardConstraints("card" + (this.getComponentCount() + 1));
    }

    public static class CardConstraints
    implements LayoutConstraints {
        private String card;
        private Node.Property[] properties;

        public CardConstraints(String string) {
            this.card = string;
        }

        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new Node.Property[]{new FormProperty("CardConstraints cardName", String.class, CardLayoutSupport.getBundle().getString("PROP_cardName"), CardLayoutSupport.getBundle().getString("HINT_cardName")){

                    public Object getTargetValue() {
                        return CardConstraints.this.card;
                    }

                    public void setTargetValue(Object object) {
                        CardConstraints.this.card = (String)object;
                    }

                    public void setPropertyContext(FormPropertyContext formPropertyContext) {
                    }
                }};
                this.properties[0].setValue("NOI18N", (Object)Boolean.TRUE);
            }
            return this.properties;
        }

        public Object getConstraintsObject() {
            return this.card;
        }

        public LayoutConstraints cloneConstraints() {
            return new CardConstraints(this.card);
        }
    }
}

