/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.dlight.annotationsupport.AnnotationBarManager;
import org.netbeans.modules.dlight.annotationsupport.AnnotationSupport;
import org.netbeans.modules.dlight.annotationsupport.FileAnnotationInfo;
import org.netbeans.modules.dlight.annotationsupport.LineAnnotationInfo;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricFormatter;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedSourceSupportImpl
implements AnnotatedSourceSupport {
    private static final Logger log = Logger.getLogger("dlight.annotationsupport");
    private static boolean checkedLogging = AnnotatedSourceSupportImpl.checkLogging();
    private static boolean logginIsOn;
    private HashMap<String, FileAnnotationInfo> activeAnnotations = new HashMap();
    private static AnnotatedSourceSupportImpl instance;

    public AnnotatedSourceSupportImpl() {
        AnnotationSupport.getInstance().addPropertyChangeListener(new ProfilerPropertyChangeListener());
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new EditorFileChangeListener());
    }

    protected static AnnotatedSourceSupportImpl getInstance() {
        if (instance == null) {
            instance = (AnnotatedSourceSupportImpl)Lookup.getDefault().lookup(AnnotatedSourceSupportImpl.class);
        }
        return instance;
    }

    private synchronized void preProcessAnnotations(SourceFileInfoDataProvider sourceFileInfoDataProvider, List<DataTableMetadata.Column> list, List<FunctionCallWithMetric> list2, boolean bl) {
        if (list2 == null || list2.size() == 0) {
            return;
        }
        for (FunctionCallWithMetric functionCallWithMetric : list2) {
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoDataProvider.getSourceFileInfo((FunctionCall)functionCallWithMetric);
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            String string = sourceFileInfo.getFileName();
            FileAnnotationInfo fileAnnotationInfo = this.activeAnnotations.get(string = FileUtil.normalizeFile((File)new File(string)).getAbsolutePath());
            if (fileAnnotationInfo == null) {
                fileAnnotationInfo = new FileAnnotationInfo();
                fileAnnotationInfo.setFilePath(string);
                fileAnnotationInfo.setColumnNames(new String[list.size()]);
                fileAnnotationInfo.setMaxColumnWidth(new int[list.size()]);
                this.activeAnnotations.put(string, fileAnnotationInfo);
            }
            LineAnnotationInfo lineAnnotationInfo = new LineAnnotationInfo(fileAnnotationInfo);
            lineAnnotationInfo.setLine(sourceFileInfo.getLine());
            lineAnnotationInfo.setOffset(sourceFileInfo.getOffset());
            lineAnnotationInfo.setColumns(new String[list.size()]);
            lineAnnotationInfo.setNotFormattedColumns(new String[list.size()]);
            boolean bl2 = true;
            int n = 0;
            for (DataTableMetadata.Column column : list) {
                String string2;
                String string3 = column.getColumnName();
                Object object = functionCallWithMetric.getMetricValue(string3);
                String string4 = FunctionMetricFormatter.getFormattedValue((FunctionCallWithMetric)functionCallWithMetric, (String)string3);
                if (!string4.equals("0.0")) {
                    bl2 = false;
                }
                lineAnnotationInfo.getColumns()[n] = string4;
                lineAnnotationInfo.getNotFormattedColumns()[n] = object + "";
                int n2 = string4.length();
                if (fileAnnotationInfo.getMaxColumnWidth()[n] < n2) {
                    fileAnnotationInfo.getMaxColumnWidth()[n] = n2;
                }
                fileAnnotationInfo.getColumnNames()[n] = string2 = column.getColumnUName();
                ++n;
            }
            if (bl && !bl2) {
                fileAnnotationInfo.addLineAnnotationInfo(lineAnnotationInfo);
            }
            if (bl) continue;
            fileAnnotationInfo.addBlockAnnotationInfo(lineAnnotationInfo);
        }
    }

    public synchronized FileAnnotationInfo getFileAnnotationInfo(String string) {
        return this.activeAnnotations.get(string);
    }

    public synchronized void updateSource(SourceFileInfoDataProvider sourceFileInfoDataProvider, List<DataTableMetadata.Column> list, List<FunctionCallWithMetric> list2, List<FunctionCallWithMetric> list3) {
        HashSet<JEditorPane> hashSet = new HashSet<JEditorPane>();
        if (this.activeAnnotations != null) {
            for (FileAnnotationInfo object : this.activeAnnotations.values()) {
                if (!object.isAnnotated()) continue;
                hashSet.add(object.getEditorPane());
            }
        }
        this.activeAnnotations = new HashMap();
        this.preProcessAnnotations(sourceFileInfoDataProvider, list, list2, true);
        this.preProcessAnnotations(sourceFileInfoDataProvider, list, list3, false);
        this.annotateCurrentFocusedFiles();
        for (FileAnnotationInfo fileAnnotationInfo : this.activeAnnotations.values()) {
            if (!fileAnnotationInfo.isAnnotated()) continue;
            hashSet.remove(fileAnnotationInfo.getEditorPane());
        }
        for (JEditorPane jEditorPane : hashSet) {
            new UnAnnotate(jEditorPane).run();
        }
    }

    private File fileFromEditorPane(JTextComponent jTextComponent) {
        Object object;
        File file = null;
        if (jTextComponent != null && (object = jTextComponent.getDocument().getProperty("stream")) instanceof DataObject) {
            FileObject fileObject = ((DataObject)object).getPrimaryFile();
            file = FileUtil.toFile((FileObject)fileObject);
        }
        return file;
    }

    private synchronized void annotateCurrentFocusedFiles() {
        String string;
        FileAnnotationInfo fileAnnotationInfo;
        File file;
        if (this.activeAnnotations.size() == 0) {
            return;
        }
        JTextComponent jTextComponent = EditorRegistry.focusedComponent();
        if (jTextComponent == null) {
            jTextComponent = EditorRegistry.lastFocusedComponent();
        }
        if (jTextComponent != null && (file = this.fileFromEditorPane(jTextComponent)) != null && (fileAnnotationInfo = this.activeAnnotations.get(string = file.getAbsolutePath())) != null) {
            fileAnnotationInfo.setEditorPane((JEditorPane)jTextComponent);
            fileAnnotationInfo.setAnnotated(true);
            new Annotate(jTextComponent, fileAnnotationInfo).run();
        }
    }

    private void log(SourceFileInfoDataProvider sourceFileInfoDataProvider, List<DataTableMetadata.Column> list, List<FunctionCallWithMetric> list2, boolean bl) {
        if (!logginIsOn) {
            return;
        }
        log.fine("AnnotatedSourceSupportImpl.updateSource");
        log.finest("metrics:");
        for (DataTableMetadata.Column column : list) {
            log.finest("  getColumnLongUName " + column.getColumnLongUName());
            log.finest("  getColumnName " + column.getColumnName());
            log.finest("  getColumnUName " + column.getColumnUName());
            log.finest("  getExpression = " + column.getExpression());
            log.finest("");
        }
        log.finest("functionCalls:");
        for (FunctionCallWithMetric functionCallWithMetric : list2) {
            log.finest("  getDisplayedName " + functionCallWithMetric.getDisplayedName());
            log.finest("  getFunction " + functionCallWithMetric.getFunction());
            log.finest("  getFunction().getName() " + functionCallWithMetric.getFunction().getName());
            log.finest("  getFunction().getQuilifiedName() " + functionCallWithMetric.getFunction().getSignature());
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoDataProvider.getSourceFileInfo((FunctionCall)functionCallWithMetric);
            if (sourceFileInfo != null) {
                if (sourceFileInfo.isSourceKnown()) {
                    log.finer(sourceFileInfo.getFileName() + "\n");
                }
                log.finer("  type=" + (bl ? "Line" : "Block") + "\n");
                log.finer("  line=" + sourceFileInfo.getLine() + "\n");
                log.finer("  column=" + sourceFileInfo.getColumn() + "\n");
                log.finer("  offset=" + sourceFileInfo.getOffset() + "\n");
                for (DataTableMetadata.Column column : list) {
                    String string = column.getColumnName();
                    Object object = functionCallWithMetric.getMetricValue(string);
                    String string2 = column.getColumnUName();
                    log.finer("  " + string2 + "=" + object + "\n");
                }
            }
            log.finest("  " + functionCallWithMetric);
        }
    }

    private static boolean checkLogging() {
        if (checkedLogging) {
            return true;
        }
        logginIsOn = false;
        String string = System.getProperty("dlight.annotationsupport");
        if (string != null) {
            logginIsOn = true;
            if (string.equals("FINE")) {
                log.setLevel(Level.FINE);
            } else if (string.equals("FINER")) {
                log.setLevel(Level.FINER);
            } else if (string.equals("FINEST")) {
                log.setLevel(Level.FINEST);
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, FileAnnotationInfo> entry : this.activeAnnotations.entrySet()) {
            stringBuffer.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        return stringBuffer.toString();
    }

    static {
        instance = null;
    }

    private class ProfilerPropertyChangeListener
    implements PropertyChangeListener {
        private ProfilerPropertyChangeListener() {
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block4: {
                String string = propertyChangeEvent.getPropertyName();
                if (!string.equals("textAnnotationsVisible")) break block4;
                boolean bl = AnnotationSupport.getInstance().getTextAnnotationVisible();
                if (bl) {
                    for (FileAnnotationInfo fileAnnotationInfo : AnnotatedSourceSupportImpl.this.activeAnnotations.values()) {
                        if (!fileAnnotationInfo.isAnnotated()) continue;
                        new Annotate(fileAnnotationInfo.getEditorPane(), fileAnnotationInfo).run();
                    }
                } else {
                    for (FileAnnotationInfo fileAnnotationInfo : AnnotatedSourceSupportImpl.this.activeAnnotations.values()) {
                        if (!fileAnnotationInfo.isAnnotated()) continue;
                        new UnAnnotate(fileAnnotationInfo.getEditorPane()).run();
                    }
                }
            }
        }
    }

    private class EditorFileChangeListener
    implements PropertyChangeListener {
        private EditorFileChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("focusGained")) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    public void run() {
                        AnnotatedSourceSupportImpl.this.annotateCurrentFocusedFiles();
                    }
                }, (String)"Annotate current focused file");
            }
        }
    }

    private static class Annotate
    implements Runnable {
        JTextComponent jEditorPane;
        FileAnnotationInfo fileAnnotationInfo;

        public Annotate(JTextComponent jTextComponent, FileAnnotationInfo fileAnnotationInfo) {
            this.jEditorPane = jTextComponent;
            this.fileAnnotationInfo = fileAnnotationInfo;
        }

        public void run() {
            AnnotationBarManager.showAnnotationBar(this.jEditorPane, this.fileAnnotationInfo);
        }
    }

    private static class UnAnnotate
    implements Runnable {
        JTextComponent jEditorPane;

        public UnAnnotate(JTextComponent jTextComponent) {
            this.jEditorPane = jTextComponent;
        }

        public void run() {
            AnnotationBarManager.hideAnnotationBar(this.jEditorPane);
        }
    }
}

