/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.deploy;

public class CONA {
    public static final int CONAPI_MEDIA_ALL = 1;
    public static final int CONAPI_MEDIA_IRDA = 2;
    public static final int CONAPI_MEDIA_SERIAL = 4;
    public static final int CONAPI_MEDIA_BLUETOOTH = 8;
    public static final int CONAPI_MEDIA_USB = 16;
    public static final int CONA_APPLICATION_TYPE_SIS = 1;
    public static final int CONA_APPLICATION_TYPE_JAVA = 2;
    public static final int CONARefreshDeviceMemoryValues = 1;
    public static final int CONASetCurrentFolder = 2;
    public static final int CONAFindBegin = 4;
    public static final int CONACreateFolder = 8;
    public static final int CONADeleteFolder = 16;
    public static final int CONARenameFolder = 32;
    public static final int CONAGetFileInfo = 64;
    public static final int CONADeleteFile = 128;
    public static final int CONAMoveFile = 256;
    public static final int CONACopyFile = 512;
    public static final int CONARenameFile = 1024;
    public static final int CONAReadFile = 2048;
    public static final int CONAWriteFile = 4096;
    public static final int CONAConnectionLost = 8192;
    public static final int CONAInstallApplication = 16384;
    private static CONA instance = null;
    private static boolean connAPIdllFound = false;
    private static boolean connJNIdllFound = false;
    private static boolean OSSupportsDeployment = true;

    private CONA() {
    }

    public static CONA getInstance() {
        if (instance == null) {
            instance = new CONA();
            try {
                System.loadLibrary("ConnAPI");
                connAPIdllFound = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                connAPIdllFound = false;
            }
            catch (Exception exception) {
                connAPIdllFound = false;
            }
            try {
                System.loadLibrary("ConnJNI");
                connJNIdllFound = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                connJNIdllFound = false;
            }
            catch (Exception exception) {
                connJNIdllFound = false;
            }
        }
        return instance;
    }

    public boolean isConnAPIDllFound() {
        return connAPIdllFound;
    }

    public boolean isConnJNIDllFound() {
        return connJNIdllFound;
    }

    public boolean isOSSupportsDeployment() {
        return OSSupportsDeployment;
    }

    public static int getConnapiStatus(int n) {
        return 0xFFFF & n;
    }

    public static int getConnapiInfo(int n) {
        return (0xFF0000 & n) >> 16;
    }

    public static int getConnapiInfoData(int n) {
        return (0xFF000000 & n) >> 24;
    }

    public void fireDeviceNotify(int n, int n2) {
    }

    public void fireFileOperationNotify(int n, int n2, int n3, int n4) {
    }

    private native String native_getVersion();

    private native boolean native_connectServiceLayer();

    private native boolean native_updateDeviceList();

    private native String native_getDeviceType(int var1);

    private native String native_getDevices(int var1);

    private native boolean native_openConnectionTo(int var1);

    private native boolean native_installFile(String var1, String var2, String var3, int var4, boolean var5);

    private native boolean native_setCurrentFolder(String var1);

    private native boolean native_createFolder(String var1);

    private native boolean native_putFile(String var1, String var2, String var3);

    private native int native_getStatus(int var1);

    private native boolean native_closeConnection();

    private native boolean native_disconnectServiceLayer();

    public String getVersion() {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_getVersion();
        }
        return null;
    }

    public String getDeviceType(int n) {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_getDeviceType(n);
        }
        return null;
    }

    public boolean connect() {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_connectServiceLayer();
        }
        return false;
    }

    public boolean disconnect() {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_disconnectServiceLayer();
        }
        return false;
    }

    public boolean updateDeviceList() {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_updateDeviceList();
        }
        return false;
    }

    public String getDevices(int n) {
        if (n < 1 || n > 16) {
            return null;
        }
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_getDevices(n);
        }
        return null;
    }

    public boolean installApplication(String string, String string2, String string3, int n, boolean bl) {
        if (string == null || string2 == null) {
            return false;
        }
        if (n != 2 && n != 1) {
            return false;
        }
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_installFile(string, string2, string3, n, bl);
        }
        return false;
    }

    public boolean openFileSystem(int n) {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_openConnectionTo(n);
        }
        return false;
    }

    public boolean closeFileSystem() {
        if (connAPIdllFound && connJNIdllFound) {
            return this.native_closeConnection();
        }
        return false;
    }

    static {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            OSSupportsDeployment = false;
        }
    }
}

