/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.refactoring.AttributeFinder;
import org.netbeans.modules.spring.beans.refactoring.Occurrences;
import org.netbeans.modules.spring.beans.refactoring.PropertyChildFinder;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;
import org.netbeans.modules.spring.java.PropertyType;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRefFinder {
    private final SpringConfigModel.DocumentAccess docAccess;
    private final XMLSyntaxSupport syntaxSupport;
    private final CompilationController cc;
    private final SpringRefactorings.RenamedProperty renamedProperty;

    public PropertyRefFinder(SpringConfigModel.DocumentAccess documentAccess, CompilationController compilationController, SpringRefactorings.RenamedProperty renamedProperty) {
        this.docAccess = documentAccess;
        BaseDocument baseDocument = (BaseDocument)documentAccess.getDocument();
        this.syntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport();
        this.cc = compilationController;
        this.renamedProperty = renamedProperty;
    }

    public void addOccurrences(List<Occurrences.Occurrence> list) throws BadLocationException {
        Collection<ElementHandle<ExecutableElement>> collection = this.renamedProperty.getMethodHandles();
        Collection<ExecutableElement> collection2 = JavaUtils.getMethodsFromHandles((CompilationInfo)this.cc, collection);
        List<SpringBean> list2 = this.docAccess.getSpringBeans().getFileBeans(this.docAccess.getFileObject()).getBeans();
        for (SpringBean springBean : list2) {
            TypeElement typeElement;
            String string;
            Set<SpringBeanProperty> set = springBean.getProperties();
            if (set.isEmpty() || (string = new BeanClassFinder(springBean, this.docAccess.getFileObject()).findImplementationClass()) == null || (typeElement = JavaUtils.findClassElementByBinaryName(string, this.cc)) == null) continue;
            for (SpringBeanProperty springBeanProperty : set) {
                this.processPropertyOccurrence(springBeanProperty, springBean, typeElement, collection2, list);
            }
        }
    }

    private void processPropertyOccurrence(SpringBeanProperty springBeanProperty, SpringBean springBean, TypeElement typeElement, Collection<ExecutableElement> collection, List<Occurrences.Occurrence> list) throws BadLocationException {
        String string = springBeanProperty.getName();
        if (this.renamedProperty.getType() == PropertyType.WRITE_ONLY && !string.contains(".") && string.equals(this.renamedProperty.getOldName())) {
            this.addSimpleSetterOccurrences(springBeanProperty, springBean, typeElement, collection, list);
            return;
        }
        if (string.contains(" ")) {
            return;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return;
        }
        if (this.renamedProperty.getType() == PropertyType.WRITE_ONLY && stringArray[stringArray.length - 1].equals(this.renamedProperty.getOldName())) {
            this.addSetterInPathOccurrence(string, stringArray, springBean, typeElement.asType(), collection, list);
            return;
        }
        if (this.renamedProperty.getType() == PropertyType.READ_ONLY) {
            for (String string2 : stringArray) {
                if (!string2.equals(this.renamedProperty.getOldName())) continue;
                this.addGetterInPathOccurrences(string, stringArray, springBean, typeElement.asType(), collection, list);
                return;
            }
        }
    }

    private void addSimpleSetterOccurrences(SpringBeanProperty springBeanProperty, SpringBean springBean, TypeElement typeElement, Collection<ExecutableElement> collection, List<Occurrences.Occurrence> list) throws BadLocationException {
        PositionRef positionRef;
        PositionRef positionRef2;
        String string;
        BaseDocument baseDocument;
        Object object;
        String string2;
        if (typeElement == null) {
            return;
        }
        PropertyFinder propertyFinder = new PropertyFinder(typeElement.asType(), springBeanProperty.getName(), this.cc.getElementUtilities(), MatchType.EXACT);
        Property[] propertyArray = propertyFinder.findProperties();
        if (propertyArray == null || propertyArray.length == 0) {
            return;
        }
        ExecutableElement executableElement = propertyArray[0].getSetter();
        if (executableElement == null) {
            return;
        }
        if (!this.isSameOrOverrides(executableElement, collection)) {
            return;
        }
        Location location = springBean.getLocation();
        if (location == null) {
            return;
        }
        int n = location.getOffset();
        if (n == -1) {
            return;
        }
        PropertyChildFinder propertyChildFinder = new PropertyChildFinder(this.syntaxSupport, n);
        String string3 = springBeanProperty.getName();
        if (propertyChildFinder.find(string3)) {
            int n2 = propertyChildFinder.getFoundOffset();
            string2 = propertyChildFinder.getValue();
            int n3 = string2.indexOf(string3);
            if (n3 != -1) {
                object = this.createPropertyChildDisplayText(string2, n3, string3.length());
                PositionRef positionRef3 = this.docAccess.createPositionRef(n2 + n3, Position.Bias.Forward);
                PositionRef positionRef4 = this.docAccess.createPositionRef(n2 + n3 + string3.length(), Position.Bias.Backward);
                list.add(new PropertyRefOccurrence((String)object, this.docAccess.getFileObject(), new PositionBounds(positionRef3, positionRef4)));
            }
        }
        if ((string2 = SpringXMLConfigEditorUtils.getPNamespacePrefix((Document)(baseDocument = this.syntaxSupport.getDocument()), n)) == null) {
            return;
        }
        object = new AttributeFinder(this.syntaxSupport, n);
        String string4 = string2 + ":" + string3;
        if (((AttributeFinder)object).find(string4)) {
            int n4 = ((AttributeFinder)object).getFoundOffset();
            int n5 = string4.indexOf(string3);
            if (n5 != -1) {
                string = this.createPropertyAttributeDisplayText(string4, n5, string3.length());
                positionRef2 = this.docAccess.createPositionRef(n4 + n5, Position.Bias.Forward);
                positionRef = this.docAccess.createPositionRef(n4 + n5 + string3.length(), Position.Bias.Backward);
                list.add(new PropertyRefOccurrence(string, this.docAccess.getFileObject(), new PositionBounds(positionRef2, positionRef)));
            }
        }
        if (((AttributeFinder)object).find(string4 = string4 + "-ref")) {
            int n6 = ((AttributeFinder)object).getFoundOffset();
            int n7 = string4.indexOf(string3);
            if (n7 != -1) {
                string = this.createPropertyAttributeDisplayText(string4, n7, string3.length());
                positionRef2 = this.docAccess.createPositionRef(n6 + n7, Position.Bias.Forward);
                positionRef = this.docAccess.createPositionRef(n6 + n7 + string3.length(), Position.Bias.Backward);
                list.add(new PropertyRefOccurrence(string, this.docAccess.getFileObject(), new PositionBounds(positionRef2, positionRef)));
            }
        }
    }

    private void addSetterInPathOccurrence(String string, String[] stringArray, SpringBean springBean, TypeMirror typeMirror, Collection<ExecutableElement> collection, List<Occurrences.Occurrence> list) throws BadLocationException {
        Location location = springBean.getLocation();
        if (location == null) {
            return;
        }
        int n = location.getOffset();
        if (n == -1) {
            return;
        }
        PropertyChildFinder propertyChildFinder = new PropertyChildFinder(this.syntaxSupport, n);
        if (!propertyChildFinder.find(string)) {
            return;
        }
        int n2 = propertyChildFinder.getFoundOffset();
        String string2 = propertyChildFinder.getValue();
        int n3 = string2.indexOf(string);
        if (n3 == -1) {
            return;
        }
        PropertyPathElement[] propertyPathElementArray = this.evaluatePropertyPath(this.cc.getElementUtilities(), typeMirror, stringArray);
        if (propertyPathElementArray.length <= 1) {
            return;
        }
        PropertyPathElement propertyPathElement = propertyPathElementArray[propertyPathElementArray.length - 1];
        if (!this.isSameOrOverrides(propertyPathElement.getProperty().getSetter(), collection)) {
            return;
        }
        String string3 = this.createPropertyChildDisplayText(string2, n3 + propertyPathElement.getStartIndex(), propertyPathElement.getEndIndex() - propertyPathElement.getStartIndex());
        PositionRef positionRef = this.docAccess.createPositionRef(n2 + n3 + propertyPathElement.getStartIndex(), Position.Bias.Forward);
        PositionRef positionRef2 = this.docAccess.createPositionRef(n2 + n3 + propertyPathElement.getEndIndex(), Position.Bias.Backward);
        list.add(new PropertyRefOccurrence(string3, this.docAccess.getFileObject(), new PositionBounds(positionRef, positionRef2)));
    }

    private boolean isSameOrOverrides(ExecutableElement executableElement, Collection<ExecutableElement> collection) {
        for (ExecutableElement executableElement2 : collection) {
            if (!executableElement.equals(executableElement2) && !this.cc.getElements().overrides(executableElement, executableElement2, (TypeElement)executableElement.getEnclosingElement())) continue;
            return true;
        }
        return false;
    }

    private void addGetterInPathOccurrences(String string, String[] stringArray, SpringBean springBean, TypeMirror typeMirror, Collection<ExecutableElement> collection, List<Occurrences.Occurrence> list) throws BadLocationException {
        Location location = springBean.getLocation();
        if (location == null) {
            return;
        }
        int n = location.getOffset();
        if (n == -1) {
            return;
        }
        PropertyChildFinder propertyChildFinder = new PropertyChildFinder(this.syntaxSupport, n);
        if (!propertyChildFinder.find(string)) {
            return;
        }
        int n2 = propertyChildFinder.getFoundOffset();
        String string2 = propertyChildFinder.getValue();
        int n3 = string2.indexOf(string);
        if (n3 == -1) {
            return;
        }
        PropertyPathElement[] propertyPathElementArray = this.evaluatePropertyPath(this.cc.getElementUtilities(), typeMirror, stringArray);
        if (propertyPathElementArray.length <= 1) {
            return;
        }
        for (int i = 0; i < propertyPathElementArray.length - 1; ++i) {
            PropertyPathElement propertyPathElement = propertyPathElementArray[i];
            if (!this.isSameOrOverrides(propertyPathElement.getProperty().getSetter(), collection)) {
                return;
            }
            String string3 = this.createPropertyChildDisplayText(string2, n3 + propertyPathElement.getStartIndex(), propertyPathElement.getEndIndex() - propertyPathElement.getStartIndex());
            PositionRef positionRef = this.docAccess.createPositionRef(n2 + n3 + propertyPathElement.getStartIndex(), Position.Bias.Forward);
            PositionRef positionRef2 = this.docAccess.createPositionRef(n2 + n3 + propertyPathElement.getEndIndex(), Position.Bias.Backward);
            list.add(new PropertyRefOccurrence(string3, this.docAccess.getFileObject(), new PositionBounds(positionRef, positionRef2)));
        }
    }

    private String createPropertyChildDisplayText(String string, int n, int n2) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&lt;property");
        String string2 = this.escapeAttrValue(string.substring(0, n));
        String string3 = this.escapeAttrValue(string.substring(n, n + n2));
        String string4 = this.escapeAttrValue(string.substring(n + n2, string.length()));
        if (string2 != null && string3 != null && string4 != null) {
            stringBuilder.append(" name=");
            stringBuilder.append(string2).append("<b>").append(string3).append("</b>").append(string4);
        }
        return stringBuilder.toString();
    }

    private String createPropertyAttributeDisplayText(String string, int n, int n2) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n + n2);
        String string4 = this.escapeAttrValue(string.substring(n + n2, string.length()));
        if (string2 != null && string3 != null && string4 != null) {
            stringBuilder.append(string2).append("<b>").append(string3).append("</b>").append(string4);
        }
        return stringBuilder.toString();
    }

    private String escapeAttrValue(String string) {
        try {
            return XMLUtil.toAttributeValue((String)string);
        }
        catch (CharConversionException charConversionException) {
            return null;
        }
    }

    private PropertyPathElement[] evaluatePropertyPath(ElementUtilities elementUtilities, TypeMirror typeMirror, String[] stringArray) {
        ArrayList<PropertyPathElement> arrayList = new ArrayList<PropertyPathElement>(stringArray.length);
        int n = 0;
        TypeMirror typeMirror2 = typeMirror;
        for (int i = 0; i < stringArray.length; ++i) {
            if (typeMirror2 == null) {
                return new PropertyPathElement[0];
            }
            Property[] propertyArray = new PropertyFinder(typeMirror2, stringArray[i], elementUtilities, MatchType.EXACT).findProperties();
            if (propertyArray != null && propertyArray.length > 0) {
                arrayList.add(new PropertyPathElement(propertyArray[0], n, n + stringArray[i].length()));
                typeMirror2 = propertyArray[0].getImplementationType();
                n += stringArray[i].length() + 1;
                continue;
            }
            return new PropertyPathElement[0];
        }
        return arrayList.toArray(new PropertyPathElement[0]);
    }

    private static final class PropertyPathElement {
        private final Property property;
        private final int startOffset;
        private final int endOffset;

        public PropertyPathElement(Property property, int n, int n2) {
            this.property = property;
            this.startOffset = n;
            this.endOffset = n2;
        }

        public Property getProperty() {
            return this.property;
        }

        public int getStartIndex() {
            return this.startOffset;
        }

        public int getEndIndex() {
            return this.endOffset;
        }
    }

    private static final class PropertyRefOccurrence
    extends Occurrences.Occurrence {
        private final String displayText;

        PropertyRefOccurrence(String string, FileObject fileObject, PositionBounds positionBounds) {
            super(fileObject, positionBounds);
            this.displayText = string;
        }

        public String getDisplayText() {
            return this.displayText;
        }
    }
}

