/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeFree
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int methodId;
    protected int nCalls;
    protected long sleepTime0;
    protected long totalTime0;
    protected long totalTime1;
    protected long waitTime0;

    protected PrestimeCPUCCTNodeFree(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        super(cPUCCTContainer, prestimeCPUCCTNode);
        this.methodId = n;
    }

    public CCTNode getChild(int n) {
        return this.children[n];
    }

    public CCTNode[] getChildren() {
        return this.children;
    }

    public void setMethodId(int n) {
        this.methodId = n;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public int getNCalls() {
        return this.nCalls;
    }

    public int getNChildren() {
        return this.children != null ? this.children.length : 0;
    }

    public long getSleepTime0() {
        return 0L;
    }

    public int getThreadId() {
        return this.container.getThreadId();
    }

    public long getTotalTime0() {
        return this.totalTime0;
    }

    public float getTotalTime0InPerCent() {
        float f = (float)((double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0);
        return f < 100.0f ? f : 100.0f;
    }

    public long getTotalTime1() {
        return this.totalTime1;
    }

    public float getTotalTime1InPerCent() {
        return (float)((double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0);
    }

    public long getWaitTime0() {
        return 0L;
    }

    public void addChild(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree) {
        if (this.children == null) {
            this.children = new PrestimeCPUCCTNodeFree[1];
        } else {
            PrestimeCPUCCTNodeFree[] prestimeCPUCCTNodeFreeArray = new PrestimeCPUCCTNodeFree[this.children.length + 1];
            System.arraycopy(this.children, 0, prestimeCPUCCTNodeFreeArray, 0, this.children.length);
            this.children = prestimeCPUCCTNodeFreeArray;
        }
        this.children[this.children.length - 1] = prestimeCPUCCTNodeFree;
    }

    public void addNCalls(int n) {
        this.nCalls += n;
    }

    public void addSleepTime0(long l) {
        this.sleepTime0 += l;
    }

    public void addTotalTime0(long l) {
        this.totalTime0 += l;
    }

    public void addTotalTime1(long l) {
        this.totalTime1 += l;
    }

    public void addWaitTime0(long l) {
        this.waitTime0 += l;
    }

    public PrestimeCPUCCTNodeFree createChildlessCopy() {
        try {
            PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree = (PrestimeCPUCCTNodeFree)this.clone();
            prestimeCPUCCTNodeFree.children = null;
            return prestimeCPUCCTNodeFree;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void sortChildren(int n, boolean bl) {
        if (this.children != null) {
            this.doSortChildren(n, bl);
        }
    }

    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<node>" + string2);
        stringBuffer.append(string + " <Name>" + this.replaceHTMLCharacters(this.getNodeName()) + "</Name>" + string2);
        stringBuffer.append(string + " <Parent>" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeFree)this.getParent()).getNodeName()) + "</Parent>" + string2);
        stringBuffer.append(string + " <Time_Relative>" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</Time_Relative>" + string2);
        stringBuffer.append(string + " <Time>" + this.getTotalTime0() + "</Time>" + string2);
        stringBuffer.append(string + " <Invocations>" + this.getNCalls() + "</Invocations>" + string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportXMLData(exportDataDumper, string + "  ");
            }
        }
        stringBuffer = new StringBuffer(string + "</node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName()) + "</pre></td><td class=\"right\">" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</td><td class=\"right\">" + this.getTotalTime0() + "</td><td class=\"right\">" + this.getNCalls() + "</td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.getNChildren(); ++n2) {
                ((PrestimeCPUCCTNodeFree)this.children[n2]).exportHTMLData(exportDataDumper, n + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.getNodeName() + string3 + string);
        stringBuffer.append(string3 + this.getTotalTime0InPerCent() + string3 + string);
        stringBuffer.append(string3 + this.getTotalTime0() + string3 + string);
        stringBuffer.append(string3 + this.getNCalls() + string3 + string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.getNChildren(); ++n2) {
                ((PrestimeCPUCCTNodeFree)this.children[n2]).exportCSVData(string, n + 1, exportDataDumper);
            }
        }
    }

    public static void setPercentFormat(NumberFormat numberFormat) {
        percentFormat = numberFormat;
    }
}

