/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;

class HprofFileBuffer
extends HprofByteBuffer {
    private static final int MAX_bufferSizeBits = 17;
    private static final int MIN_bufferSizeBits = 7;
    private static final int MIN_bufferSize = 128;
    private static final int MIN_bufferSizeMask = 127;
    private static final int BUFFER_EXT = 8;
    private static int bufferSizeBits;
    private static int bufferSize;
    RandomAccessFile fis;
    private byte[] dumpBuffer;
    private long bufferStartOffset;

    HprofFileBuffer(File file) throws IOException {
        this.fis = new RandomAccessFile(file, "r");
        this.length = this.fis.length();
        this.bufferStartOffset = Long.MAX_VALUE;
        this.readHeader();
    }

    synchronized char getChar(long l) {
        int n = this.loadBufferIfNeeded(l);
        int n2 = this.dumpBuffer[n++] & 0xFF;
        int n3 = this.dumpBuffer[n] & 0xFF;
        return (char)((n2 << 8) + (n3 << 0));
    }

    synchronized double getDouble(long l) {
        int n = this.loadBufferIfNeeded(l);
        return Double.longBitsToDouble(this.getLong(n));
    }

    synchronized float getFloat(long l) {
        int n = this.loadBufferIfNeeded(l);
        return Float.intBitsToFloat(this.getInt(n));
    }

    synchronized int getInt(long l) {
        int n = this.loadBufferIfNeeded(l);
        int n2 = this.dumpBuffer[n++] & 0xFF;
        int n3 = this.dumpBuffer[n++] & 0xFF;
        int n4 = this.dumpBuffer[n++] & 0xFF;
        int n5 = this.dumpBuffer[n] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    synchronized long getLong(long l) {
        return ((long)this.getInt(l) << 32) + ((long)this.getInt(l + 4L) & 0xFFFFFFFFL);
    }

    synchronized short getShort(long l) {
        int n = this.loadBufferIfNeeded(l);
        int n2 = this.dumpBuffer[n++] & 0xFF;
        int n3 = this.dumpBuffer[n] & 0xFF;
        return (short)((n2 << 8) + (n3 << 0));
    }

    synchronized byte get(long l) {
        int n = this.loadBufferIfNeeded(l);
        return this.dumpBuffer[n];
    }

    synchronized void get(long l, byte[] byArray) {
        int n = this.loadBufferIfNeeded(l);
        if (n + byArray.length < this.dumpBuffer.length) {
            System.arraycopy(this.dumpBuffer, n, byArray, 0, byArray.length);
        } else {
            try {
                this.fis.seek(l);
                this.fis.readFully(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setBufferSize(long l) {
        if (l > this.bufferStartOffset && l < this.bufferStartOffset + (long)(2 * bufferSize)) {
            if (bufferSizeBits < 17) {
                this.setBufferSize(bufferSizeBits + 1);
            }
        } else {
            this.setBufferSize(7);
        }
    }

    private void setBufferSize(int n) {
        bufferSizeBits = n;
        bufferSize = 1 << bufferSizeBits;
        this.dumpBuffer = new byte[bufferSize + 8];
    }

    private int loadBufferIfNeeded(long l) {
        if (l >= this.bufferStartOffset && l < this.bufferStartOffset + (long)bufferSize) {
            return (int)(l - this.bufferStartOffset);
        }
        long l2 = l & 0xFFFFFFFFFFFFFF80L;
        this.setBufferSize(l2);
        try {
            this.fis.seek(l2);
            this.fis.readFully(this.dumpBuffer);
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.bufferStartOffset = l2;
        return (int)(l - this.bufferStartOffset);
    }
}

