/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;

class HprofArrayValue
implements ArrayItemValue {
    final ClassDump dumpClass;
    final int index;
    final long instanceArrayOffset;

    HprofArrayValue(ClassDump classDump, long l, int n) {
        this.dumpClass = classDump;
        this.instanceArrayOffset = l;
        this.index = n;
    }

    public Instance getDefiningInstance() {
        return new ObjectArrayDump(this.dumpClass, this.instanceArrayOffset);
    }

    public int getIndex() {
        return this.index;
    }

    public Instance getInstance() {
        HprofHeap hprofHeap = this.dumpClass.getHprof();
        HprofByteBuffer hprofByteBuffer = hprofHeap.dumpBuffer;
        int n = hprofByteBuffer.getIDSize();
        long l = hprofByteBuffer.getID(this.instanceArrayOffset + 1L + (long)n + 4L + 4L + (long)n + (long)(this.index * n));
        return hprofHeap.getInstanceByID(l);
    }
}

