/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.api.ui;

import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphUI;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class CallGraphModelFactory {
    private static final CallGraphModelFactory DEFAULT = new Default();

    protected CallGraphModelFactory() {
    }

    public abstract CallModel getModel(Node[] var1);

    public abstract CallGraphUI getUI(CallModel var1);

    public abstract boolean isCallGraphAvailiable(Node[] var1);

    public static CallGraphModelFactory getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends CallGraphModelFactory {
        private final Lookup.Result<CallGraphModelFactory> res = Lookup.getDefault().lookupResult(CallGraphModelFactory.class);

        private Default() {
        }

        public CallModel getModel(Node[] nodeArray) {
            for (CallGraphModelFactory callGraphModelFactory : this.res.allInstances()) {
                CallModel callModel = callGraphModelFactory.getModel(nodeArray);
                if (callModel == null) continue;
                return callModel;
            }
            return null;
        }

        public CallGraphUI getUI(CallModel callModel) {
            for (CallGraphModelFactory callGraphModelFactory : this.res.allInstances()) {
                CallGraphUI callGraphUI = callGraphModelFactory.getUI(callModel);
                if (callGraphUI == null) continue;
                return callGraphUI;
            }
            return null;
        }

        public boolean isCallGraphAvailiable(Node[] nodeArray) {
            for (CallGraphModelFactory callGraphModelFactory : this.res.allInstances()) {
                if (!callGraphModelFactory.isCallGraphAvailiable(nodeArray)) continue;
                return true;
            }
            return false;
        }
    }
}

