/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.impl.application.ApplicationProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final String APP_13_DOCTYPE = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    private static final DDProvider ddProvider = new DDProvider();
    private final Map ddMap;
    private static final Logger LOGGER = Logger.getLogger(DDProvider.class.getName());
    ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/dd/Bundle");

    private DDProvider() {
        this.ddMap = new HashMap(5);
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Application getDDRoot(FileObject fileObject) throws IOException {
        Application application;
        Object object;
        ApplicationProxy applicationProxy;
        block12: {
            if (fileObject == null) {
                return null;
            }
            applicationProxy = null;
            object = this.ddMap;
            synchronized (object) {
                applicationProxy = this.getFromCache(fileObject);
                if (applicationProxy != null) {
                    return applicationProxy;
                }
            }
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileChanged(FileEvent fileEvent) {
                    FileObject fileObject = fileEvent.getFile();
                    try {
                        Map map = DDProvider.this.ddMap;
                        synchronized (map) {
                            ApplicationProxy applicationProxy = DDProvider.this.getFromCache(fileObject);
                            String string = null;
                            if (applicationProxy != null) {
                                try {
                                    DDParse dDParse = DDProvider.this.parseDD(fileObject);
                                    string = dDParse.getVersion();
                                    DDProvider.setProxyErrorStatus(applicationProxy, dDParse);
                                    Application application = DDProvider.createApplication(dDParse);
                                    if (!string.equals(applicationProxy.getVersion().toString())) {
                                        applicationProxy.setOriginal(application);
                                    } else if (applicationProxy.getOriginal() == null) {
                                        applicationProxy.setOriginal(application);
                                    } else {
                                        applicationProxy.getOriginal().merge(application, 3);
                                    }
                                }
                                catch (SAXException sAXException) {
                                    if (sAXException instanceof SAXParseException) {
                                        applicationProxy.setError((SAXParseException)sAXException);
                                    } else if (sAXException.getException() instanceof SAXParseException) {
                                        applicationProxy.setError((SAXParseException)sAXException.getException());
                                    }
                                    applicationProxy.setStatus(2);
                                    applicationProxy.setProxyVersion(string);
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, "Merging of Application graphs failed", iOException);
                    }
                }
            });
            try {
                object = this.parseDD(fileObject);
                application = DDProvider.createApplication((DDParse)object);
                applicationProxy = new ApplicationProxy(application, ((DDParse)object).getVersion());
                DDProvider.setProxyErrorStatus(applicationProxy, (DDParse)object);
            }
            catch (SAXException sAXException) {
                applicationProxy = new ApplicationProxy(org.netbeans.modules.j2ee.dd.impl.application.model_1_4.Application.createGraph(), "2.0");
                applicationProxy.setStatus(2);
                if (sAXException instanceof SAXParseException) {
                    applicationProxy.setError((SAXParseException)sAXException);
                }
                if (!(sAXException.getException() instanceof SAXParseException)) break block12;
                applicationProxy.setError((SAXParseException)sAXException.getException());
            }
        }
        object = this.ddMap;
        synchronized (object) {
            application = this.getFromCache(fileObject);
            if (application != null) {
                return application;
            }
            this.ddMap.put(fileObject, applicationProxy);
        }
        return applicationProxy;
    }

    public Application getDDRootCopy(FileObject fileObject) throws IOException {
        return (Application)this.getDDRoot(fileObject).clone();
    }

    private ApplicationProxy getFromCache(FileObject fileObject) {
        return (ApplicationProxy)this.ddMap.get(fileObject);
    }

    public Application getDDRoot(InputSource inputSource) throws IOException, SAXException {
        DDParse dDParse = this.parseDD(inputSource);
        Application application = DDProvider.createApplication(dDParse);
        ApplicationProxy applicationProxy = new ApplicationProxy(application, application.getVersion().toString());
        DDProvider.setProxyErrorStatus(applicationProxy, dDParse);
        return applicationProxy;
    }

    public BaseBean getBaseBean(CommonDDBean commonDDBean) {
        if (commonDDBean instanceof BaseBean) {
            return (BaseBean)commonDDBean;
        }
        if (commonDDBean instanceof ApplicationProxy) {
            return (BaseBean)((ApplicationProxy)commonDDBean).getOriginal();
        }
        return null;
    }

    private static void setProxyErrorStatus(ApplicationProxy applicationProxy, DDParse dDParse) {
        SAXParseException sAXParseException = dDParse.getWarning();
        applicationProxy.setError(sAXParseException);
        if (sAXParseException != null) {
            applicationProxy.setStatus(1);
        } else {
            applicationProxy.setStatus(0);
        }
    }

    private static Application createApplication(DDParse dDParse) {
        Application application = null;
        String string = dDParse.getVersion();
        if ("1.4".equals(string)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_1_4.Application(dDParse.getDocument(), 1);
        }
        if ("5".equals(string)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_5.Application(dDParse.getDocument(), 1);
        }
        if ("6".equals(string)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_6.Application(dDParse.getDocument(), 1);
        }
        return application;
    }

    public SAXParseException parse(FileObject fileObject) throws SAXException, IOException {
        DDParse dDParse = this.parseDD(fileObject);
        return dDParse.getWarning();
    }

    private DDParse parseDD(FileObject fileObject) throws SAXException, IOException {
        return this.parseDD(fileObject.getInputStream());
    }

    private DDParse parseDD(InputStream inputStream) throws SAXException, IOException {
        return this.parseDD(new InputSource(inputStream));
    }

    private DDParse parseDD(InputSource inputSource) throws SAXException, IOException {
        Object object;
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder documentBuilder = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.getMessage());
        }
        documentBuilder.setErrorHandler(errorHandler);
        documentBuilder.setEntityResolver(DDResolver.getInstance());
        object = documentBuilder.parse(inputSource);
        SAXParseException sAXParseException = errorHandler.getError();
        return new DDParse((Document)object, sAXParseException);
    }

    private static class DDParse {
        private final Document document;
        private final SAXParseException saxException;
        private String version;

        public DDParse(Document document, SAXParseException sAXParseException) {
            this.document = document;
            this.saxException = sAXParseException;
            this.extractVersion();
        }

        public Document getDocument() {
            return this.document;
        }

        private void extractVersion() {
            Node node;
            NamedNodeMap namedNodeMap;
            Node node2;
            NodeList nodeList;
            this.version = "6";
            DocumentType documentType = this.document.getDoctype();
            if (documentType == null && (nodeList = this.document.getElementsByTagName("application")) != null && nodeList.getLength() > 0 && (node2 = (namedNodeMap = (node = nodeList.item(0)).getAttributes()).getNamedItem("version")) != null) {
                String string = node2.getNodeValue();
                this.version = "1.4".equals(string) ? "1.4" : ("5".equals(string) ? "5" : "6");
            }
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String string, String string2) {
            if ("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application_1_4.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application_5.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_5.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application_6.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_6.xsd");
            }
            return null;
        }
    }
}

