/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;

public class CrossBorderLayout
implements LayoutManager2 {
    private static final int NONE = Integer.MIN_VALUE;
    private Map<Component, Integer[]> map = new HashMap<Component, Integer[]>();
    private Component north;
    private Component west;
    private Component south;
    private Component east;
    private Component center;

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof Integer[])) {
            throw new IllegalArgumentException("Illegal constraints: " + object);
        }
        this.addLayoutComponent(component, (Integer[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component == this.center) {
                this.center = null;
                this.map.remove(this.center);
            } else if (component == this.north) {
                this.north = null;
                this.map.remove(this.north);
            } else if (component == this.south) {
                this.south = null;
                this.map.remove(this.south);
            } else if (component == this.east) {
                this.east = null;
                this.map.remove(this.east);
            } else if (component == this.west) {
                this.west = null;
                this.map.remove(this.west);
            }
        }
    }

    public Component getLayoutComponent(int n) {
        if (n == 1) {
            return this.north;
        }
        if (n == 7) {
            return this.west;
        }
        if (n == 5) {
            return this.south;
        }
        if (n == 3) {
            return this.east;
        }
        if (n == 0) {
            return this.center;
        }
        throw new IllegalArgumentException("Illegal constraint: " + CrossBorderLayout.constraintName(n));
    }

    public Object getConstraints(Component component) {
        if (component == null) {
            return null;
        }
        return this.map.get(component);
    }

    public Object getConstraints(int n) {
        Component component = this.getLayoutComponent(n);
        if (component == null) {
            return null;
        }
        return this.map.get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Dimension dimension2 = new Dimension(0, 0);
            Dimension dimension3 = dimension = this.center != null ? this.center.getPreferredSize() : null;
            if (this.north != null) {
                dimension2.height += this.north.getPreferredSize().height;
            }
            if (dimension != null) {
                dimension2.height += dimension.height;
            }
            if (this.south != null) {
                dimension2.height += this.south.getPreferredSize().height;
            }
            if (this.west != null) {
                dimension2.width += this.west.getPreferredSize().width;
            }
            if (dimension != null) {
                dimension2.width += dimension.width;
            }
            if (this.east != null) {
                dimension2.width += this.east.getPreferredSize().width;
            }
            Insets insets = container.getInsets();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            return dimension2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension;
            Dimension dimension2 = new Dimension(0, 0);
            Dimension dimension3 = dimension = this.center != null ? this.center.getMinimumSize() : null;
            if (this.north != null) {
                dimension2.height += this.north.getMinimumSize().height;
            }
            if (dimension != null) {
                dimension2.height += dimension.height;
            }
            if (this.south != null) {
                dimension2.height += this.south.getMinimumSize().height;
            }
            if (this.west != null) {
                dimension2.width += this.west.getMinimumSize().width;
            }
            if (dimension != null) {
                dimension2.width += dimension.width;
            }
            if (this.east != null) {
                dimension2.width += this.east.getMinimumSize().width;
            }
            Insets insets = container.getInsets();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            return dimension2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            Integer[] integerArray;
            int n3;
            Insets insets = container.getInsets();
            int n4 = insets.top;
            int n5 = container.getHeight() - insets.bottom;
            int n6 = container.getHeight() - insets.bottom - insets.top;
            int n7 = insets.left;
            int n8 = container.getWidth() - insets.right;
            int n9 = container.getWidth() - insets.right - insets.left;
            int n10 = this.north != null ? this.north.getPreferredSize().height : 0;
            int n11 = this.south != null ? this.south.getPreferredSize().height : 0;
            int n12 = this.west != null ? this.west.getPreferredSize().width : 0;
            int n13 = n3 = this.east != null ? this.east.getPreferredSize().width : 0;
            if (this.center != null) {
                this.center.setBounds(n7 + n12, n4 + n10, n9 - n3 - n12, n6 - n11 - n10);
            }
            if (this.north != null) {
                integerArray = this.map.get(this.north);
                n2 = integerArray[0] != Integer.MIN_VALUE ? n12 : 0;
                n = integerArray[2] != Integer.MIN_VALUE ? n3 : 0;
                this.north.setBounds(n7 + n12 - n2, n4, n9 - n3 - n12 + n2 + n, n10);
            }
            if (this.south != null) {
                integerArray = this.map.get(this.south);
                n2 = integerArray[0] != Integer.MIN_VALUE ? n12 : 0;
                n = integerArray[2] != Integer.MIN_VALUE ? n3 : 0;
                this.south.setBounds(n7 + n12 - n2, n5 - n11, n9 - n3 - n12 + n2 + n, n11);
            }
            if (this.west != null) {
                integerArray = this.map.get(this.west);
                n2 = integerArray[0] != Integer.MIN_VALUE ? n10 : 0;
                n = integerArray[2] != Integer.MIN_VALUE ? n11 : 0;
                this.west.setBounds(n7, n4 + n10 - n2, n12, n6 - n11 - n10 + n2 + n);
            }
            if (this.east != null) {
                integerArray = this.map.get(this.east);
                n2 = integerArray[0] != Integer.MIN_VALUE ? n10 : 0;
                n = integerArray[2] != Integer.MIN_VALUE ? n11 : 0;
                this.east.setBounds(n8 - n3, n4 + n10 - n2, n3, n6 - n11 - n10 + n2 + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLayoutComponent(Component component, Integer[] integerArray) {
        if (integerArray.length == 0) {
            throw new IllegalArgumentException("At least one location is required: " + CrossBorderLayout.toString(integerArray));
        }
        if (integerArray.length > 3) {
            throw new IllegalArgumentException("Up to three locations are required: " + CrossBorderLayout.toString(integerArray));
        }
        integerArray = CrossBorderLayout.normalizedConstraints(integerArray);
        Object object = component.getTreeLock();
        synchronized (object) {
            if (CrossBorderLayout.isNorth(integerArray)) {
                this.north = component;
                this.map.put(component, integerArray);
            } else if (CrossBorderLayout.isWest(integerArray)) {
                this.west = component;
                this.map.put(component, integerArray);
            } else if (CrossBorderLayout.isSouth(integerArray)) {
                this.south = component;
                this.map.put(component, integerArray);
            } else if (CrossBorderLayout.isEast(integerArray)) {
                this.east = component;
                this.map.put(component, integerArray);
            } else if (CrossBorderLayout.isCenter(integerArray)) {
                this.center = component;
                this.map.put(component, integerArray);
            }
        }
    }

    private static boolean isNorth(Integer[] integerArray) {
        return integerArray[1] == 1;
    }

    private static boolean isWest(Integer[] integerArray) {
        return integerArray[1] == 7;
    }

    private static boolean isSouth(Integer[] integerArray) {
        return integerArray[1] == 5;
    }

    private static boolean isEast(Integer[] integerArray) {
        return integerArray[1] == 3;
    }

    private static boolean isCenter(Integer[] integerArray) {
        return integerArray[1] == 0;
    }

    private static boolean isBasis(int n) {
        if (n == 1) {
            return true;
        }
        if (n == 7) {
            return true;
        }
        if (n == 5) {
            return true;
        }
        if (n == 3) {
            return true;
        }
        return n == 0;
    }

    private static void checkSupported(int n) {
        if (n == 1) {
            return;
        }
        if (n == 7) {
            return;
        }
        if (n == 5) {
            return;
        }
        if (n == 3) {
            return;
        }
        if (n == 8) {
            return;
        }
        if (n == 2) {
            return;
        }
        if (n == 6) {
            return;
        }
        if (n == 4) {
            return;
        }
        if (n == 0) {
            return;
        }
        throw new IllegalArgumentException("Unsupported constraint: " + n);
    }

    private static void checkDefining(Integer[] integerArray) {
        boolean bl;
        boolean bl2 = CrossBorderLayout.isBasis(integerArray[0]);
        boolean bl3 = integerArray.length > 1 ? CrossBorderLayout.isBasis(integerArray[1]) : false;
        boolean bl4 = bl = integerArray.length == 3 ? CrossBorderLayout.isBasis(integerArray[2]) : false;
        if (!(bl2 || bl3 || bl)) {
            throw new IllegalArgumentException("Constraint does not define position: " + CrossBorderLayout.toString(integerArray));
        }
        if (bl2 && bl3 || bl2 && bl || bl3 && bl) {
            throw new IllegalArgumentException("Constraint defines more than one position: " + CrossBorderLayout.toString(integerArray));
        }
    }

    private static Integer[] normalizedConstraints(Integer[] integerArray) {
        int n;
        Integer[] integerArray2 = integerArray;
        int n2 = integerArray2.length;
        for (n = 0; n < n2; ++n) {
            int n3 = integerArray2[n];
            CrossBorderLayout.checkSupported(n3);
        }
        CrossBorderLayout.checkDefining(integerArray);
        integerArray2 = null;
        integerArray2 = integerArray.length == 1 ? new Integer[]{Integer.MIN_VALUE, integerArray[0], Integer.MIN_VALUE} : (integerArray.length == 2 ? new Integer[]{integerArray[0], integerArray[1], Integer.MIN_VALUE} : integerArray);
        if (CrossBorderLayout.isBasis(integerArray2[0])) {
            n2 = integerArray2[0];
            integerArray2[0] = integerArray2[1];
            integerArray2[1] = n2;
        } else if (CrossBorderLayout.isBasis(integerArray2[2])) {
            n2 = integerArray2[2];
            integerArray2[2] = integerArray2[1];
            integerArray2[1] = n2;
        }
        n2 = integerArray2[0];
        n = integerArray2[2];
        if (n2 != Integer.MIN_VALUE && n2 == n) {
            throw new IllegalArgumentException("Duplicite constraints: " + CrossBorderLayout.toString(integerArray));
        }
        if (CrossBorderLayout.isCenter(integerArray2)) {
            if (n2 != Integer.MIN_VALUE || n != Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Constraint CENTER must be used standalone: " + CrossBorderLayout.toString(integerArray));
            }
        } else {
            if (CrossBorderLayout.isNorth(integerArray2)) {
                if (n2 == 2) {
                    integerArray2[2] = n2;
                    integerArray2[0] = n;
                }
                n2 = integerArray2[0];
                n = integerArray2[2];
                if (n2 != Integer.MIN_VALUE && n2 != 8) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
                if (n != Integer.MIN_VALUE && n != 2) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
            } else if (CrossBorderLayout.isSouth(integerArray2)) {
                if (n2 == 4) {
                    integerArray2[2] = n2;
                    integerArray2[0] = n;
                }
                n2 = integerArray2[0];
                n = integerArray2[2];
                if (n2 != Integer.MIN_VALUE && n2 != 6) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
                if (n != Integer.MIN_VALUE && n != 4) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
            } else if (CrossBorderLayout.isWest(integerArray2)) {
                if (n2 == 6) {
                    integerArray2[2] = n2;
                    integerArray2[0] = n;
                }
                n2 = integerArray2[0];
                n = integerArray2[2];
                if (n2 != Integer.MIN_VALUE && n2 != 8) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
                if (n != Integer.MIN_VALUE && n != 6) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
            }
            if (CrossBorderLayout.isEast(integerArray2)) {
                if (n2 == 4) {
                    integerArray2[2] = n2;
                    integerArray2[0] = n;
                }
                n2 = integerArray2[0];
                n = integerArray2[2];
                if (n2 != Integer.MIN_VALUE && n2 != 2) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
                if (n != Integer.MIN_VALUE && n != 4) {
                    throw new IllegalArgumentException("Constraints not compatible: " + CrossBorderLayout.toString(integerArray));
                }
            }
        }
        return integerArray2;
    }

    private static String toString(Integer[] integerArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            stringBuffer.append(stringBuffer.length() == 0 ? CrossBorderLayout.constraintName(n2) : ", " + CrossBorderLayout.constraintName(n2));
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("[");
        } else {
            stringBuffer.insert(0, "[");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String constraintName(int n) {
        if (n == 1) {
            return "NORTH";
        }
        if (n == 7) {
            return "WEST";
        }
        if (n == 5) {
            return "SOUTH";
        }
        if (n == 3) {
            return "EAST";
        }
        if (n == 8) {
            return "NORTH_WEST";
        }
        if (n == 2) {
            return "NORTH_EAST";
        }
        if (n == 6) {
            return "SOUTH_WEST";
        }
        if (n == 4) {
            return "SOUTH_EAST";
        }
        if (n == 0) {
            return "CENTER";
        }
        return "UNSUPPORTED_CONSTRAINT (value=" + n + ")";
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException("CrossBorderLayout.addLayoutComponent(String, Component) not supported, use CrossBorderLayout.addLayoutComponent(Component, Object)");
    }
}

