/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.canvas;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.canvas.TransformableCanvasComponent;

public abstract class InteractiveCanvasComponent
extends TransformableCanvasComponent {
    public static final int ZOOM_ALL = 0;
    public static final int ZOOM_X = 1;
    public static final int ZOOM_Y = 2;
    private ScrollBarManager hScrollBarManager;
    private ScrollBarManager vScrollBarManager;
    private MousePanHandler mousePanHandler;
    private int mousePanningButton = 1;
    private Cursor mousePanningCursor = Cursor.getPredefinedCursor(13);
    private int zoomMode;
    private double mouseZoomingFactor;
    private MouseZoomHandler mouseZoomHandler;

    public InteractiveCanvasComponent() {
        this.enableMousePanning();
        this.zoomMode = 0;
        this.mouseZoomingFactor = 1.05;
        this.enableMouseZooming();
    }

    public final void attachHorizontalScrollBar(JScrollBar jScrollBar) {
        if (this.hScrollBarManager == null) {
            this.hScrollBarManager = new ScrollBarManager();
        }
        this.hScrollBarManager.attachScrollBar(jScrollBar, true);
    }

    public final void detachHorizontalScrollBar() {
        if (this.hScrollBarManager != null) {
            this.hScrollBarManager.detachScrollBar();
        }
        this.hScrollBarManager = null;
    }

    public final void attachVerticalScrollBar(JScrollBar jScrollBar) {
        if (this.vScrollBarManager == null) {
            this.vScrollBarManager = new ScrollBarManager();
        }
        this.vScrollBarManager.attachScrollBar(jScrollBar, false);
    }

    public final void detachVerticalScrollBar() {
        if (this.vScrollBarManager != null) {
            this.vScrollBarManager.detachScrollBar();
        }
        this.vScrollBarManager = null;
    }

    private void updateScrollBars(boolean bl) {
        if (this.hScrollBarManager != null) {
            this.hScrollBarManager.syncScrollBar(bl);
        }
        if (this.vScrollBarManager != null) {
            this.vScrollBarManager.syncScrollBar(bl);
        }
    }

    protected void offsetChanged(long l, long l2, long l3, long l4) {
        super.offsetChanged(l, l2, l3, l4);
        this.updateScrollBars(true);
    }

    protected void scaleChanged(double d, double d2, double d3, double d4) {
        super.scaleChanged(d, d2, d3, d4);
        this.updateScrollBars(false);
    }

    protected void dataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        super.dataBoundsChanged(l, l2, l3, l4, l5, l6, l7, l8);
        this.updateScrollBars(false);
    }

    protected void reshaped(Rectangle rectangle, Rectangle rectangle2) {
        super.reshaped(rectangle, rectangle2);
        this.updateScrollBars(false);
    }

    public final void setMousePanningEnabled(boolean bl) {
        if (bl) {
            this.enableMousePanning();
        } else {
            this.disableMousePanning();
        }
    }

    public final void enableMousePanning() {
        if (this.mousePanHandler != null) {
            return;
        }
        this.mousePanHandler = new MousePanHandler();
        this.addMouseListener(this.mousePanHandler);
        this.addMouseMotionListener(this.mousePanHandler);
    }

    public final void disableMousePanning() {
        if (this.mousePanHandler == null) {
            return;
        }
        this.removeMouseListener(this.mousePanHandler);
        this.removeMouseMotionListener(this.mousePanHandler);
        this.mousePanHandler = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    public final boolean isMousePanningEnabled() {
        return this.mousePanHandler != null;
    }

    public final boolean panningPossible() {
        return this.getContentsWidth() > (long)this.getWidth() || this.getContentsHeight() > (long)this.getHeight();
    }

    public final void setMousePanningButton(int n) {
        this.mousePanningButton = n;
    }

    public final int getMousePanningButton() {
        return this.mousePanningButton;
    }

    public final void setMousePanningCursor(Cursor cursor) {
        this.mousePanningCursor = cursor;
    }

    public final Cursor getMousePanningCursor() {
        return this.mousePanningCursor;
    }

    public final void setZoomMode(int n) {
        this.zoomMode = n;
    }

    public final int getZoomMode() {
        return this.zoomMode;
    }

    public final void zoom(int n, int n2, double d) {
        long l;
        double d2;
        double d3;
        boolean bl = this.fitsWidth();
        boolean bl2 = this.fitsHeight();
        if (bl && bl2) {
            return;
        }
        double d4 = this.getScaleX();
        if (d4 * (d3 = this.getScaleY()) == 0.0) {
            return;
        }
        double d5 = this.zoomMode == 2 || bl ? d4 : d4 * d;
        double d6 = this.zoomMode == 1 || bl2 ? d3 : d3 * d;
        double d7 = this.getDataX(n);
        double d8 = this.getDataY(n2);
        this.setScale(d5, d6);
        long l2 = this.getOffsetX();
        long l3 = this.getOffsetY();
        if (!bl && this.zoomMode != 2) {
            d2 = d7 - (double)this.getDataOffsetX();
            l = (long)Math.ceil(this.getViewWidth(d2));
            long l4 = l2 = this.isRightBased() ? l - (long)this.getWidth() + (long)n : l - (long)n;
        }
        if (!bl2 && this.zoomMode != 1) {
            d2 = d8 - (double)this.getDataOffsetY();
            l = (long)Math.ceil(this.getViewHeight(d2));
            l3 = this.isBottomBased() ? l - (long)this.getHeight() + (long)n2 : l - (long)n2;
        }
        this.setOffset(l2, l3);
    }

    public final void setMouseZoomingEnabled(boolean bl) {
        if (bl) {
            this.enableMouseZooming();
        } else {
            this.disableMouseZooming();
        }
    }

    public final void enableMouseZooming() {
        if (this.mouseZoomHandler != null) {
            return;
        }
        this.mouseZoomHandler = new MouseZoomHandler();
        this.addMouseWheelListener(this.mouseZoomHandler);
    }

    public final void disableMouseZooming() {
        if (this.mouseZoomHandler == null) {
            return;
        }
        this.removeMouseWheelListener(this.mouseZoomHandler);
        this.mouseZoomHandler = null;
    }

    public final boolean isMouseZoomingEnabled() {
        return this.mouseZoomHandler != null;
    }

    public final double getMouseZoomingFactor() {
        return this.mouseZoomingFactor;
    }

    public final void setMouseZoomingFactor(double d) {
        this.mouseZoomingFactor = d;
    }

    private class MouseZoomHandler
    implements MouseWheelListener {
        private MouseZoomHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getScrollType() == 0) {
                InteractiveCanvasComponent.this.zoom(mouseWheelEvent.getX(), mouseWheelEvent.getY(), Math.pow(InteractiveCanvasComponent.this.mouseZoomingFactor, -mouseWheelEvent.getUnitsToScroll()));
                InteractiveCanvasComponent.this.repaintDirty();
            }
        }
    }

    private class MousePanHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean dragging;
        private int lastMouseDragX;
        private int lastMouseDragY;

        private MousePanHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = this.dragging = InteractiveCanvasComponent.this.panningPossible() && mouseEvent.getButton() == InteractiveCanvasComponent.this.mousePanningButton;
            if (!this.dragging) {
                return;
            }
            this.lastMouseDragX = mouseEvent.getX();
            this.lastMouseDragY = mouseEvent.getY();
            if (InteractiveCanvasComponent.this.mousePanningCursor != null && InteractiveCanvasComponent.this.isMousePanningEnabled()) {
                InteractiveCanvasComponent.this.setCursor(InteractiveCanvasComponent.this.mousePanningCursor);
            }
            if (!InteractiveCanvasComponent.this.isOffsetAdjusting()) {
                InteractiveCanvasComponent.this.offsetAdjustingStarted();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
            if (InteractiveCanvasComponent.this.mousePanningCursor != null) {
                InteractiveCanvasComponent.this.setCursor(Cursor.getDefaultCursor());
            }
            if (InteractiveCanvasComponent.this.isOffsetAdjusting()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InteractiveCanvasComponent.this.offsetAdjustingFinished();
                        InteractiveCanvasComponent.this.repaintDirty();
                    }
                });
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.dragging) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            long l = InteractiveCanvasComponent.this.getOffsetX();
            long l2 = InteractiveCanvasComponent.this.getOffsetY();
            if (this.lastMouseDragX != 0 && this.lastMouseDragY != 0) {
                int n3 = InteractiveCanvasComponent.this.isRightBased() ? n - this.lastMouseDragX : this.lastMouseDragX - n;
                int n4 = InteractiveCanvasComponent.this.isBottomBased() ? n2 - this.lastMouseDragY : this.lastMouseDragY - n2;
                InteractiveCanvasComponent.this.setOffset(l + (long)n3, l2 + (long)n4);
                InteractiveCanvasComponent.this.repaintDirtyAccel();
            }
            if (InteractiveCanvasComponent.this.getOffsetX() != l) {
                this.lastMouseDragX = n;
            }
            if (InteractiveCanvasComponent.this.getOffsetY() != l2) {
                this.lastMouseDragY = n2;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class ScrollBarManager
    implements AdjustmentListener,
    MouseWheelListener {
        private static final int SCROLLBAR_UNIT_INCREMENT = 20;
        private JScrollBar scrollBar;
        private double scrollBarFactor;
        boolean horizontal;
        boolean internalChange;

        private ScrollBarManager() {
        }

        public void attachScrollBar(JScrollBar jScrollBar, boolean bl) {
            if (this.scrollBar == jScrollBar) {
                return;
            }
            if (this.scrollBar != null) {
                this.detachScrollBar();
            }
            this.scrollBar = jScrollBar;
            this.horizontal = bl;
            jScrollBar.addAdjustmentListener(this);
            jScrollBar.addMouseWheelListener(this);
            if (!bl) {
                InteractiveCanvasComponent.this.addMouseWheelListener(this);
            }
        }

        public void detachScrollBar() {
            if (this.scrollBar == null) {
                return;
            }
            if (!this.horizontal) {
                InteractiveCanvasComponent.this.removeMouseWheelListener(this);
            }
            this.scrollBar.removeMouseWheelListener(this);
            this.scrollBar.removeAdjustmentListener(this);
            this.scrollBar = null;
        }

        public void syncScrollBar(boolean bl) {
            this.internalChange = true;
            if (bl) {
                int n;
                long l = InteractiveCanvasComponent.this.getOffsetX();
                long l2 = InteractiveCanvasComponent.this.getOffsetY();
                int n2 = n = this.horizontal ? this.getInt(l) : this.getInt(l2);
                if (this.reversedValue()) {
                    n = this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount() - n;
                }
                this.scrollBar.setValue(n);
            } else {
                int n;
                this.updateFactor();
                long l = InteractiveCanvasComponent.this.getOffsetX();
                long l3 = InteractiveCanvasComponent.this.getOffsetY();
                long l4 = InteractiveCanvasComponent.this.getMaxOffsetX();
                long l5 = InteractiveCanvasComponent.this.getMaxOffsetY();
                int n3 = this.horizontal ? this.getInt(l) : this.getInt(l3);
                int n4 = this.horizontal ? this.getInt(InteractiveCanvasComponent.this.getWidth()) : this.getInt(InteractiveCanvasComponent.this.getHeight());
                int n5 = this.horizontal ? this.getInt(l4) : this.getInt(l5);
                int n6 = this.horizontal ? this.getInt(20L) : this.getInt(20L);
                int n7 = n = this.horizontal ? this.getInt(InteractiveCanvasComponent.this.getWidth() - 20) : this.getInt(InteractiveCanvasComponent.this.getHeight() - 20);
                if (this.reversedValue()) {
                    n3 = n5 - n3;
                }
                this.scrollBar.setEnabled(n5 > 0);
                this.scrollBar.setValues(n3, n4, 0, n5 + n4);
                this.scrollBar.setUnitIncrement(n6);
                this.scrollBar.setBlockIncrement(n);
            }
            this.internalChange = false;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            boolean bl;
            if (this.internalChange) {
                return;
            }
            boolean bl2 = adjustmentEvent.getValueIsAdjusting();
            if (this.horizontal) {
                bl = InteractiveCanvasComponent.this.isHOffsetAdjusting();
                if (bl2 && !bl) {
                    InteractiveCanvasComponent.this.hOffsetAdjustingStarted();
                }
                InteractiveCanvasComponent.this.setOffset(this.getValue(), InteractiveCanvasComponent.this.getOffsetY());
            } else {
                bl = InteractiveCanvasComponent.this.isVOffsetAdjusting();
                if (bl2 && !bl) {
                    InteractiveCanvasComponent.this.vOffsetAdjustingStarted();
                }
                InteractiveCanvasComponent.this.setOffset(InteractiveCanvasComponent.this.getOffsetX(), this.getValue());
            }
            InteractiveCanvasComponent.this.repaintDirtyAccel();
            if (!bl2 && bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (ScrollBarManager.this.horizontal) {
                            InteractiveCanvasComponent.this.hOffsetAdjustingFinished();
                        } else {
                            InteractiveCanvasComponent.this.vOffsetAdjustingFinished();
                        }
                        InteractiveCanvasComponent.this.repaintDirty();
                    }
                });
            }
        }

        public long getValue() {
            long l = this.scrollBar.getValue();
            if (this.reversedValue()) {
                l = (long)(this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()) - l;
            }
            return (long)((double)l / this.scrollBarFactor);
        }

        private void updateFactor() {
            int n;
            int n2;
            long l = InteractiveCanvasComponent.this.getMaxOffsetX();
            long l2 = InteractiveCanvasComponent.this.getMaxOffsetY();
            this.scrollBarFactor = this.horizontal ? (l + (long)(n2 = InteractiveCanvasComponent.this.getWidth()) > Integer.MAX_VALUE ? 2.147483647E9 / (double)(l + (long)n2) : 1.0) : (l2 + (long)(n = InteractiveCanvasComponent.this.getHeight()) > Integer.MAX_VALUE ? 2.147483647E9 / (double)(l2 + (long)n) : 1.0);
        }

        private boolean reversedValue() {
            return this.horizontal ? InteractiveCanvasComponent.this.isRightBased() : InteractiveCanvasComponent.this.isBottomBased();
        }

        private int getInt(long l) {
            return (int)((double)l * this.scrollBarFactor);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (InteractiveCanvasComponent.this.isMouseZoomingEnabled() && mouseWheelEvent.getSource() == InteractiveCanvasComponent.this) {
                return;
            }
            if (mouseWheelEvent.getScrollType() == 0) {
                int n;
                int n2 = mouseWheelEvent.getUnitsToScroll();
                int n3 = n = n2 < 0 ? -1 : 1;
                if (n2 != 0) {
                    int n4 = this.scrollBar.getUnitIncrement(n);
                    int n5 = this.scrollBar.getValue();
                    int n6 = n5 + n4 * n2;
                    if (n5 != (n6 = Math.max(Math.min(n6, this.scrollBar.getMaximum() - this.scrollBar.getVisibleAmount()), this.scrollBar.getMinimum()))) {
                        this.scrollBar.setValue(n6);
                    }
                }
            }
        }
    }
}

