/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import hidden.org.codehaus.plexus.util.dag.CycleDetectedException;
import hidden.org.codehaus.plexus.util.dag.DAG;
import java.util.List;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.CompositionResolver;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;

public class DefaultCompositionResolver
implements CompositionResolver {
    private DAG dag = new DAG();

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws CompositionException {
        String key = this.getDAGKey(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
        List requirements = componentDescriptor.getRequirements();
        for (ComponentRequirement requirement : requirements) {
            try {
                if (requirement instanceof ComponentRequirementList) {
                    for (String hint : ((ComponentRequirementList)requirement).getRoleHints()) {
                        this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), hint));
                    }
                    continue;
                }
                this.dag.addEdge(key, this.getDAGKey(requirement.getRole(), requirement.getRoleHint()));
            }
            catch (CycleDetectedException e) {
                throw new CompositionException("Cyclic requirement detected", e);
            }
        }
    }

    public List getRequirements(String role, String roleHint) {
        return this.dag.getChildLabels(this.getDAGKey(role, roleHint));
    }

    public List findRequirements(String role, String roleHint) {
        return this.dag.getParentLabels(this.getDAGKey(role, roleHint));
    }

    private String getDAGKey(String role, String roleHint) {
        return String.valueOf(role) + ':' + roleHint;
    }
}

