/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddMIDletPanel;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.MIDletScanner;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerMIDlets
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener,
ChangeListener,
TableModelListener {
    static final long serialVersionUID = -7485135564331430899L;
    static final String[] PROPERTY_GROUP = new String[]{"manifest.midlets"};
    private final DefaultComboBoxModel cbmClassesForAdd;
    private final DefaultComboBoxModel cbmIconsForAdd;
    protected HashSet<String> classes;
    protected HashSet<String> icons;
    private VisualPropertySupport vps;
    private final MIDletsTableModel model = new MIDletsTableModel();
    private JButton addButton;
    private JCheckBox defaultCheck;
    private JButton downButton;
    private JButton editButton;
    private ErrorPanel errorPanel;
    private JTable midletsTable;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JLabel tableLabel;
    private JButton upButton;

    public CustomizerMIDlets() {
        this.initComponents();
        this.initAccessibility();
        this.cbmClassesForAdd = new DefaultComboBoxModel();
        this.cbmIconsForAdd = new DefaultComboBoxModel();
        this.model.addTableModelListener(this);
        this.midletsTable.setSelectionMode(0);
        this.midletsTable.getSelectionModel().addListSelectionListener(this);
        this.midletsTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setForeground(bl ? jTable.getSelectionForeground() : (n2 == 1 && CustomizerMIDlets.this.classes != null && !CustomizerMIDlets.this.classes.contains(object) ? Color.RED : jTable.getForeground()));
                return component;
            }
        });
        this.midletsTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setForeground(bl ? jTable.getSelectionForeground() : (n2 == 2 && CustomizerMIDlets.this.icons != null && !CustomizerMIDlets.this.icons.contains(object) ? Color.RED : jTable.getForeground()));
                return component;
            }
        });
        this.midletsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    CustomizerMIDlets.this.editButtonActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.defaultCheck = new JCheckBox();
        this.tableLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.midletsTable = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.errorPanel = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.defaultCheck, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_Use_Default"));
        this.defaultCheck.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.defaultCheck, gridBagConstraints);
        this.defaultCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_UseDefault"));
        this.tableLabel.setLabelFor(this.midletsTable);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_MIDlets"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.tableLabel, gridBagConstraints);
        this.midletsTable.setModel(this.model);
        this.scrollPane.setViewportView(this.midletsTable);
        this.midletsTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_MIDlets"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerMIDlets.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerMIDlets.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.editButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_Edit"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerMIDlets.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_MoveUp"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerMIDlets.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_MoveDown"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerMIDlets.this.downButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 12, 0);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets_MoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSN_CustMIDlets"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerMIDlets.class, (String)"ACSD_CustMIDlets"));
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.midletsTable.getSelectedRow();
        if (n < 0 || n > this.midletsTable.getRowCount() - 2) {
            return;
        }
        this.model.moveDown(n);
        this.midletsTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.midletsTable.getSelectedRow();
        if (n < 1) {
            return;
        }
        this.model.moveUp(n);
        this.midletsTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.midletsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.model.remove(n);
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.midletsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String[] stringArray = this.model.getRow(n).split(",", 3);
        AddMIDletPanel addMIDletPanel = new AddMIDletPanel(stringArray[0].trim(), stringArray[2].trim(), stringArray[1].trim(), this.cbmClassesForAdd, this.cbmIconsForAdd);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addMIDletPanel, NbBundle.getMessage(CustomizerMIDlets.class, (String)"Title_CustMIDlets_EditMIDlet"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddMIDletPanel.class), null);
        addMIDletPanel.setDialogDescriptor(dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            this.model.setRow(n, addMIDletPanel.getName(), addMIDletPanel.getClazz(), addMIDletPanel.getIcon());
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            hashSet.add(this.model.getValueAt(i, 2).trim());
        }
        String string = null;
        for (n = 0; n < this.cbmClassesForAdd.getSize() && hashSet.contains(this.cbmClassesForAdd.getElementAt(n)); ++n) {
        }
        String string2 = string = n < this.cbmClassesForAdd.getSize() ? (String)this.cbmClassesForAdd.getElementAt(n) : null;
        if (string != null) {
            string = string.trim();
        }
        AddMIDletPanel addMIDletPanel = new AddMIDletPanel(null, string, null, this.cbmClassesForAdd, this.cbmIconsForAdd);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addMIDletPanel, NbBundle.getMessage(CustomizerMIDlets.class, (String)"Title_CustMIDlets_AddMIDlet"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddMIDletPanel.class), null);
        addMIDletPanel.setDialogDescriptor(dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            this.model.addRow(addMIDletPanel.getName(), addMIDletPanel.getClazz(), addMIDletPanel.getIcon());
        }
    }

    public void initValues(ProjectProperties projectProperties, String string) {
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.icons = null;
        this.classes = null;
        MIDletScanner mIDletScanner = MIDletScanner.getDefault(projectProperties);
        mIDletScanner.scan(this.cbmClassesForAdd, this.cbmIconsForAdd, string, this);
        this.vps.register(this.defaultCheck, string, this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        this.classes = new HashSet();
        for (n = 0; n < this.cbmClassesForAdd.getSize(); ++n) {
            this.classes.add((String)this.cbmClassesForAdd.getElementAt(n));
        }
        this.icons = new HashSet();
        for (n = 0; n < this.cbmIconsForAdd.getSize(); ++n) {
            this.icons.add((String)this.cbmIconsForAdd.getElementAt(n));
        }
        this.model.fireTableDataChanged();
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    public void initGroupValues(boolean bl) {
        this.vps.register(this.model, new String[]{"manifest.midlets"}, bl);
        this.addButton.setEnabled(!bl);
        this.midletsTable.setEnabled(!bl);
        this.midletsTable.setBackground(UIManager.getDefaults().getColor(bl ? "TextField.inactiveBackground" : "Table.background"));
        this.valueChanged(null);
        this.tableLabel.setEnabled(!bl);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.midletsTable.getSelectedRow();
        boolean bl = this.midletsTable.isEnabled();
        boolean bl2 = bl && n >= 0;
        this.editButton.setEnabled(bl2);
        this.removeButton.setEnabled(bl2);
        this.upButton.setEnabled(bl && n > 0);
        this.downButton.setEnabled(bl2 && n < this.model.getRowCount() - 1);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.classes != null && !this.classes.containsAll(this.model.getClasses())) {
            this.errorPanel.setErrorBundleMessage("ERR_CustMIDlets_WrongMIDlets");
        } else if (this.icons != null && !this.icons.containsAll(this.model.getIcons())) {
            this.errorPanel.setErrorBundleMessage("ERR_CustMIDlets_WrongIcons");
        } else {
            this.errorPanel.setErrorBundleMessage(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MIDletsTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        public static final String PREFIX = "MIDlet-";
        private HashMap<String, String> map = new HashMap();
        private int rows = 0;
        private static final int[] COLUMN_MAP = new int[]{0, 2, 1};
        private static final String[] COLUMN_NAMES = new String[]{NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDletsName_Name"), NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Class"), NbBundle.getMessage(CustomizerMIDlets.class, (String)"LBL_CustMIDlets_Icon")};
        private static final long serialVersionUID = -7485135564331430899L;

        private MIDletsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public String getColumnName(int n) {
            assert (n < 3);
            return COLUMN_NAMES[n];
        }

        public Set<String> getClasses() {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                hashSet.add(this.getValueAt(i, 1));
            }
            return hashSet;
        }

        public Set<String> getIcons() {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < this.rows; ++i) {
                String string = this.getValueAt(i, 2);
                if (string.length() <= 0) continue;
                hashSet.add(string);
            }
            return hashSet;
        }

        public void addRow(String string, String string2, String string3) {
            ++this.rows;
            this.setRow(this.rows - 1, string + ',' + string3 + ',' + string2);
            this.fireTableRowsInserted(this.rows - 1, this.rows - 1);
        }

        protected String getRow(int n) {
            assert (n < this.rows);
            String string = this.map.get(PREFIX + String.valueOf(n + 1));
            return string == null ? ",," : string;
        }

        private void setRow(int n, String string) {
            assert (n < this.rows);
            this.map.put(PREFIX + String.valueOf(n + 1), string);
        }

        public void remove(int n) {
            for (int i = n; i < this.rows - 1; ++i) {
                this.setRow(i, this.getRow(i + 1));
            }
            this.map.remove(PREFIX + String.valueOf(this.rows));
            --this.rows;
            this.fireTableRowsDeleted(n, n);
        }

        public void moveUp(int n) {
            String string = this.getRow(n);
            this.setRow(n, this.getRow(n - 1));
            this.setRow(n - 1, string);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveDown(int n) {
            String string = this.getRow(n);
            this.setRow(n, this.getRow(n + 1));
            this.setRow(n + 1, string);
            this.fireTableRowsUpdated(n, n + 1);
        }

        @Override
        public String getValueAt(int n, int n2) {
            assert (n2 < 3);
            return this.getRow(n).split(",", 3)[COLUMN_MAP[n2]].trim();
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            return new Object[]{this.map};
        }

        @Override
        public synchronized void setDataDelegates(Object[] objectArray) {
            this.map = objectArray[0] == null ? new HashMap() : (HashMap)objectArray[0];
            this.rows = 0;
            for (String string : this.map.keySet()) {
                if (!string.startsWith(PREFIX)) continue;
                try {
                    int n = Integer.parseInt(string.substring(PREFIX.length()));
                    if (n <= this.rows) continue;
                    this.rows = n;
                }
                catch (NumberFormatException numberFormatException) {
                    assert (false) : numberFormatException;
                }
            }
            this.fireTableDataChanged();
        }

        public void setRow(int n, String string, String string2, String string3) {
            this.setRow(n, string + ',' + string3 + ',' + string2);
            this.fireTableRowsUpdated(n, n);
        }
    }
}

