/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mobility.project.ui.actions.NodeAction;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJarAction
extends NodeAction<File> {
    private static File lastFile = null;

    private AddJarAction() {
        super(NbBundle.getMessage(AddJarAction.class, (String)"LBL_CustLibs_Add_Jar"));
    }

    public static Action getStaticInstance() {
        return new AddJarAction();
    }

    protected File[] getItems() {
        File[] fileArray = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogTitle(NbBundle.getMessage(AddJarAction.class, (String)"LBL_Classpath_AddJar"));
        jFileChooser.setFileFilter(new JarFileFilter());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (this.defaultDir != null) {
            jFileChooser.setSelectedFile(FileUtil.toFile((FileObject)this.defaultDir.getChildren()[0]));
        } else if (lastFile != null) {
            jFileChooser.setSelectedFile(lastFile);
        }
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0 && (fileArray = jFileChooser.getSelectedFiles()).length > 0) {
            lastFile = fileArray[0];
        }
        return fileArray;
    }

    protected List<VisualClassPathItem> addItems(File[] fileArray, List<VisualClassPathItem> list, Node node) {
        for (File file : fileArray) {
            file = FileUtil.normalizeFile((File)file);
            list.add(new VisualClassPathItem(file, 0, null, file.getPath()));
        }
        return list;
    }

    private static class JarFileFilter
    extends FileFilter {
        JarFileFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return file.isDirectory() || string.endsWith(".zip") || string.endsWith(".jar");
        }

        public String getDescription() {
            return NbBundle.getMessage(AddJarAction.class, (String)"LBL_JarFileFilter");
        }
    }
}

