/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.J2MECustomizerProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectConfigurationsHelper
implements ProjectConfigurationProvider<ProjectConfiguration>,
AntProjectListener {
    public static final String PROJ_PROP_CONFIGURATION_ACTIVE = "config.active";
    public static final String DEFAULT_CONFIGURATION_NAME = "DefaultConfiguration";
    public static final String PROJECT_PROPERTIES = "ProjectProperties";
    protected final AntProjectHelper h;
    private TreeMap<String, ProjectConfiguration> configurations;
    private PropertyChangeSupport psp;
    private ProjectConfiguration activeConfiguration;
    private ProjectConfiguration defaultConfiguration;
    private J2MEProject p;
    private boolean preprocessorOn;
    private boolean invalid = true;

    public ProjectConfigurationsHelper(AntProjectHelper antProjectHelper, J2MEProject j2MEProject) {
        this.h = antProjectHelper;
        this.p = j2MEProject;
    }

    public boolean isPreprocessorOn() {
        if (this.invalid) {
            String string = this.h.getStandardPropertyEvaluator().getProperty("use.preprocessor");
            this.preprocessorOn = string == null || Boolean.parseBoolean(string);
            this.invalid = false;
        }
        return this.preprocessorOn;
    }

    public ProjectConfiguration getDefaultConfiguration() {
        if (this.defaultConfiguration == null) {
            this.defaultConfiguration = this.createConfiguration(DEFAULT_CONFIGURATION_NAME);
        }
        return this.defaultConfiguration;
    }

    public final boolean addConfiguration(final String string) {
        if (string == null || string.equals(this.getDefaultConfiguration().getDisplayName())) {
            return false;
        }
        boolean bl = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                EditableProperties editableProperties = ProjectConfigurationsHelper.this.h.getProperties("nbproject/project.properties");
                String string3 = editableProperties.getProperty("all.configurations");
                if (string3 == null) {
                    string3 = "";
                }
                boolean bl = true;
                StringBuffer stringBuffer = new StringBuffer(" ");
                for (String string2 : string3.split(",")) {
                    if (string2.trim().length() <= 0) continue;
                    int n = string2.compareTo(string);
                    if (n == 0) {
                        return Boolean.FALSE;
                    }
                    if (bl && n > 0) {
                        bl = false;
                        stringBuffer.append(',').append(string);
                    }
                    stringBuffer.append(',').append(string2);
                }
                if (bl) {
                    stringBuffer.append(',').append(string);
                }
                editableProperties.put("all.configurations", stringBuffer.toString());
                ProjectConfigurationsHelper.this.h.putProperties("nbproject/project.properties", editableProperties);
                return Boolean.TRUE;
            }
        });
        try {
            ProjectManager.getDefault().saveProject((Project)this.p);
            return bl;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    public Map<String, String> getAbilitiesFor(ProjectConfiguration projectConfiguration) {
        String string = J2MEProjectUtils.evaluateProperty(this.h, "abilities", projectConfiguration.getDisplayName());
        Map<String, String> map = string == null ? new HashMap() : CommentingPreProcessor.decodeAbilitiesMap((String)string);
        map.put("DebugLevel", J2MEProjectUtils.evaluateProperty(this.h, "debug.level", projectConfiguration.getDisplayName()));
        return map;
    }

    public Map<String, String> getActiveAbilities() {
        return this.getAbilitiesFor(this.getActiveConfiguration());
    }

    public Set<String> getAllIdentifiers(boolean bl) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ProjectConfiguration[] projectConfigurationArray = this.getConfigurations().toArray(new ProjectConfiguration[0]);
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            if (bl) {
                treeSet.add(projectConfigurationArray[i].getDisplayName());
            }
            String string = this.getDefaultConfiguration().equals(projectConfigurationArray[i]) ? "abilities" : "configs." + projectConfigurationArray[i].getDisplayName() + '.' + "abilities";
            String string2 = this.h.getStandardPropertyEvaluator().getProperty(string);
            if (string2 == null) continue;
            treeSet.addAll(CommentingPreProcessor.decodeAbilitiesMap((String)string2).keySet());
        }
        return treeSet;
    }

    public final boolean removeConfiguration(final ProjectConfiguration projectConfiguration) {
        if (projectConfiguration == null || projectConfiguration.equals(this.getDefaultConfiguration())) {
            return false;
        }
        boolean bl = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                EditableProperties editableProperties = ProjectConfigurationsHelper.this.h.getProperties("nbproject/project.properties");
                String string = editableProperties.getProperty("all.configurations");
                if (string == null) {
                    return Boolean.FALSE;
                }
                boolean bl = false;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : string.split(",")) {
                    if (string2.equals(projectConfiguration.getDisplayName())) {
                        bl = true;
                        continue;
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(string2);
                }
                if (bl) {
                    String string3 = "configs." + projectConfiguration.getDisplayName();
                    for (String string4 : editableProperties.keySet().toArray(new String[0])) {
                        if (!string4.startsWith(string3)) continue;
                        editableProperties.remove((Object)string4);
                    }
                    editableProperties.put("all.configurations", stringBuffer.toString());
                    ProjectConfigurationsHelper.this.h.putProperties("nbproject/project.properties", editableProperties);
                }
                return bl;
            }
        });
        try {
            ProjectManager.getDefault().saveProject((Project)this.p);
            return bl;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
    }

    public final Collection<ProjectConfiguration> getConfigurations() {
        return this.getConfigurations(this.configurations);
    }

    private final Collection<ProjectConfiguration> getConfigurations(final TreeMap<String, ProjectConfiguration> treeMap) {
        if (this.configurations == null) {
            this.configurations = (TreeMap)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<TreeMap<String, ProjectConfiguration>>(){

                public TreeMap<String, ProjectConfiguration> run() {
                    TreeMap<String, ProjectConfiguration> treeMap2 = new TreeMap<String, ProjectConfiguration>(new Comparator<String>(){

                        @Override
                        public int compare(String string, String string2) {
                            return ProjectConfigurationsHelper.DEFAULT_CONFIGURATION_NAME.equals(string) ? (ProjectConfigurationsHelper.DEFAULT_CONFIGURATION_NAME.equals(string2) ? 0 : -1) : (ProjectConfigurationsHelper.DEFAULT_CONFIGURATION_NAME.equals(string2) ? 1 : string.compareToIgnoreCase(string2));
                        }
                    });
                    treeMap2.put(ProjectConfigurationsHelper.this.getDefaultConfiguration().getDisplayName(), ProjectConfigurationsHelper.this.getDefaultConfiguration());
                    String string = ProjectConfigurationsHelper.this.h.getProperties("nbproject/project.properties").getProperty("all.configurations");
                    if (string != null) {
                        for (String string2 : string.split(",")) {
                            if (string2.length() <= 0 || string2.equals(" ")) continue;
                            ProjectConfiguration projectConfiguration = treeMap == null ? null : (ProjectConfiguration)treeMap.get(string2);
                            treeMap2.put(string2, projectConfiguration == null ? ProjectConfigurationsHelper.this.createConfiguration(string2) : projectConfiguration);
                        }
                    }
                    return treeMap2;
                }
            });
        }
        return this.configurations == null ? null : Collections.unmodifiableCollection(this.configurations.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ProjectConfigurationsHelper projectConfigurationsHelper = this;
        synchronized (projectConfigurationsHelper) {
            if (this.psp == null) {
                this.psp = new PropertyChangeSupport(this);
                this.getConfigurations();
                this.getActiveConfiguration();
                this.h.addAntProjectListener((AntProjectListener)this);
            }
        }
        this.psp.addPropertyChangeListener(propertyChangeListener);
    }

    public final ProjectConfiguration getActiveConfiguration() {
        if (this.activeConfiguration == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    ProjectConfigurationsHelper.this.activeConfiguration = ProjectConfigurationsHelper.this.getDefaultConfiguration();
                    String string = ProjectConfigurationsHelper.this.h.getStandardPropertyEvaluator().getProperty(ProjectConfigurationsHelper.PROJ_PROP_CONFIGURATION_ACTIVE);
                    if (string == null || string.length() == 0) {
                        ProjectConfigurationsHelper.this.activeConfiguration = ProjectConfigurationsHelper.this.getDefaultConfiguration();
                        return null;
                    }
                    ProjectConfiguration[] projectConfigurationArray = ProjectConfigurationsHelper.this.getConfigurations().toArray(new ProjectConfiguration[0]);
                    for (int i = 0; i < projectConfigurationArray.length; ++i) {
                        if (!string.equals(projectConfigurationArray[i].getDisplayName())) continue;
                        ProjectConfigurationsHelper.this.activeConfiguration = projectConfigurationArray[i];
                        return null;
                    }
                    return null;
                }
            });
        }
        return this.activeConfiguration;
    }

    public final ProjectConfiguration getConfigurationByName(String string) {
        return this.configurations.get(string);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.psp != null) {
            this.psp.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected ProjectConfiguration createConfiguration(String string) {
        return new ConfigurationImpl(string);
    }

    public final void setActiveConfiguration(final ProjectConfiguration projectConfiguration) throws IllegalArgumentException, IOException {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ProjectConfigurationsHelper.class, (String)"TTL_CHANGE_CONFIG"));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jLabel, "North");
                jPanel.add((Component)jComponent, "South");
                String string = NbBundle.getMessage(ProjectConfigurationsHelper.class, (String)"MSG_CHANGE_CONFIG");
                JDialog jDialog = new JDialog(WindowManager.getDefault().getMainWindow());
                jDialog.setModal(true);
                jDialog.setDefaultCloseOperation(0);
                jDialog.setTitle(string);
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jPanel, "Center");
                jDialog.setLocationRelativeTo(jDialog.getParent());
                RequestProcessor.Task task = ProjectConfigurationsHelper.this.p.getRequestProcessor().post((Runnable)new ConfigurationChanger(progressHandle, projectConfiguration, jDialog));
                try {
                    task.waitFinished(50L);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                if (!task.isFinished()) {
                    jDialog.pack();
                    jDialog.setVisible(true);
                }
            }
        });
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
    }

    public synchronized void propertiesChanged(AntProjectEvent antProjectEvent) {
        if (this.psp == null) {
            return;
        }
        if ("nbproject/private/private.properties".equals(antProjectEvent.getPath())) {
            ProjectConfiguration projectConfiguration = this.activeConfiguration;
            this.activeConfiguration = null;
            ProjectConfiguration projectConfiguration2 = this.getActiveConfiguration();
            if (projectConfiguration == null && projectConfiguration2 != null || projectConfiguration != null && !projectConfiguration.equals(projectConfiguration2)) {
                this.psp.firePropertyChange("activeConfiguration", projectConfiguration, projectConfiguration2);
            }
        } else if ("nbproject/project.properties".equals(antProjectEvent.getPath())) {
            this.invalid = true;
            TreeMap<String, ProjectConfiguration> treeMap = this.configurations;
            Object[] objectArray = treeMap.values().toArray(new ProjectConfiguration[treeMap.size()]);
            this.configurations = null;
            Object[] objectArray2 = this.getConfigurations(treeMap).toArray(new ProjectConfiguration[0]);
            if (!Arrays.equals(objectArray, objectArray2)) {
                this.psp.firePropertyChange("configurations", objectArray, objectArray2);
            }
            this.psp.firePropertyChange(PROJECT_PROPERTIES, null, this.getActiveConfiguration());
        }
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        final J2MECustomizerProvider j2MECustomizerProvider = (J2MECustomizerProvider)this.p.getLookup().lookup(J2MECustomizerProvider.class);
        if (j2MECustomizerProvider != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    j2MECustomizerProvider.showCustomizer(true);
                }
            });
        }
    }

    public boolean configurationsAffectAction(String string) {
        return false;
    }

    private static final class ConfigurationImpl
    implements ProjectConfiguration {
        private final String name;

        public ConfigurationImpl(String string) {
            this.name = string;
        }

        public String getDisplayName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConfigurationImpl)) {
                return false;
            }
            String string = ((ConfigurationImpl)object).getDisplayName();
            return this.name != null ? this.name.equals(string) : string == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    private final class ConfigurationChanger
    extends WindowAdapter
    implements Runnable {
        private final ProgressHandle handle;
        private final ProjectConfiguration configuration;
        private final Dialog dlg;
        private volatile boolean done;

        ConfigurationChanger(ProgressHandle progressHandle, ProjectConfiguration projectConfiguration, Dialog dialog) {
            this.configuration = projectConfiguration;
            this.handle = progressHandle;
            this.dlg = dialog;
            progressHandle.start();
            progressHandle.switchToIndeterminate();
            dialog.addWindowListener(this);
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (this.done) {
                this.runOnEQ();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                try {
                    this.runOffEQ();
                }
                finally {
                    this.handle.finish();
                    EventQueue.invokeLater(this);
                }
                this.done = true;
            } else {
                this.runOnEQ();
            }
        }

        private void runOnEQ() {
            this.dlg.setVisible(false);
            this.dlg.dispose();
        }

        private void runOffEQ() {
            ProjectConfiguration projectConfiguration = ProjectConfigurationsHelper.this.activeConfiguration;
            ProjectConfigurationsHelper.this.activeConfiguration = null;
            final EditableProperties editableProperties = ProjectConfigurationsHelper.this.h.getProperties("nbproject/private/private.properties");
            editableProperties.put(ProjectConfigurationsHelper.PROJ_PROP_CONFIGURATION_ACTIVE, this.configuration == null || this.configuration.equals(ProjectConfigurationsHelper.this.getDefaultConfiguration()) ? "" : this.configuration.getDisplayName());
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                    public Object run() {
                        ProjectConfigurationsHelper.this.h.putProperties("nbproject/private/private.properties", editableProperties);
                        return null;
                    }
                });
                ProjectManager.getDefault().saveProject((Project)ProjectConfigurationsHelper.this.p);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (MutexException mutexException) {
                Exceptions.printStackTrace((Throwable)mutexException);
            }
            ProjectConfiguration projectConfiguration2 = ProjectConfigurationsHelper.this.getActiveConfiguration();
            if (projectConfiguration != null ? !projectConfiguration.equals(projectConfiguration2) : projectConfiguration2 != null) {
                ProjectConfigurationsHelper.this.psp.firePropertyChange("activeConfiguration", projectConfiguration, projectConfiguration2);
            }
        }
    }
}

