/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.api;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlWrapperHandler
extends DefaultHandler {
    public static final String WSDL_SOAP_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SOAP_BINDING_PREFIX = "http://schemas.xmlsoap.org/wsdl/soap";
    private boolean isService;
    private boolean isPortType;
    private boolean isBinding;
    private String tns;
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Map<String, BindingInfo> bindings = new HashMap<String, BindingInfo>();
    private Map<String, String> ports = new HashMap<String, String>();
    private BindingInfo bindingInfo;
    private boolean insideBinding;
    private boolean insideService;

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (!this.prefixes.containsKey(string2)) {
            this.prefixes.put(string2, string);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("portType".equals(string2)) {
            this.isPortType = true;
        } else if ("binding".equals(string2)) {
            this.isBinding = true;
            if (WSDL_SOAP_URI.equals(string)) {
                String string4 = attributes.getValue("name");
                this.insideBinding = true;
                if (string4 != null) {
                    this.bindingInfo = new BindingInfo(string4);
                    this.bindings.put(string4, this.bindingInfo);
                }
            } else if (this.insideBinding && this.bindingInfo != null && string.startsWith(SOAP_BINDING_PREFIX)) {
                this.bindingInfo.setBindingType(string);
            }
        } else if ("service".equals(string2)) {
            this.isService = true;
            this.insideService = true;
        } else if ("port".equals(string2) && this.insideService) {
            String string5 = attributes.getValue("name");
            if (string5 != null) {
                this.ports.put(string5, attributes.getValue("binding"));
            }
        } else if ("definitions".equals(string2)) {
            this.tns = attributes.getValue("targetNamespace");
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("binding".equals(string2) && WSDL_SOAP_URI.equals(string)) {
            this.bindingInfo = null;
            this.insideBinding = false;
        } else if ("service".equals(string2)) {
            this.insideService = false;
        }
    }

    public String getBindingTypeForPort(String string) {
        String string2;
        BindingInfo bindingInfo;
        String string3 = this.ports.get(string);
        if (string3 != null && (bindingInfo = this.bindings.get(string2 = this.getLocalPart(string3))) != null) {
            return bindingInfo.getBindingType();
        }
        return null;
    }

    public boolean isServiceElement() {
        return this.isService;
    }

    public String getTargetNsPrefix() {
        return this.prefixes == null ? null : this.prefixes.get(this.tns);
    }

    public void endDocument() throws SAXException {
        if (!(this.isService || this.isBinding || this.isPortType)) {
            throw new SAXException("Missing wsdl elements (wsdl:service | wsdl:binding | wsdl:portType)");
        }
    }

    private String getLocalPart(String string) {
        int n = string.indexOf(":");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    private class BindingInfo {
        private String bindingName;
        private String bindingType;

        BindingInfo(String string) {
            this.bindingName = string;
        }

        void setBindingType(String string) {
            this.bindingType = string;
        }

        String getBindingType() {
            return this.bindingType;
        }
    }
}

