/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlWrapperGenerator {
    private static final String TEMPLATE_BASE = "/org/netbeans/modules/websvc/jaxws/resources/";

    public static WsdlWrapperHandler parse(String string) throws ParserConfigurationException, SAXException, IOException {
        WsdlWrapperHandler wsdlWrapperHandler = new WsdlWrapperHandler();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(string, (DefaultHandler)wsdlWrapperHandler);
        return wsdlWrapperHandler;
    }

    public static WsdlWrapperHandler parse(File file) throws ParserConfigurationException, SAXException, IOException {
        WsdlWrapperHandler wsdlWrapperHandler = new WsdlWrapperHandler();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(file, (DefaultHandler)wsdlWrapperHandler);
        return wsdlWrapperHandler;
    }

    private static Transformer getTransformer() throws TransformerConfigurationException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(WsdlWrapperGenerator.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxws/resources/WsdlServiceGenerator.xsl"));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(new URIResolver(){

            public Source resolve(String string, String string2) throws TransformerException {
                InputStream inputStream = this.getClass().getResourceAsStream(WsdlWrapperGenerator.TEMPLATE_BASE + string.substring(string.lastIndexOf(47) + 1));
                if (inputStream == null) {
                    return null;
                }
                return new StreamSource(inputStream);
            }
        });
        Templates templates = transformerFactory.newTemplates(new StreamSource(bufferedInputStream));
        return templates.newTransformer();
    }

    public static void generateWrapperWSDLContent(File file, StreamSource streamSource, String string, String string2) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            Transformer transformer = WsdlWrapperGenerator.getTransformer();
            transformer.setParameter("tns_prefix", string);
            transformer.setParameter("wsdl_location", string2);
            transformer.transform(streamSource, new StreamResult(outputStream));
            outputStream.close();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            IOException iOException = new IOException();
            iOException.initCause(transformerConfigurationException);
            throw iOException;
        }
        catch (TransformerException transformerException) {
            IOException iOException = new IOException();
            iOException.initCause(transformerException);
            throw iOException;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static String getWrapperName(URL uRL) {
        String string = uRL.toExternalForm();
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf(".");
        if (n >= 0) {
            if (n < n2) {
                return string.substring(n + 1, n2) + "Wrapper.wsdl";
            }
            if (n + 1 < string.length()) {
                return string.substring(n + 1) + "Wrapper.wsdl";
            }
        } else if (n2 > 0) {
            return string.substring(0, n2) + "Wrapper.wsdl";
        }
        return "WsdlWrapper.wsdl";
    }
}

