/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackVisualizer;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallStackTopComponent
extends TopComponent
implements VisualizerContainer {
    private static CallStackTopComponent instance;
    private static final String PREFERRED_ID = "CallStackTopComponent";
    private String currentToolName;
    private JComponent viewComponent;

    public CallStackTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(CallStackTopComponent.class, (String)"CTL_CallStackTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CallStackTopComponent.class, (String)"HINT_CallStackTopComponent"));
    }

    private void initComponents() {
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static synchronized CallStackTopComponent getDefault() {
        if (instance == null) {
            instance = new CallStackTopComponent();
        }
        return instance;
    }

    public static synchronized CallStackTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(CallStackTopComponent.class.getName()).warning("Cannot find CallStackTopComponent component. It will not be located properly in the window system.");
            return CallStackTopComponent.getDefault();
        }
        if (topComponent instanceof CallStackTopComponent) {
            return (CallStackTopComponent)topComponent;
        }
        Logger.getLogger(CallStackTopComponent.class.getName()).warning("There seem to be multiple components with the 'CallStackTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CallStackTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocus(boolean bl) {
        return this.viewComponent.requestFocus(bl);
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties properties) {
        properties.setProperty("version", "1.0");
    }

    Object readProperties(Properties properties) {
        CallStackTopComponent callStackTopComponent = CallStackTopComponent.getDefault();
        callStackTopComponent.readPropertiesImpl(properties);
        return callStackTopComponent;
    }

    private void readPropertiesImpl(Properties properties) {
        String string = properties.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void addVisualizer(String string, String string2, Visualizer<?> visualizer) {
        this.setContent(string2, visualizer.getComponent());
    }

    public void setContent(String string, JComponent jComponent) {
        if (jComponent instanceof ThreadStackVisualizer) {
            string = ((ThreadStackVisualizer)jComponent).getDisplayName();
        }
        if (this.currentToolName != null && this.currentToolName.equals(string) && this.viewComponent == jComponent) {
            return;
        }
        this.currentToolName = string;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.viewComponent = jComponent;
        this.add(this.viewComponent, "Center");
        this.setName(string);
        this.setToolTipText(string);
        this.validate();
    }

    public void addContent(String string, JComponent jComponent) {
        this.setContent(string, jComponent);
    }

    public void removeVisualizer(final Visualizer<?> visualizer) {
        if (EventQueue.isDispatchThread()) {
            this.closeCallStack(visualizer);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CallStackTopComponent.this.closeCallStack(visualizer);
                }
            });
        }
    }

    public void showup() {
        this.open();
        this.requestActive();
    }

    private void closeCallStack(Visualizer<?> visualizer) {
        if (this.viewComponent != visualizer.getComponent()) {
            return;
        }
        this.remove(visualizer.getComponent());
        this.setName(NbBundle.getMessage(CallStackTopComponent.class, (String)"CallStackDetails"));
        this.repaint();
    }
}

