/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.lib2.DocUtils;
import org.netbeans.modules.editor.lib2.highlighting.BlockHighlighting;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public abstract class CaretBasedBlockHighlighting
extends AbstractHighlightsContainer
implements ChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CaretBasedBlockHighlighting.class.getName());
    private final MimePath mimePath;
    private final JTextComponent component;
    private Caret caret;
    private ChangeListener caretListener;
    private final String coloringName;
    private final boolean extendsEOL;
    private final boolean extendsEmptyLine;
    private Position currentLineStart;
    private Position currentLineEnd;

    protected CaretBasedBlockHighlighting(JTextComponent jTextComponent, String string, boolean bl, boolean bl2) {
        String string2 = BlockHighlighting.getMimeType(jTextComponent);
        this.mimePath = string2 == null ? MimePath.EMPTY : MimePath.parse((String)string2);
        this.coloringName = string;
        this.extendsEOL = bl;
        this.extendsEmptyLine = bl2;
        this.component = jTextComponent;
        this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
        this.caret = jTextComponent.getCaret();
        if (this.caret != null) {
            this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
            this.caret.addChangeListener(this.caretListener);
        }
        this.updateLineInfo(false);
    }

    public final HighlightsSequence getHighlights(int n, int n2) {
        if (this.currentLineStart != null && this.currentLineEnd != null && n2 >= this.currentLineStart.getOffset() && n <= this.currentLineEnd.getOffset()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Queried for highlights in [" + n + ", " + n2 + "], returning [" + CaretBasedBlockHighlighting.positionToString(this.currentLineStart) + ", " + CaretBasedBlockHighlighting.positionToString(this.currentLineEnd) + "]" + ", layer=" + CaretBasedBlockHighlighting.s2s(this));
            }
            return new SimpleHighlightsSequence(Math.max(this.currentLineStart.getOffset(), n), Math.min(this.currentLineEnd.getOffset(), n2), this.getAttribs());
        }
        return HighlightsSequence.EMPTY;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null || "caret".equals(propertyChangeEvent.getPropertyName())) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretListener);
                this.caretListener = null;
            }
            this.caret = this.component.getCaret();
            if (this.caret != null) {
                this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
                this.caret.addChangeListener(this.caretListener);
            }
            this.updateLineInfo(true);
        }
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        this.updateLineInfo(true);
    }

    protected abstract Position[] getCurrentBlockPositions(Document var1, Caret var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateLineInfo(boolean bl) {
        ((AbstractDocument)this.component.getDocument()).readLock();
        try {
            Position[] positionArray = this.getCurrentBlockPositions(this.component.getDocument(), this.caret);
            if (!CaretBasedBlockHighlighting.comparePositions(positionArray[0], this.currentLineStart) || !CaretBasedBlockHighlighting.comparePositions(positionArray[1], this.currentLineEnd)) {
                Position position = CaretBasedBlockHighlighting.getLowerPosition(positionArray[0], this.currentLineStart);
                Position position2 = CaretBasedBlockHighlighting.getHigherPosition(positionArray[1], this.currentLineEnd);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Current block changed from [" + CaretBasedBlockHighlighting.positionToString(this.currentLineStart) + ", " + CaretBasedBlockHighlighting.positionToString(this.currentLineEnd) + "] to [" + CaretBasedBlockHighlighting.positionToString(positionArray[0]) + ", " + CaretBasedBlockHighlighting.positionToString(positionArray[1]) + "]" + ", layer=" + CaretBasedBlockHighlighting.s2s(this));
                }
                this.currentLineStart = positionArray[0];
                this.currentLineEnd = positionArray[1];
                if (bl) {
                    this.fireHighlightsChange(position == null ? 0 : position.getOffset(), position2 == null ? Integer.MAX_VALUE : position2.getOffset());
                }
            }
        }
        finally {
            ((AbstractDocument)this.component.getDocument()).readUnlock();
        }
    }

    private AttributeSet getAttribs() {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)this.mimePath).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors(this.coloringName);
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        } else if (this.extendsEOL || this.extendsEmptyLine) {
            attributeSet = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attributeSet, AttributesUtilities.createImmutable((Object[])new Object[]{ATTR_EXTENDS_EOL, this.extendsEOL, ATTR_EXTENDS_EMPTY_LINE, this.extendsEmptyLine})});
        }
        return attributeSet;
    }

    private static boolean comparePositions(Position position, Position position2) {
        return position == null && position2 == null || position != null && position2 != null && position.getOffset() == position2.getOffset() && position.getOffset() != 0;
    }

    private static Position getLowerPosition(Position position, Position position2) {
        if (position != null && position2 != null) {
            return position.getOffset() < position2.getOffset() ? position : position2;
        }
        if (position != null) {
            return position;
        }
        if (position2 != null) {
            return position2;
        }
        return null;
    }

    private static Position getHigherPosition(Position position, Position position2) {
        if (position != null && position2 != null) {
            return position.getOffset() > position2.getOffset() ? position : position2;
        }
        if (position != null) {
            return position;
        }
        if (position2 != null) {
            return position2;
        }
        return null;
    }

    private static String positionToString(Position position) {
        return position == null ? "null" : Integer.toString(position.getOffset());
    }

    private static String s2s(Object object) {
        return object == null ? "null" : object.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    public static final class TextSelectionHighlighting
    extends CaretBasedBlockHighlighting {
        public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.TextSelectionHighlighting";

        public TextSelectionHighlighting(JTextComponent jTextComponent) {
            super(jTextComponent, "selection", true, true);
        }

        protected Position[] getCurrentBlockPositions(Document document, Caret caret) {
            int n;
            int n2;
            if (document != null && caret != null && (n2 = caret.getDot()) != (n = caret.getMark())) {
                try {
                    return new Position[]{document.createPosition(Math.min(n2, n)), document.createPosition(Math.max(n2, n))};
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
                }
            }
            return new Position[]{null, null};
        }
    }

    public static final class CaretRowHighlighting
    extends CaretBasedBlockHighlighting {
        public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.CaretRowHighlighting";

        public CaretRowHighlighting(JTextComponent jTextComponent) {
            super(jTextComponent, "highlight-caret-row", true, false);
        }

        protected Position[] getCurrentBlockPositions(Document document, Caret caret) {
            if (document != null && caret != null) {
                int n = caret.getDot();
                try {
                    int n2 = DocUtils.getRowStart(document, n, 0);
                    int n3 = DocUtils.getRowEnd(document, n);
                    return new Position[]{document.createPosition(n2), document.createPosition(++n3)};
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, badLocationException.getMessage(), badLocationException);
                }
            }
            return new Position[]{null, null};
        }
    }

    private static final class SimpleHighlightsSequence
    implements HighlightsSequence {
        private int startOffset;
        private int endOffset;
        private AttributeSet attribs;
        private boolean end = false;

        public SimpleHighlightsSequence(int n, int n2, AttributeSet attributeSet) {
            this.startOffset = n;
            this.endOffset = n2;
            this.attribs = attributeSet;
        }

        public boolean moveNext() {
            if (!this.end) {
                this.end = true;
                return true;
            }
            return false;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public AttributeSet getAttributes() {
            return this.attribs;
        }
    }
}

