/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationSupport;
import org.netbeans.modules.dlight.toolsui.DLightConfigurationUIWrapper;
import org.netbeans.modules.dlight.toolsui.DLightConfigurationUIWrapperProvider;
import org.netbeans.modules.dlight.toolsui.DLightToolUIWrapper;
import org.netbeans.modules.dlight.toolsui.ListEditorPanel;
import org.netbeans.modules.dlight.toolsui.ToolsTable;
import org.netbeans.modules.dlight.toolsui.api.PanelWithApply;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsManagerPanel
extends PanelWithApply {
    private List<DLightConfigurationUIWrapper> dLightConfigurations = null;
    private List<DLightTool> allDLightTools = null;
    private static String manageConfigurations = ToolsManagerPanel.getString("ManageConfiurations", new String[0]);
    private int lastSelectedIndex = 0;
    private ToolsTable toolsTable = null;
    private JTextArea descriptionArea;
    private JLabel detailsLabel;
    private JList jList1;
    private JComboBox profileConfigurationComboBox;
    private JLabel profileConfigurationLabel;
    private JScrollPane scrollPane;
    private JLabel toolsLabel;
    private JScrollPane toolsList;

    public ToolsManagerPanel() {
        this((String)null);
    }

    public ToolsManagerPanel(String string) {
        this.initComponents();
        this.descriptionArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descriptionArea.setOpaque(true);
        DLightConfigurationManagerAccessor dLightConfigurationManagerAccessor = DLightConfigurationManagerAccessor.getDefault();
        DLightConfigurationManager dLightConfigurationManager = DLightConfigurationManager.getInstance();
        this.allDLightTools = dLightConfigurationManagerAccessor.getDefaultConfiguration(dLightConfigurationManager).getToolsSet();
        this.initDialog(DLightConfigurationUIWrapperProvider.getInstance().getDLightConfigurationUIWrappers(), string);
        this.setPreferredSize(new Dimension(700, 400));
    }

    private void initDialog(List<DLightConfigurationUIWrapper> list, String string) {
        this.profileConfigurationComboBox.removeAllItems();
        this.dLightConfigurations = list;
        Collections.sort(this.dLightConfigurations, new DLightConfigurationComparator());
        DLightConfigurationUIWrapper dLightConfigurationUIWrapper = null;
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper2 : this.dLightConfigurations) {
            this.profileConfigurationComboBox.addItem(dLightConfigurationUIWrapper2);
            if (string == null || !dLightConfigurationUIWrapper2.getDisplayName().equals(string)) continue;
            dLightConfigurationUIWrapper = dLightConfigurationUIWrapper2;
        }
        this.profileConfigurationComboBox.addItem(manageConfigurations);
        if (dLightConfigurationUIWrapper != null) {
            this.profileConfigurationComboBox.setSelectedItem(dLightConfigurationUIWrapper);
        } else {
            this.profileConfigurationComboBox.setSelectedIndex(0);
        }
    }

    private void initConfigurationPanel(DLightConfigurationUIWrapper dLightConfigurationUIWrapper) {
        DLightConfiguration dLightConfiguration = dLightConfigurationUIWrapper.getDLightConfiguration();
        assert (dLightConfiguration != null);
        this.toolsTable = new ToolsTable(dLightConfigurationUIWrapper, dLightConfigurationUIWrapper.getTools(), new MySelectionListener());
        this.toolsList.setViewportView(this.toolsTable);
        this.toolsTable.initSelection();
        this.toolsLabel.setLabelFor(this.toolsTable);
    }

    private DLightConfigurationUIWrapper inList(String string, List<DLightConfigurationUIWrapper> list) {
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : list) {
            if (!string.equals(dLightConfigurationUIWrapper.getName())) continue;
            return dLightConfigurationUIWrapper;
        }
        return null;
    }

    @Override
    public boolean apply() {
        DLightConfiguration dLightConfiguration;
        List list;
        String string;
        List list2;
        Object object2;
        List<DLightConfigurationUIWrapper> list3 = DLightConfigurationUIWrapperProvider.getInstance().getDLightConfigurationUIWrappers();
        ArrayList<DLightConfigurationUIWrapper> arrayList = new ArrayList<DLightConfigurationUIWrapper>();
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : list3) {
            object2 = this.inList(dLightConfigurationUIWrapper.getName(), this.dLightConfigurations);
            if (object2 != null && ((DLightConfigurationUIWrapper)object2).getCopyOf() == null) continue;
            arrayList.add(dLightConfigurationUIWrapper);
        }
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : arrayList) {
            DLightConfigurationSupport.getInstance().removeConfiguration(dLightConfigurationUIWrapper.getName());
        }
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : this.dLightConfigurations) {
            if (!dLightConfigurationUIWrapper.isCustom() || dLightConfigurationUIWrapper.getCopyOf() != null || dLightConfigurationUIWrapper.getName().equals(dLightConfigurationUIWrapper.getDLightConfiguration().getConfigurationName())) continue;
            object2 = dLightConfigurationUIWrapper.getDLightConfiguration();
            String object3 = object2.getCategoryName();
            list2 = object2.getPlatforms();
            string = object2.getCollectorProviders();
            list = object2.getIndicatorProviders();
            DLightConfigurationSupport.getInstance().removeConfiguration(object2.getConfigurationName());
            dLightConfiguration = DLightConfigurationSupport.getInstance().registerConfiguration(dLightConfigurationUIWrapper.getName(), dLightConfigurationUIWrapper.getDisplayName(), object3, list2, string, list);
            dLightConfigurationUIWrapper.setDLightConfiguration(dLightConfiguration);
            for (DLightToolUIWrapper dLightToolUIWrapper : dLightConfigurationUIWrapper.getTools()) {
                dLightToolUIWrapper.setModified(true);
            }
        }
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : this.dLightConfigurations) {
            if (!dLightConfigurationUIWrapper.isCustom() || dLightConfigurationUIWrapper.getCopyOf() == null) continue;
            object2 = dLightConfigurationUIWrapper.getCopyOf();
            String string2 = object2.getCategoryName();
            list2 = object2.getPlatforms();
            string = object2.getCollectorProviders();
            list = object2.getIndicatorProviders();
            dLightConfiguration = DLightConfigurationSupport.getInstance().registerConfigurationAsACopy(dLightConfigurationUIWrapper.getCopyOf(), dLightConfigurationUIWrapper.getName(), dLightConfigurationUIWrapper.getDisplayName(), string2, list2, string, list);
            dLightConfigurationUIWrapper.setDLightConfiguration(dLightConfiguration);
            for (DLightToolUIWrapper dLightToolUIWrapper : dLightConfigurationUIWrapper.getTools()) {
                dLightToolUIWrapper.setModified(true);
            }
            dLightConfigurationUIWrapper.setCopyOf(null);
        }
        for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : this.dLightConfigurations) {
            for (DLightToolUIWrapper dLightToolUIWrapper : dLightConfigurationUIWrapper.getTools()) {
                if (!dLightToolUIWrapper.isModified()) continue;
                if (!dLightToolUIWrapper.canEnable()) {
                    DLightConfigurationSupport.getInstance().deleteTool(dLightConfigurationUIWrapper.getName(), dLightToolUIWrapper.getDLightTool());
                    continue;
                }
                DLightConfigurationSupport.getInstance().registerTool(dLightConfigurationUIWrapper.getName(), dLightToolUIWrapper.getDLightTool().getID(), dLightToolUIWrapper.isEnabled());
            }
        }
        DLightConfigurationUIWrapperProvider.getInstance().setDLightConfigurationUIWrappers(this.dLightConfigurations);
        return true;
    }

    private DLightToolUIWrapper getSelectedDLightToolWrapper() {
        int n = this.toolsTable.getSelectedRow();
        DLightConfigurationUIWrapper dLightConfigurationUIWrapper = (DLightConfigurationUIWrapper)this.profileConfigurationComboBox.getSelectedItem();
        DLightToolUIWrapper dLightToolUIWrapper = dLightConfigurationUIWrapper.getTools().get(n);
        return dLightToolUIWrapper;
    }

    private static String getString(String string, String ... stringArray) {
        return NbBundle.getMessage(ToolsManagerPanel.class, (String)string, (Object[])stringArray);
    }

    private void initComponents() {
        this.profileConfigurationLabel = new JLabel();
        this.profileConfigurationComboBox = new JComboBox();
        this.toolsLabel = new JLabel();
        this.toolsList = new JScrollPane();
        this.jList1 = new JList();
        this.detailsLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.profileConfigurationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("ProfilerConfiguration_MN").charAt(0));
        this.profileConfigurationLabel.setLabelFor(this.profileConfigurationComboBox);
        this.profileConfigurationLabel.setText(NbBundle.getMessage(ToolsManagerPanel.class, (String)"ToolsManagerPanel.profileConfigurationLabel.text"));
        this.profileConfigurationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolsManagerPanel.this.profileConfigurationComboBoxActionPerformed(actionEvent);
            }
        });
        this.toolsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TOOLS_MN").charAt(0));
        this.toolsLabel.setText(NbBundle.getMessage(ToolsManagerPanel.class, (String)"ToolsManagerPanel.toolsLabel.text"));
        this.toolsList.setOpaque(false);
        this.jList1.setSelectionMode(0);
        this.jList1.setOpaque(false);
        this.toolsList.setViewportView(this.jList1);
        this.descriptionArea.setColumns(20);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(5);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setFocusable(false);
        this.scrollPane.setViewportView(this.descriptionArea);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.profileConfigurationLabel).addPreferredGap(0).add((Component)this.profileConfigurationComboBox, 0, 476, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.toolsList, -2, 288, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scrollPane, -1, 312, Short.MAX_VALUE).add((Component)this.detailsLabel))).add((Component)this.toolsLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.profileConfigurationComboBox, -2, -1, -2).add((Component)this.profileConfigurationLabel)).add(1, 1, 1).add((Component)this.toolsLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.toolsList, -1, 328, Short.MAX_VALUE).add((Component)this.scrollPane, -1, 328, Short.MAX_VALUE).add((Component)this.detailsLabel)).add(21, 21, 21)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void profileConfigurationComboBoxActionPerformed(ActionEvent actionEvent) {
        Object object = this.profileConfigurationComboBox.getSelectedItem();
        if (object instanceof String && ((String)object).equals(manageConfigurations)) {
            this.profileConfigurationComboBox.hidePopup();
            MyListEditorPanel myListEditorPanel = new MyListEditorPanel(this.dLightConfigurations);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)myListEditorPanel, ToolsManagerPanel.getString("TXT_ConfigurationsCustomizer", new String[0]));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            try {
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    Vector<DLightConfigurationUIWrapper> vector = myListEditorPanel.getListData();
                    List<DLightConfigurationUIWrapper> list = DLightConfigurationUIWrapperProvider.getInstance().getDLightConfigurationUIWrappers();
                    list.clear();
                    list.addAll(vector);
                    this.initDialog(vector, null);
                    DLightConfigurationUIWrapper dLightConfigurationUIWrapper = (DLightConfigurationUIWrapper)this.profileConfigurationComboBox.getSelectedItem();
                    this.initConfigurationPanel(dLightConfigurationUIWrapper);
                }
                this.profileConfigurationComboBox.setSelectedIndex(this.lastSelectedIndex);
            }
            finally {
                dialog.dispose();
            }
        } else if (object instanceof DLightConfigurationUIWrapper) {
            DLightConfigurationUIWrapper dLightConfigurationUIWrapper = (DLightConfigurationUIWrapper)object;
            this.initConfigurationPanel(dLightConfigurationUIWrapper);
        } else assert (false);
        this.lastSelectedIndex = this.profileConfigurationComboBox.getSelectedIndex();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DLightConfigurationComparator
    implements Comparator<DLightConfigurationUIWrapper> {
        private DLightConfigurationComparator() {
        }

        @Override
        public int compare(DLightConfigurationUIWrapper dLightConfigurationUIWrapper, DLightConfigurationUIWrapper dLightConfigurationUIWrapper2) {
            return dLightConfigurationUIWrapper.getDisplayName().compareTo(dLightConfigurationUIWrapper2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyListEditorPanel
    extends ListEditorPanel<DLightConfigurationUIWrapper> {
        public MyListEditorPanel(List<DLightConfigurationUIWrapper> list) {
            super(list);
            this.setPreferredSize(new Dimension(400, 300));
            this.getAddButton().setVisible(false);
        }

        private String makeNameUnique(String string) {
            if (this.findDLightConfigurationUIWrapper(string) == null) {
                return string;
            }
            int n = 1;
            String string2;
            while (this.findDLightConfigurationUIWrapper(string2 = string + "_" + n) != null) {
                ++n;
            }
            return string2;
        }

        private String makeNameLegal(String string) {
            String string2 = string;
            string2 = string2.replace("/", "_FSLASH_");
            string2 = string2.replace("\\", "_BSLASH_");
            string2 = string2.replace(".", "_DOT_");
            return string2.trim();
        }

        private DLightConfigurationUIWrapper findDLightConfigurationUIWrapper(String string) {
            for (DLightConfigurationUIWrapper dLightConfigurationUIWrapper : this.getListData()) {
                if (!dLightConfigurationUIWrapper.getDisplayName().equals(string)) continue;
                return dLightConfigurationUIWrapper;
            }
            return null;
        }

        @Override
        public DLightConfigurationUIWrapper copyAction(DLightConfigurationUIWrapper dLightConfigurationUIWrapper) {
            String string = this.makeNameUnique(ToolsManagerPanel.getString("CopyOf", new String[]{dLightConfigurationUIWrapper.getDisplayName()}));
            String string2 = this.makeNameLegal(string);
            DLightConfigurationUIWrapper dLightConfigurationUIWrapper2 = new DLightConfigurationUIWrapper(string2, string, ToolsManagerPanel.this.allDLightTools);
            List<DLightToolUIWrapper> list = dLightConfigurationUIWrapper.getTools();
            List<DLightToolUIWrapper> list2 = dLightConfigurationUIWrapper2.getTools();
            int n = 0;
            for (DLightToolUIWrapper dLightToolUIWrapper : list) {
                DLightToolUIWrapper dLightToolUIWrapper2 = list2.get(n++);
                dLightToolUIWrapper2.setEnabled(dLightToolUIWrapper.isEnabled());
                dLightToolUIWrapper2.setCanEnable(dLightToolUIWrapper.canEnable());
            }
            DLightConfiguration dLightConfiguration = dLightConfigurationUIWrapper.getDLightConfiguration();
            if (dLightConfigurationUIWrapper.getCopyOf() != null) {
                dLightConfiguration = dLightConfigurationUIWrapper.getCopyOf();
            }
            dLightConfigurationUIWrapper2.setCopyOf(dLightConfiguration);
            return dLightConfigurationUIWrapper2;
        }

        @Override
        public void editAction(DLightConfigurationUIWrapper dLightConfigurationUIWrapper) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ToolsManagerPanel.getString("EDIT_DIALOG_LABEL_TXT", new String[0]), ToolsManagerPanel.getString("EDIT_DIALOG_TITLE_TXT", new String[0]));
            inputLine.setInputText(dLightConfigurationUIWrapper.getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string = inputLine.getInputText();
            string = (string = string.trim()).trim().length() == 0 ? dLightConfigurationUIWrapper.getDisplayName() : this.makeNameUnique(string);
            dLightConfigurationUIWrapper.setDisplayName(string);
            String string2 = this.makeNameLegal(string);
            dLightConfigurationUIWrapper.setName(string2);
        }

        @Override
        protected void checkSelection(int n) {
            super.checkSelection(n);
            DLightConfigurationUIWrapper dLightConfigurationUIWrapper = (DLightConfigurationUIWrapper)this.getListData().elementAt(n);
            this.getEditButton().setEnabled(dLightConfigurationUIWrapper.isCustom());
            this.getRemoveButton().setEnabled(dLightConfigurationUIWrapper.isCustom());
        }
    }

    class MySelectionListener
    implements ListSelectionListener {
        MySelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DLightToolUIWrapper dLightToolUIWrapper = ToolsManagerPanel.this.getSelectedDLightToolWrapper();
            ToolsManagerPanel.this.detailsLabel.setText(dLightToolUIWrapper.getDLightTool().getDetailedName());
            String string = dLightToolUIWrapper.getDLightTool().getDescription();
            ToolsManagerPanel.this.descriptionArea.setText(string == null ? "" : string);
        }
    }
}

