/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.BeanNode;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DerbyOptions {
    private static final Logger LOGGER = Logger.getLogger(DerbyOptions.class.getName());
    private static final DerbyOptions INSTANCE = new DerbyOptions();
    public static final String NETBEANS_DERBY_SYSTEM_HOME = "netbeans.derby.system.home";
    static final String PROP_DERBY_LOCATION = "location";
    static final String PROP_DERBY_SYSTEM_HOME = "systemHome";
    static final String INST_DIR = "db-derby-10.1.1.0";
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    public static final String DRIVER_CLASS_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DRIVER_PATH_NET = "lib/derbyclient.jar";
    private static final String DRIVER_PATH_EMBEDDED = "lib/derby.jar";
    public static final String DRIVER_DISP_NAME_NET = "Java DB (Network)";
    public static final String DRIVER_DISP_NAME_EMBEDDED = "Java DB (Embedded)";
    private static final String DRIVER_NAME_NET = "apache_derby_net";
    private static final String DRIVER_NAME_EMBEDDED = "apache_derby_embedded";

    public static DerbyOptions getDefault() {
        return INSTANCE;
    }

    protected final String putProperty(String string, String string2, boolean bl) {
        String string3 = NbPreferences.forModule(DerbyOptions.class).get(string, null);
        if (string2 != null) {
            NbPreferences.forModule(DerbyOptions.class).put(string, string2);
        } else {
            NbPreferences.forModule(DerbyOptions.class).remove(string);
        }
        return string3;
    }

    protected final String getProperty(String string) {
        return NbPreferences.forModule(DerbyOptions.class).get(string, null);
    }

    public String displayName() {
        return NbBundle.getMessage(DerbyOptions.class, (String)"LBL_DerbyOptions");
    }

    public String getLocation() {
        String string = this.getProperty(PROP_DERBY_LOCATION);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public boolean isLocationNull() {
        return this.getProperty(PROP_DERBY_LOCATION) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(String string) {
        Object object;
        if (string != null && string.length() > 0) {
            object = new File(string).getAbsoluteFile();
            if (!((File)object).exists()) {
                String string2 = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)object);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string2);
                throw illegalArgumentException;
            }
            if (!Util.isDerbyInstallLocation((File)object)) {
                String string3 = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_InvalidDerbyLocation", (Object)object);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string3);
                throw illegalArgumentException;
            }
        }
        object = this;
        synchronized (object) {
            DerbyOptions.stopDerbyServer();
            if (string != null && string.length() <= 0) {
                string = DerbyOptions.getDefaultInstallLocation();
            }
            DerbyOptions.registerDrivers(string);
            LOGGER.log(Level.FINE, "Setting location to {0}", string);
            this.putProperty(PROP_DERBY_LOCATION, string, true);
        }
    }

    public synchronized boolean trySetLocation(String string) {
        LOGGER.log(Level.FINE, "trySetLocation: Trying to set location to {0}", string);
        String string2 = this.getLocation();
        if (string2.length() == 0) {
            this.setLocation(string);
            LOGGER.fine("trysetLocation: Succeeded");
            return true;
        }
        File file = new File(string2);
        if (!file.exists() || file.isFile()) {
            this.setLocation(string);
            LOGGER.fine("trysetLocation: correcting");
            return true;
        }
        LOGGER.fine("trySetLocation: Another location already set");
        return false;
    }

    public String getSystemHome() {
        String string = this.getProperty(PROP_DERBY_SYSTEM_HOME);
        if (string == null) {
            string = System.getProperty(NETBEANS_DERBY_SYSTEM_HOME);
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemHome(String string) {
        Object object;
        if (string != null && string.length() > 0) {
            object = new File(string).getAbsoluteFile();
            if (!((File)object).exists() || !((File)object).isDirectory()) {
                String string2 = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)object);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string2);
                throw illegalArgumentException;
            }
            if (!((File)object).canWrite()) {
                String string3 = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryIsNotWritable", (Object)object);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)string3);
                throw illegalArgumentException;
            }
        }
        object = this;
        synchronized (object) {
            DerbyOptions.stopDerbyServer();
            this.putProperty(PROP_DERBY_SYSTEM_HOME, string, true);
        }
    }

    static String getDefaultInstallLocation() {
        File file = InstalledFileLocator.getDefault().locate(INST_DIR, null, false);
        if (file == null) {
            return null;
        }
        if (!Util.isDerbyInstallLocation(file)) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static void stopDerbyServer() {
        RegisterDerby.getDefault().stop();
    }

    private static void registerDrivers(final String string) {
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() {
                    DerbyOptions.registerDriver(DerbyOptions.DRIVER_NAME_NET, DerbyOptions.DRIVER_DISP_NAME_NET, DerbyOptions.DRIVER_CLASS_NET, DerbyOptions.DRIVER_PATH_NET, string);
                    DerbyOptions.registerDriver(DerbyOptions.DRIVER_NAME_EMBEDDED, DerbyOptions.DRIVER_DISP_NAME_EMBEDDED, DerbyOptions.DRIVER_CLASS_EMBEDDED, DerbyOptions.DRIVER_PATH_EMBEDDED, string);
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void registerDriver(String string, String string2, String string3, String string4, String string5) {
        File file;
        JDBCDriver jDBCDriver;
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string3);
        for (int i = 0; i < jDBCDriverArray.length; ++i) {
            jDBCDriver = jDBCDriverArray[i];
            URL[] uRLArray = jDBCDriver.getURLs();
            String string6 = DerbyOptions.getDefault().getLocation();
            if (string6 == null) continue;
            boolean bl = true;
            for (int j = 0; j < uRLArray.length; ++j) {
                Object object;
                File file2 = null;
                if ("file".equals(uRLArray[j].getProtocol())) {
                    try {
                        file2 = new File(uRLArray[j].toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.log(Level.WARNING, null, uRISyntaxException);
                    }
                } else {
                    object = URLMapper.findFileObject((URL)uRLArray[j]);
                    if (object != null) {
                        file2 = FileUtil.toFile((FileObject)object);
                    }
                }
                if (file2 != null && ((String)(object = file2.getAbsolutePath())).startsWith(string6)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            try {
                JDBCDriverManager.getDefault().removeDriver(jDBCDriver);
                continue;
            }
            catch (DatabaseException databaseException) {
                LOGGER.log(Level.WARNING, null, databaseException);
                return;
            }
        }
        if (string5 != null && string5.length() >= 0 && (file = new File(string5, string4)).exists()) {
            try {
                jDBCDriver = JDBCDriver.create((String)string, (String)string2, (String)string3, (URL[])new URL[]{file.toURI().toURL()});
                JDBCDriverManager.getDefault().addDriver(jDBCDriver);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.WARNING, null, malformedURLException);
            }
            catch (DatabaseException databaseException) {
                LOGGER.log(Level.WARNING, null, databaseException);
            }
        }
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)DerbyOptions.getDefault());
    }
}

