/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import org.netbeans.modules.image.ImageDataObject;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.PrintCookie;
import org.openide.text.PrintPreferences;
import org.openide.util.NbBundle;

public class ImagePrintSupport
implements PrintCookie,
Printable,
ImageObserver {
    protected ImageDataObject dataObject;
    protected Image image;
    protected RenderedImage renderedImage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ImagePrintSupport(ImageDataObject imageDataObject) {
        this.dataObject = imageDataObject;
    }

    protected static RenderedImage transformImage(RenderedImage renderedImage, PageFormat pageFormat) throws IllegalArgumentException {
        try {
            AffineTransform affineTransform = new AffineTransform();
            if (pageFormat.getOrientation() != 0) {
                affineTransform.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            }
            if (pageFormat.getImageableWidth() - pageFormat.getImageableX() < (double)renderedImage.getWidth() || pageFormat.getImageableHeight() - pageFormat.getImageableY() < (double)renderedImage.getHeight()) {
                throw new IllegalArgumentException("Page too small for image");
            }
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + (int)pageFormat.getImageableX(), bufferedImage.getHeight() + (int)pageFormat.getImageableY(), bufferedImage.getType());
            return affineTransformOp.filter((BufferedImage)renderedImage, bufferedImage2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        String string;
        try {
            this.image = this.dataObject.getImage();
            string = this.image == null ? "MSG_CouldNotLoad" : null;
        }
        catch (IOException iOException) {
            this.image = null;
            string = "MSG_ErrorWhileLoading";
        }
        if (!$assertionsDisabled && this.image == null == (string == null)) {
            throw new AssertionError();
        }
        if (string != null) {
            this.displayMessage(string, 2);
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat pageFormat = PrintPreferences.getPageFormat((PrinterJob)printerJob);
        book.append(this, pageFormat);
        printerJob.setPageable(book);
        try {
            if (this.image instanceof RenderedImage) {
                this.renderedImage = ImagePrintSupport.transformImage((RenderedImage)((Object)this.image), pageFormat);
            }
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterAbortException printerAbortException) {
            this.displayMessage("CTL_Printer_Abort", 1);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            this.renderedImage = null;
            this.image = null;
        }
    }

    private void displayMessage(String string, final int n) {
        final String string2 = NbBundle.getMessage((Class)ImagePrintSupport.class, (String)string);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, n));
            }
        });
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.renderedImage == null) {
            graphics.drawImage(this.image, (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), this);
        } else {
            graphics2D.drawRenderedImage(this.renderedImage, new AffineTransform());
        }
        return 0;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    static {
        $assertionsDisabled = !ImagePrintSupport.class.desiredAssertionStatus();
    }
}

