/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class XmlOutputParser
extends DefaultHandler {
    private static final int STATE_OUT_OF_SCOPE = 1;
    private static final int STATE_TESTSUITE = 2;
    private static final int STATE_PROPERTIES = 3;
    private static final int STATE_PROPERTY = 4;
    private static final int STATE_TESTCASE = 8;
    private static final int STATE_FAILURE = 12;
    private static final int STATE_ERROR = 13;
    private static final int STATE_OUTPUT_STD = 16;
    private static final int STATE_OUTPUT_ERR = 17;
    private int state = 1;
    int unknownElemNestLevel = 0;
    private final XMLReader xmlReader;
    private JUnitTestSuite suite;
    private Testcase testcase;
    private Trouble trouble;
    private StringBuffer charactersBuf;
    private final RegexpUtils regexp;
    private TestSession testSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JUnitTestSuite parseXmlOutput(Reader reader, TestSession testSession) throws SAXException, IOException {
        XmlOutputParser xmlOutputParser = new XmlOutputParser(testSession);
        try {
            xmlOutputParser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException sAXException) {
            String string = sAXException.getMessage();
            int n = 1;
            if (string != null && ErrorManager.getDefault().isLoggable(n)) {
                ErrorManager.getDefault().log(n, "Exception while parsing XML output from JUnit: " + string);
            }
            throw sAXException;
        }
        catch (IOException iOException) {
            assert (false);
        }
        finally {
            reader.close();
        }
        return xmlOutputParser.suite;
    }

    private XmlOutputParser(TestSession testSession) throws SAXException {
        this.testSession = testSession;
        this.xmlReader = XMLUtil.createXMLReader();
        this.xmlReader.setContentHandler(this);
        this.regexp = RegexpUtils.getInstance();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 3: {
                if (string3.equals("property")) {
                    this.state = 4;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 2: {
                if (string3.equals("testcase")) {
                    this.testcase = this.createTestcaseReport(attributes.getValue("classname"), attributes.getValue("name"), attributes.getValue("time"));
                    this.state = 8;
                    break;
                }
                if (string3.equals("system-out")) {
                    this.state = 16;
                    break;
                }
                if (string3.equals("system-err")) {
                    this.state = 17;
                    break;
                }
                if (string3.equals("properties")) {
                    this.state = 3;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 8: {
                if (string3.equals("failure")) {
                    this.state = 12;
                } else if (string3.equals("error")) {
                    this.state = 13;
                } else {
                    this.startUnknownElem();
                }
                if (this.state < 0) break;
                assert (this.testcase != null);
                this.trouble = new Trouble(this.state == 13);
                String string4 = attributes.getValue("message");
                if (string4 != null) {
                    this.addStackTraceLine(this.trouble, string4, false);
                }
                if ((string4 = attributes.getValue("type")) == null) break;
                this.addStackTraceLine(this.trouble, string4, false);
                break;
            }
            case 1: {
                if (string3.equals("testsuite")) {
                    this.suite = this.createSuite(attributes.getValue("name"), attributes.getValue("tests"), attributes.getValue("failures"), attributes.getValue("errors"), attributes.getValue("time"));
                    this.state = 2;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                this.startUnknownElem();
                break;
            }
            default: {
                assert (this.state < 0);
                ++this.unknownElemNestLevel;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.state) {
            case 3: {
                assert (string3.equals("properties"));
                this.state = 2;
                break;
            }
            case 2: {
                assert (string3.equals("testsuite"));
                this.state = 1;
                break;
            }
            case 8: {
                assert (string3.equals("testcase"));
                assert (this.testcase != null);
                this.suite.getTestcases().add(this.testcase);
                this.testcase = null;
                this.state = 2;
                break;
            }
            case 1: {
                assert (false);
                break;
            }
            case 4: {
                assert (string3.equals("property"));
                this.state = 3;
                break;
            }
            case 12: 
            case 13: {
                assert (this.state == 12 && string3.equals("failure") || this.state == 13 && string3.equals("error"));
                assert (this.testcase != null);
                assert (this.trouble != null);
                if (this.charactersBuf != null) {
                    LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(this.charactersBuf.toString()));
                    try {
                        String string4 = lineNumberReader.readLine();
                        while (string4 != null) {
                            this.addStackTraceLine(this.trouble, string4, true);
                            string4 = lineNumberReader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.charactersBuf = null;
                }
                this.testcase.setTrouble(this.trouble);
                this.trouble = null;
                this.state = 8;
                break;
            }
            case 16: 
            case 17: {
                assert (this.state == 16 && string3.equals("system-out") || this.state == 17 && string3.equals("system-err"));
                if (this.charactersBuf != null) {
                    String[] stringArray = this.getOutput(this.charactersBuf.toString());
                    if (this.state == 16) {
                        // empty if block
                    }
                    this.charactersBuf = null;
                }
                this.state = 2;
                break;
            }
            default: {
                assert (this.state < 0);
                if (--this.unknownElemNestLevel != 0) break;
                this.state = -this.state;
            }
        }
    }

    private void startUnknownElem() {
        this.state = -this.state;
        ++this.unknownElemNestLevel;
    }

    private JUnitTestSuite createSuite(String string, String string2, String string3, String string4, String string5) {
        if (string == null) {
            string = NbBundle.getMessage(XmlOutputParser.class, (String)"UNNKOWN_NAME");
        }
        int n = this.regexp.parseTimeMillisNoNFE(string5);
        JUnitTestSuite jUnitTestSuite = new JUnitTestSuite(string, this.testSession);
        jUnitTestSuite.setElapsedTime(n);
        return jUnitTestSuite;
    }

    private Testcase createTestcaseReport(String string, String string2, String string3) {
        JUnitTestcase jUnitTestcase = new JUnitTestcase(string2, "JUnit test", this.testSession);
        jUnitTestcase.setClassName(string);
        jUnitTestcase.setTimeMillis(this.regexp.parseTimeMillisNoNFE(string3));
        return jUnitTestcase;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.state) {
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                if (this.charactersBuf == null) {
                    this.charactersBuf = new StringBuffer(512);
                }
                this.charactersBuf.append(cArray, n, n2);
            }
        }
    }

    private String[] getOutput(String string) {
        String[] stringArray = string.split("(?:\\r|\\r\\n|\\n)");
        if (stringArray.length >= 1 && stringArray[stringArray.length - 1].length() == 0) {
            String[] stringArray2 = stringArray;
            if ((stringArray = new String[stringArray.length - 1]).length > 0) {
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray.length);
            }
        }
        return stringArray;
    }

    private void addStackTraceLine(Trouble trouble, String string, boolean bl) {
        String[] stringArray;
        Object object;
        if (trouble == null || string == null || string.length() == 0 || string.equals("null")) {
            return;
        }
        if (bl) {
            boolean bl2 = false;
            object = new Pattern[]{this.regexp.getCallstackLinePattern(), this.regexp.getComparisonHiddenPattern(), this.regexp.getFullJavaIdPattern()};
            for (Pattern pattern : object) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return;
            }
        }
        if ((stringArray = trouble.getStackTrace()) == null) {
            trouble.setStackTrace(new String[]{string});
            object = this.regexp.getComparisonPattern().matcher(string);
            if (((Matcher)object).matches()) {
                trouble.setComparisonFailure(new Trouble.ComparisonFailure(((Matcher)object).group(1) + ((Matcher)object).group(2) + ((Matcher)object).group(3), ((Matcher)object).group(4) + ((Matcher)object).group(5) + ((Matcher)object).group(6)));
                return;
            }
            object = this.regexp.getComparisonHiddenPattern().matcher(string);
            if (((Matcher)object).matches()) {
                trouble.setComparisonFailure(new Trouble.ComparisonFailure(((Matcher)object).group(1), ((Matcher)object).group(2)));
                return;
            }
        } else {
            object = new ArrayList<String>(Arrays.asList(this.trouble.getStackTrace()));
            if (!string.startsWith((String)object.get(object.size() - 1))) {
                object.add(string);
                trouble.setStackTrace(object.toArray(new String[object.size()]));
            }
        }
    }
}

