/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.UnsupportedCharsetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.junit.output.AntSessionInfo;
import org.netbeans.modules.junit.output.JUnitExecutionManager;
import org.netbeans.modules.junit.output.JUnitTestRunnerNodeFactory;
import org.netbeans.modules.junit.output.JUnitTestSession;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.XmlOutputParser;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.SAXException;

final class JUnitOutputReader {
    private static final int MAX_REPORT_FILE_SIZE = 0x400000;
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    private final NumberFormat numberFormat = NumberFormat.getInstance();
    private final TestSession.SessionType sessionType;
    private boolean expectXmlReport;
    private final File antScript;
    private final long timeOfSessionStart;
    private RegexpUtils regexp = RegexpUtils.getInstance();
    private boolean lastHeaderBrief;
    private final Manager manager = Manager.getInstance();
    private ClassPath platformSources;
    private TestSession testSession;
    private Project project;
    private File resultsDir;
    private JUnitTestcase testcase;
    private Report report;
    private State state = State.DEFAULT;
    private long lastSuiteTime = 0L;

    JUnitOutputReader(AntSession antSession, AntSessionInfo antSessionInfo, Project project, Properties properties) {
        this.project = project;
        this.sessionType = antSessionInfo.getSessionType();
        this.antScript = FileUtil.normalizeFile((File)antSession.getOriginatingScript());
        this.timeOfSessionStart = antSessionInfo.getTimeOfTestTaskStart();
        if (project == null) {
            FileObject fileObject = FileUtil.toFileObject((File)this.antScript);
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        this.testSession = new JUnitTestSession("", this.project, this.sessionType, new JUnitTestRunnerNodeFactory());
        this.testSession.setRerunHandler((RerunHandler)new JUnitExecutionManager(antSession, this.testSession, properties));
    }

    Project getProject() {
        return this.project;
    }

    TestSession getTestSession() {
        return this.testSession;
    }

    void verboseMessageLogged(AntEvent antEvent) {
        String string = antEvent.getMessage();
        if (string == null) {
            return;
        }
        this.verboseMessageLogged(string);
    }

    synchronized void verboseMessageLogged(String string) {
        switch (this.state) {
            case SUITE_STARTED: {
                if (!string.startsWith("junit.framework.TestListener: ")) break;
                String string2 = string.substring("junit.framework.TestListener: ".length());
                if (string2.startsWith("tests to run: ")) {
                    return;
                }
                int n = string2.indexOf(40);
                if (n == -1) {
                    return;
                }
                String string3 = string2.substring(0, n);
                if (!string3.equals("startTest")) break;
                String string4 = string2.substring("startTest".length());
                if (string4.length() != 0) {
                    char c = string4.charAt(0);
                    char c2 = string4.charAt(string4.length() - 1);
                    if (c == '(' && c2 == ')') {
                        this.testCaseStarted(string4.substring(1, string4.length() - 1));
                    }
                }
                return;
            }
            case TESTCASE_STARTED: {
                int n;
                String string5;
                boolean bl;
                String string6;
                if (!string.startsWith("junit.framework.TestListener: ")) break;
                String string7 = string.substring("junit.framework.TestListener: ".length());
                int n2 = string7.indexOf(40);
                if (n2 == -1) {
                    return;
                }
                String string8 = string7.substring(0, n2);
                if (string8.equals("endTest")) {
                    String string9 = string7.substring("endTest".length());
                    if (string9.length() != 0) {
                        String string10;
                        char c = string9.charAt(0);
                        char c3 = string9.charAt(string9.length() - 1);
                        if (c == '(' && c3 == ')' && (string10 = string9.substring(1, string9.length() - 1)).equals(this.testSession.getCurrentTestCase().getName())) {
                            this.testCaseFinished();
                        }
                    }
                    return;
                }
                if (!string8.equals("addFailure") && !string8.equals("addError")) break;
                int n3 = string7.length() - 1;
                String string11 = string7.substring(string8.length() + 1, n3);
                int n4 = string11.indexOf(44);
                String string12 = string6 = n4 == -1 ? string11 : string11.substring(0, n4);
                if (!string6.equals(this.testSession.getCurrentTestCase().getName())) {
                    return;
                }
                this.testSession.getCurrentTestCase().setTrouble(new Trouble(string8.equals("addError")));
                boolean bl2 = bl = n4 != -1 && n4 + 2 <= string11.length();
                if (bl && !(string5 = string11.substring(n = Character.isSpaceChar(string11.charAt(n4 + 1)) ? n4 + 2 : n4 + 1)).equals("null")) {
                    this.addStackTraceLine(this.testSession.getCurrentTestCase(), string5, false);
                }
                return;
            }
            case DEFAULT: 
            case SUITE_FINISHED: 
            case TESTCASE_ISSUE: {
                String string13;
                ClassPath classPath;
                Matcher matcher = RegexpUtils.JAVA_EXECUTABLE.matcher(string);
                if (!matcher.find() || (classPath = this.findPlatformSources(string13 = matcher.group(1))) == null) break;
                this.platformSources = classPath;
                break;
            }
        }
    }

    synchronized void messageLogged(AntEvent antEvent) {
        String string = antEvent.getMessage();
        if (string == null) {
            return;
        }
        switch (this.state) {
            case SUITE_FINISHED: 
            case TESTCASE_ISSUE: {
                if (string.startsWith("Testcase: ")) {
                    boolean bl;
                    String string2 = string.substring("Testcase: ".length());
                    boolean bl2 = this.lastHeaderBrief ? this.tryParseBriefHeader(string2) || !(this.lastHeaderBrief = !this.tryParsePlainHeader(string2)) : (bl = this.tryParsePlainHeader(string2) || (this.lastHeaderBrief = this.tryParseBriefHeader(string2)));
                    if (!bl) break;
                    this.state = State.TESTCASE_ISSUE;
                    break;
                }
            }
            case DEFAULT: {
                if (string.startsWith("Testsuite: ")) {
                    String string3 = string.substring("Testsuite: ".length());
                    if (this.regexp.getFullJavaIdPattern().matcher(string3).matches()) {
                        this.suiteStarted(string3);
                        this.resultsDir = JUnitOutputReader.determineResultsDir(antEvent);
                    }
                }
                if (!this.state.equals((Object)State.TESTCASE_ISSUE) || string.equals("")) break;
                this.addStackTraceLine(this.testcase, string, true);
                break;
            }
            case SUITE_STARTED: {
                if (string.startsWith("Tests run: ")) {
                    Matcher matcher = this.regexp.getSuiteStatsPattern().matcher(string);
                    if (matcher.matches()) {
                        try {
                            this.suiteFinished(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), this.parseTime(matcher.group(4)));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            assert (false);
                            break;
                        }
                    }
                    assert (false);
                    break;
                }
            }
            case TESTCASE_STARTED: {
                int n = string.indexOf("junit.framework.TestListener: ");
                if (n != -1) {
                    this.displayOutput(string.substring(0, n), antEvent.getLogLevel() == 1);
                    this.verboseMessageLogged(string.substring(n));
                    break;
                }
                this.displayOutput(string, antEvent.getLogLevel() == 1);
                break;
            }
        }
    }

    private int parseTime(String string) {
        int n;
        try {
            double d = this.numberFormat.parse(string).doubleValue();
            n = Math.round((float)(d * 1000.0));
        }
        catch (ParseException parseException) {
            n = -1;
        }
        return n;
    }

    private static File determineResultsDir(AntEvent antEvent) {
        File file = null;
        String string = antEvent.getTaskName();
        if (string != null) {
            if (string.equals("junit")) {
                file = JUnitOutputReader.determineJunitTaskResultsDir(antEvent);
            } else if (string.equals("java")) {
                file = JUnitOutputReader.determineJavaTaskResultsDir(antEvent);
            }
        }
        if (file != null && file.exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File determineJunitTaskResultsDir(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string2;
            String string3;
            String string4 = taskStructure2.getName();
            if (string4.equals("batchtest") || string4.equals("test")) {
                string = taskStructure2.getAttribute("todir");
                continue;
            }
            if (!string4.equals("formatter") || bl || (string3 = taskStructure2.getAttribute("type")) == null || !"xml".equals(antEvent.evaluate(string3)) || (string2 = taskStructure2.getAttribute("usefile")) != null && !AntProject.toBoolean(antEvent.evaluate(string2))) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        File file = string != null ? JUnitOutputReader.getFile(string, antEvent) : JUnitOutputReader.getBaseDir(antEvent);
        return JUnitOutputReader.findAbsolutePath(file, taskStructure, antEvent);
    }

    private static File determineJavaTaskResultsDir(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure == null) {
            return null;
        }
        String string = null;
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string2;
            String string3;
            int n;
            String string4 = taskStructure2.getName();
            if (!string4.equals("arg")) continue;
            String string5 = taskStructure2.getAttribute("value");
            if (string5 == null) {
                string5 = taskStructure2.getAttribute("line");
            }
            if (string5 == null || !(string5 = antEvent.evaluate(string5)).startsWith("formatter=") || (n = (string3 = string5.substring("formatter=".length())).indexOf(44)) == -1 || !string3.substring(0, n).equals(XML_FORMATTER_CLASS_NAME) || (string = new File(string2 = string3.substring(n + 1)).getParent()) != null) continue;
            string = ".";
        }
        if (string == null) {
            return null;
        }
        File file = !string.equals(".") ? new File(string) : null;
        return JUnitOutputReader.findAbsolutePath(file, taskStructure, antEvent);
    }

    private static File findAbsolutePath(File file, TaskStructure taskStructure, AntEvent antEvent) {
        String string;
        if (JUnitOutputReader.isAbsolute(file)) {
            return file;
        }
        String string2 = taskStructure.getAttribute("fork");
        if (string2 != null && AntProject.toBoolean(antEvent.evaluate(string2)) && (string = taskStructure.getAttribute("dir")) != null && JUnitOutputReader.isAbsolute(file = JUnitOutputReader.combine(JUnitOutputReader.getFile(string, antEvent), file))) {
            return file;
        }
        return JUnitOutputReader.combine(JUnitOutputReader.getBaseDir(antEvent), file);
    }

    private static File combine(File file, File file2) {
        return file2 != null ? new File(file, file2.getPath()) : file;
    }

    private static boolean isAbsolute(File file) {
        return file != null && file.isAbsolute();
    }

    private static File getFile(String string, AntEvent antEvent) {
        return new File(antEvent.evaluate(string));
    }

    private static File getBaseDir(AntEvent antEvent) {
        return new File(antEvent.getProperty("basedir"));
    }

    private ClassPath findPlatformSources(String string) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            File file;
            FileObject fileObject = javaPlatformArray[i].findTool("java");
            if (fileObject == null || !(file = FileUtil.toFile((FileObject)fileObject)).getAbsolutePath().startsWith(string)) continue;
            return javaPlatformArray[i].getSourceFolders();
        }
        return null;
    }

    void testTaskStarted(int n, boolean bl) {
        this.expectXmlReport = bl;
        this.manager.testStarted(this.testSession);
    }

    void testTaskFinished() {
        this.closePereviousReport();
    }

    private void closePereviousReport() {
        TestSuite testSuite = this.testSession.getCurrentSuite();
        if (testSuite != null) {
            JUnitTestSuite jUnitTestSuite;
            File file;
            if (this.resultsDir != null && (file = this.findReportFile()) != null && this.isValidReportFile(file) && (jUnitTestSuite = this.parseReportFile(file)) != null && jUnitTestSuite.getName().equals(testSuite.getName())) {
                this.lastSuiteTime = jUnitTestSuite.getElapsedTime();
                for (Testcase testcase : testSuite.getTestcases()) {
                    if (testcase.getOutput().isEmpty()) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (OutputLine outputLine : testcase.getOutput()) {
                        arrayList.add(outputLine.getLine());
                    }
                    Object object = this.findTest(jUnitTestSuite, testcase.getName());
                    if (object == null) continue;
                    object.addOutputLines(arrayList);
                }
                if (!jUnitTestSuite.getTestcases().isEmpty()) {
                    testSuite.getTestcases().clear();
                    testSuite.getTestcases().addAll(jUnitTestSuite.getTestcases());
                }
            }
            if (this.report == null) {
                this.report = this.testSession.getReport(this.lastSuiteTime);
            } else {
                this.report.update(this.testSession.getReport(this.lastSuiteTime));
            }
            switch (this.state) {
                case SUITE_STARTED: 
                case TESTCASE_STARTED: {
                    this.report.setAborted(true);
                }
            }
            this.manager.displayReport(this.testSession, this.report, true);
            this.report = null;
            this.lastSuiteTime = 0L;
        }
    }

    void buildFinished(AntEvent antEvent) {
        this.manager.sessionFinished(this.testSession);
    }

    private void suiteStarted(String string) {
        this.closePereviousReport();
        JUnitTestSuite jUnitTestSuite = new JUnitTestSuite(string, this.testSession);
        this.testSession.addSuite((TestSuite)jUnitTestSuite);
        this.manager.displaySuiteRunning(this.testSession, (TestSuite)jUnitTestSuite);
        this.state = State.SUITE_STARTED;
        this.platformSources = null;
    }

    private void suiteFinished(int n, int n2, int n3, long l) {
        int n4;
        Testcase testcase2;
        int n5 = n2;
        int n6 = n3;
        int n7 = n - n2 - n3;
        block4: for (Testcase testcase2 : this.testSession.getCurrentSuite().getTestcases()) {
            switch (testcase2.getStatus()) {
                case ERROR: {
                    --n6;
                    continue block4;
                }
                case FAILED: {
                    --n5;
                    continue block4;
                }
            }
            --n7;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            testcase2 = new JUnitTestcase("Unknown", "Unknown", this.testSession);
            testcase2.setStatus(Status.PASSED);
            this.testSession.addTestCase(testcase2);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            testcase2 = new JUnitTestcase("Unknown", "Unknown", this.testSession);
            testcase2.setStatus(Status.FAILED);
            this.testSession.addTestCase(testcase2);
        }
        for (n4 = 0; n4 < n6; ++n4) {
            testcase2 = new JUnitTestcase("Unknown", "Unknown", this.testSession);
            testcase2.setStatus(Status.ERROR);
            this.testSession.addTestCase(testcase2);
        }
        this.lastSuiteTime = l;
        this.state = State.SUITE_FINISHED;
    }

    private void testCaseStarted(String string) {
        JUnitTestcase jUnitTestcase = new JUnitTestcase(string, "JUnit Test", this.testSession);
        this.testSession.addTestCase((Testcase)jUnitTestcase);
        this.state = State.TESTCASE_STARTED;
    }

    private void testCaseFinished() {
        if (this.report == null) {
            this.report = this.testSession.getReport(0L);
        } else {
            this.report.update(this.testSession.getReport(0L));
        }
        this.manager.displayReport(this.testSession, this.report, false);
        this.state = State.SUITE_STARTED;
    }

    private void displayOutput(String string, boolean bl) {
        this.manager.displayOutput(this.testSession, string, bl);
        if (this.state == State.TESTCASE_STARTED) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            Testcase testcase = this.testSession.getCurrentTestCase();
            if (testcase != null) {
                testcase.addOutputLines(arrayList);
            }
        }
    }

    private boolean tryParsePlainHeader(String string) {
        Matcher matcher = this.regexp.getTestcaseHeaderPlainPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            this.testcase = this.findTest(this.testSession.getCurrentSuite(), string2);
            this.testcase.setTimeMillis(this.parseTime(string3));
            return true;
        }
        return false;
    }

    private JUnitTestcase findTest(TestSuite testSuite, String string) {
        JUnitTestcase jUnitTestcase = null;
        for (Testcase testcase : testSuite.getTestcases()) {
            if (!testcase.getName().equals(string)) continue;
            jUnitTestcase = (JUnitTestcase)testcase;
            break;
        }
        return jUnitTestcase;
    }

    private boolean tryParseBriefHeader(String string) {
        Matcher matcher = this.regexp.getTestcaseHeaderBriefPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            boolean bl = matcher.group(3) == null;
            this.testcase = this.findTest(this.testSession.getCurrentSuite(), string2);
            if (this.testcase == null) {
                this.testcase = new JUnitTestcase(string2, "JUnit test", this.testSession);
                this.testSession.addTestCase((Testcase)this.testcase);
            }
            this.testcase.setClassName(string3);
            Trouble trouble = this.testcase.getTrouble();
            if (trouble == null) {
                trouble = new Trouble(bl);
                this.testcase.setTrouble(trouble);
            } else {
                trouble.setError(bl);
                trouble.setStackTrace(null);
            }
            return true;
        }
        return false;
    }

    private File findReportFile() {
        File file = new File(this.resultsDir, "TEST-" + this.testSession.getCurrentSuite().getName() + ".xml");
        return file.isFile() ? file : null;
    }

    private boolean isValidReportFile(File file) {
        Level level;
        if (!file.canRead()) {
            return false;
        }
        long l = file.lastModified();
        long l2 = l - this.timeOfSessionStart;
        Logger logger = Logger.getLogger("org.netbeans.modules.junit.outputreader.timestamps");
        if (logger.isLoggable(level = Level.FINER)) {
            logger.log(level, "Report file: " + file.getPath());
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(this.timeOfSessionStart);
            logger.log(level, "Session start:    " + String.format("%1$tT.%2$03d", gregorianCalendar, gregorianCalendar.get(14)));
            gregorianCalendar.setTimeInMillis(l);
            logger.log(level, "Report timestamp: " + String.format("%1$tT.%2$03d", gregorianCalendar, gregorianCalendar.get(14)));
        }
        if (l2 >= 0L) {
            return true;
        }
        return -l2 <= this.timeOfSessionStart % 1000L;
    }

    private JUnitTestSuite parseReportFile(File file) {
        JUnitTestSuite jUnitTestSuite;
        block6: {
            long l = file.length();
            if (l < 0L || l > 0x400000L) {
                return null;
            }
            jUnitTestSuite = null;
            try {
                jUnitTestSuite = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), this.testSession);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                assert (false);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                int n = 1;
                ErrorManager errorManager = ErrorManager.getDefault();
                if (!errorManager.isLoggable(n)) break block6;
                errorManager.notify(n, errorManager.annotate((Throwable)iOException, "I/O exception while reading JUnit XML report file from JUnit: "));
            }
        }
        return jUnitTestSuite;
    }

    private static int parseNonNegativeInteger(String string) throws NumberFormatException {
        int n = string.length();
        if (n == 0 || n > 8) {
            throw new NumberFormatException();
        }
        char c = string.charAt(0);
        if (c < '0' || c > '9') {
            throw new NumberFormatException();
        }
        int n2 = c - 48;
        if (n > 1) {
            for (char c2 : string.substring(1).toCharArray()) {
                if (c2 < '0' || c2 > '9') {
                    throw new NumberFormatException();
                }
                n2 = 10 * n2 + (c2 - 48);
            }
        }
        return n2;
    }

    private void addStackTraceLine(Testcase testcase, String string, boolean bl) {
        String[] stringArray;
        Object object;
        Trouble trouble = testcase.getTrouble();
        if (trouble == null || string == null || string.length() == 0 || string.equals("null")) {
            return;
        }
        if (bl) {
            boolean bl2 = false;
            object = new Pattern[]{this.regexp.getCallstackLinePattern(), this.regexp.getComparisonHiddenPattern(), this.regexp.getFullJavaIdPattern()};
            for (Pattern pattern : object) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return;
            }
        }
        if ((stringArray = trouble.getStackTrace()) == null) {
            trouble.setStackTrace(new String[]{string});
            object = this.regexp.getComparisonPattern().matcher(string);
            if (((Matcher)object).matches()) {
                trouble.setComparisonFailure(new Trouble.ComparisonFailure(((Matcher)object).group(1) + ((Matcher)object).group(2) + ((Matcher)object).group(3), ((Matcher)object).group(4) + ((Matcher)object).group(5) + ((Matcher)object).group(6)));
                return;
            }
            object = this.regexp.getComparisonHiddenPattern().matcher(string);
            if (((Matcher)object).matches()) {
                trouble.setComparisonFailure(new Trouble.ComparisonFailure(((Matcher)object).group(1), ((Matcher)object).group(2)));
                return;
            }
        } else {
            object = new ArrayList<String>(Arrays.asList(testcase.getTrouble().getStackTrace()));
            if (!string.startsWith((String)object.get(object.size() - 1))) {
                object.add(string);
                trouble.setStackTrace(object.toArray(new String[object.size()]));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        DEFAULT,
        SUITE_STARTED,
        TESTCASE_STARTED,
        SUITE_FINISHED,
        TESTCASE_ISSUE;

    }
}

