/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PersistenceUnitWizard
implements WizardDescriptor.ProgressInstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private Project project;
    private PersistenceUnitWizardDescriptor descriptor;
    private static final Logger LOG = Logger.getLogger(PersistenceUnitWizard.class.getName());

    public static PersistenceUnitWizard create() {
        return new PersistenceUnitWizard();
    }

    public String name() {
        return NbBundle.getMessage(PersistenceUnitWizard.class, (String)"LBL_WizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.descriptor = new PersistenceUnitWizardDescriptor(this.project);
        this.panels = new WizardDescriptor.Panel[]{this.descriptor};
        wizardDescriptor.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(PersistenceUnitWizard.class, (String)"Templates/Persistence/PersistenceUnit"));
        Wizards.mergeSteps((WizardDescriptor)wizardDescriptor, (WizardDescriptor.Panel[])this.panels, null);
    }

    public Set instantiate() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        try {
            progressHandle.start();
            Set set = this.instantiateWProgress(progressHandle);
            return set;
        }
        finally {
            progressHandle.finish();
        }
    }

    private Set instantiateWProgress(ProgressHandle progressHandle) throws IOException {
        Object object;
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = null;
        PUDataObject pUDataObject = null;
        LOG.fine("Instantiating...");
        Library library = null;
        if (this.descriptor.isContainerManaged()) {
            if (this.descriptor.isNonDefaultProviderEnabled() && (library = PersistenceLibrarySupport.getLibrary((Provider)(object = this.descriptor.getSelectedProvider()))) != null && !Util.isDefaultProvider(this.project, (Provider)object)) {
                progressHandle.progress(NbBundle.getMessage(PersistenceUnitWizard.class, (String)"MSG_LoadLibs"));
                Util.addLibraryToProject(this.project, library);
            }
        } else {
            library = PersistenceLibrarySupport.getLibrary(this.descriptor.getSelectedProvider());
            if (library != null) {
                progressHandle.progress(NbBundle.getMessage(PersistenceUnitWizard.class, (String)"MSG_LoadLibs"));
                Util.addLibraryToProject(this.project, library);
            }
        }
        progressHandle.progress(NbBundle.getMessage(PersistenceUnitWizard.class, (String)"MSG_CreatePU"));
        object = library != null ? PersistenceUtils.getJPAVersion(library) : null;
        try {
            LOG.fine("Retrieving PUDataObject");
            pUDataObject = ProviderUtil.getPUDataObject(this.project, (String)object);
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            LOG.log(Level.FINE, "Invalid persistence.xml: " + invalidPersistenceXmlException.getPath(), invalidPersistenceXmlException);
            return Collections.emptySet();
        }
        object = pUDataObject.getPersistence().getVersion();
        if (this.descriptor.isContainerManaged()) {
            LOG.fine("Creating a container managed PU");
            persistenceUnit = "2.0".equals(object) ? new PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
            if (this.descriptor.getDatasource() != null && !"".equals(this.descriptor.getDatasource())) {
                if (this.descriptor.isJTA()) {
                    persistenceUnit.setJtaDataSource(this.descriptor.getDatasource());
                } else {
                    persistenceUnit.setNonJtaDataSource(this.descriptor.getDatasource());
                    persistenceUnit.setTransactionType("RESOURCE_LOCAL");
                }
            }
            if (this.descriptor.isNonDefaultProviderEnabled()) {
                String string = this.descriptor.getNonDefaultProvider();
                persistenceUnit.setProvider(string);
            }
        } else {
            LOG.fine("Creating an application managed PU");
            persistenceUnit = ProviderUtil.buildPersistenceUnit(this.descriptor.getPersistenceUnitName(), this.descriptor.getSelectedProvider(), this.descriptor.getPersistenceConnection(), (String)object);
            persistenceUnit.setTransactionType("RESOURCE_LOCAL");
        }
        if (!Util.isJavaSE(this.project)) {
            persistenceUnit.setExcludeUnlistedClasses(false);
        }
        persistenceUnit.setName(this.descriptor.getPersistenceUnitName());
        ProviderUtil.setTableGeneration(persistenceUnit, this.descriptor.getTableGeneration(), this.project);
        pUDataObject.addPersistenceUnit(persistenceUnit);
        LOG.fine("Saving PUDataObject");
        pUDataObject.save();
        LOG.fine("Saved");
        return Collections.singleton(pUDataObject.getPrimaryFile());
    }
}

