/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParseUtils {
    public static final String EXCEPTION_PREFIX = "version:";
    private static final Logger LOGGER = Logger.getLogger(ParseUtils.class.getName());

    public static String getVersion(InputStream inputStream, DefaultHandler defaultHandler, EntityResolver entityResolver) throws IOException, SAXException {
        XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false);
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.setEntityResolver(entityResolver);
        try {
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            inputStream.close();
            String string = sAXException.getMessage();
            if (string != null && string.startsWith(EXCEPTION_PREFIX)) {
                return string.substring(EXCEPTION_PREFIX.length());
            }
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotParse"), sAXException);
        }
        inputStream.close();
        throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotFindRoot"));
    }

    public static String getVersion(InputSource inputSource, DefaultHandler defaultHandler, EntityResolver entityResolver) throws IOException, SAXException {
        XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false);
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.setEntityResolver(entityResolver);
        try {
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            String string = sAXException.getMessage();
            if (string != null && string.startsWith(EXCEPTION_PREFIX)) {
                return string.substring(EXCEPTION_PREFIX.length());
            }
            throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotParse"), sAXException);
        }
        throw new SAXException(NbBundle.getMessage(ParseUtils.class, (String)"MSG_cannotFindRoot"));
    }

    public static SAXParseException parseDD(InputSource inputSource, EntityResolver entityResolver) throws SAXException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Parsing with ddResolver: " + entityResolver);
        }
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setEntityResolver(entityResolver);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.parse(inputSource);
            SAXParseException sAXParseException = errorHandler.getError();
            if (sAXParseException != null) {
                return sAXParseException;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SAXException sAXException = new SAXException(illegalArgumentException.getMessage(), illegalArgumentException);
            sAXException.initCause(illegalArgumentException);
            throw sAXException;
        }
        return null;
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }
}

