/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.light.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.jaxws.light.JAXWSLightSupportAccessor;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportImpl;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXWSLightSupport {
    public static final String PROPERTY_SERVICE_ADDED = "service-added";
    public static final String PROPERTY_SERVICE_REMOVED = "service-removed";
    private JAXWSLightSupportImpl impl;
    private PropertyChangeSupport propertyChangeSupport;

    private JAXWSLightSupport(JAXWSLightSupportImpl jAXWSLightSupportImpl) {
        if (jAXWSLightSupportImpl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = jAXWSLightSupportImpl;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public static JAXWSLightSupport getJAXWSLightSupport(FileObject fileObject) {
        JAXWSLightSupportProvider jAXWSLightSupportProvider;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (jAXWSLightSupportProvider = (JAXWSLightSupportProvider)project.getLookup().lookup(JAXWSLightSupportProvider.class)) != null) {
            return jAXWSLightSupportProvider.findJAXWSSupport();
        }
        return null;
    }

    public void addService(JaxWsService jaxWsService) {
        this.impl.addService(jaxWsService);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVICE_ADDED, null, jaxWsService);
    }

    public List<JaxWsService> getServices() {
        return this.impl.getServices();
    }

    public void removeService(JaxWsService jaxWsService) {
        this.impl.removeService(jaxWsService);
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVICE_REMOVED, jaxWsService, null);
    }

    public FileObject getDeploymentDescriptorFolder() {
        return this.impl.getDeploymentDescriptorFolder();
    }

    public FileObject getWsdlFolder(boolean bl) {
        return this.impl.getWsdlFolder(bl);
    }

    public FileObject getBindingsFolder(boolean bl) {
        return this.impl.getBindingsFolder(bl);
    }

    public URL getCatalog() {
        return this.impl.getCatalog();
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        return this.impl.getWebservicesMetadataModel();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        JAXWSLightSupportAccessor.DEFAULT = new JAXWSLightSupportAccessor(){

            public JAXWSLightSupport createJAXWSSupport(JAXWSLightSupportImpl jAXWSLightSupportImpl) {
                return new JAXWSLightSupport(jAXWSLightSupportImpl);
            }

            public JAXWSLightSupportImpl getJAXWSSupportImpl(JAXWSLightSupport jAXWSLightSupport) {
                return jAXWSLightSupport == null ? null : jAXWSLightSupport.impl;
            }
        };
    }
}

