/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.view.ui.slides.ResizeGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.SlideBar;
import org.netbeans.core.windows.view.ui.slides.SlideBarActionEvent;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.netbeans.core.windows.view.ui.slides.SlideOperationFactory;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

final class CommandManager
implements ActionListener {
    private final SlideBar slideBar;
    private TabbedContainer slidedTabContainer;
    private Component curSlidedComp;
    private SlidingButton curSlideButton;
    private int curSlideOrientation;
    private int curSlidedIndex;
    private ResizeGestureRecognizer recog;
    private static final boolean NO_POPUP_PLACEMENT_HACK = Boolean.getBoolean("netbeans.popup.no_hack");
    private final Action escapeAction = new EscapeAction();

    public CommandManager(SlideBar slideBar) {
        this.slideBar = slideBar;
        this.recog = new ResizeGestureRecognizer(this);
    }

    ResizeGestureRecognizer getResizer() {
        return this.recog;
    }

    public void slideResize(int n) {
        if (!this.isCompSlided()) {
            return;
        }
        SlideOperation slideOperation = SlideOperationFactory.createSlideResize((Component)this.getSlidedTabContainer(), this.curSlideOrientation);
        Rectangle rectangle = this.getSlidedTabContainer().getBounds(null);
        String string = CommandManager.orientation2Side(this.curSlideOrientation);
        if ("bottom".equals(string)) {
            rectangle.height -= n;
            rectangle.y += n;
        }
        if ("right".equals(string)) {
            rectangle.width -= n;
            rectangle.x += n;
        }
        if ("left".equals(string)) {
            rectangle.width += n;
        }
        slideOperation.setFinishBounds(rectangle);
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideResize", slideOperation));
    }

    public void slideIn(int n) {
        SlideBarDataModel slideBarDataModel = this.slideBar.getModel();
        if (this.isCompSlided() && this.curSlidedComp != slideBarDataModel.getTab(n).getComponent()) {
            this.slideOut(false, false);
        }
        this.curSlidedIndex = n;
        this.curSlidedComp = slideBarDataModel.getTab(n).getComponent();
        this.curSlideOrientation = slideBarDataModel.getOrientation();
        this.curSlideButton = this.slideBar.getButton(n);
        TabbedContainer tabbedContainer = this.updateSlidedTabContainer(n);
        SlideOperation slideOperation = SlideOperationFactory.createSlideIn((Component)tabbedContainer, this.curSlideOrientation, true, true);
        this.curSlideButton.setSelected(true);
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideIn", slideOperation));
        this.recog.attachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), (Component)tabbedContainer);
    }

    public void slideOut(boolean bl, boolean bl2) {
        if (!this.isCompSlided()) {
            return;
        }
        SlideOperation slideOperation = SlideOperationFactory.createSlideOut((Component)this.getSlidedTabContainer(), this.curSlideOrientation, bl2, bl);
        this.curSlideButton.setSelected(false);
        this.recog.detachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), (Component)this.getSlidedTabContainer());
        this.curSlidedComp = null;
        this.curSlideButton = null;
        this.curSlideOrientation = -1;
        this.curSlidedIndex = -1;
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideOut", slideOperation));
    }

    public void slideIntoDesktop(int n, boolean bl) {
        SlideOperation slideOperation = null;
        if (this.isCompSlided()) {
            slideOperation = SlideOperationFactory.createSlideIntoDesktop((Component)this.getSlidedTabContainer(), this.curSlideOrientation, bl);
        }
        this.recog.detachResizeRecognizer(CommandManager.orientation2Side(this.curSlideOrientation), (Component)this.getSlidedTabContainer());
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "disableAutoHide", slideOperation, null, n));
    }

    public void toggleTransparency(int n) {
    }

    public void showPopup(MouseEvent mouseEvent, int n) {
        this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "popup", mouseEvent, n));
    }

    protected static String orientation2Side(int n) {
        String string = "left";
        if (n == 2) {
            string = "left";
        } else if (n == 1) {
            string = "right";
        } else if (n == 3) {
            string = "bottom";
        }
        return string;
    }

    public void setActive(boolean bl) {
        this.getSlidedTabContainer().setActive(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("popup".equals(actionEvent.getActionCommand())) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            if (this.curSlidedComp != null && this.curSlidedComp instanceof TopComponent) {
                TopComponent topComponent = (TopComponent)this.curSlidedComp;
                Action[] actionArray = this.slideBar.getTabbed().getPopupActions(topComponent.getActions(), this.curSlidedIndex);
                if (actionArray == null) {
                    actionArray = topComponent.getActions();
                }
                if (actionArray == null || actionArray.length == 0) {
                    return;
                }
                CommandManager.showPopupMenu(Utilities.actionsToPopup((Action[])actionArray, (Lookup)topComponent.getLookup()), tabActionEvent.getMouseEvent().getPoint(), tabActionEvent.getMouseEvent().getComponent());
            }
        } else if ("disableAutoHide".equals(actionEvent.getActionCommand())) {
            this.slideIntoDesktop(this.curSlidedIndex, true);
        } else if ("toggleTransparency".equals(actionEvent.getActionCommand())) {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            this.toggleTransparency(tabActionEvent.getTabIndex());
        } else if ("maximize".equals(actionEvent.getActionCommand())) {
            this.postEvent(new SlideBarActionEvent((Object)this.slideBar, "slideMaximize", null, null, this.curSlidedIndex));
        } else {
            TabActionEvent tabActionEvent = (TabActionEvent)actionEvent;
            TabActionEvent tabActionEvent2 = new TabActionEvent(tabActionEvent.getSource(), tabActionEvent.getActionCommand(), this.curSlidedIndex, tabActionEvent.getMouseEvent());
            this.postEvent((ActionEvent)tabActionEvent2);
        }
    }

    private Rectangle getScreenCompRect(Component component) {
        Rectangle rectangle = new Rectangle(component.getLocationOnScreen(), component.getSize());
        return rectangle;
    }

    private static void showPopupMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        if (NO_POPUP_PLACEMENT_HACK) {
            jPopupMenu.show(component, point.x, point.y);
            return;
        }
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds((GraphicsConfiguration)component.getGraphicsConfiguration());
        if (point.x + dimension.width > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width - dimension.width;
        }
        if (point.y + dimension.height > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height - dimension.height;
        }
        SwingUtilities.convertPointFromScreen(point, component);
        jPopupMenu.show(component, point.x, point.y);
    }

    private TabbedContainer getSlidedTabContainer() {
        if (this.slidedTabContainer == null) {
            DefaultTabDataModel defaultTabDataModel = new DefaultTabDataModel();
            this.slidedTabContainer = new TabbedContainer((TabDataModel)defaultTabDataModel, 0, this.slideBar.createWinsysInfo());
            this.slidedTabContainer.addActionListener((ActionListener)this);
            Border border = null;
            String string = CommandManager.orientation2Side(this.slideBar.getModel().getOrientation());
            border = UIManager.getBorder("floatingBorder-" + string);
            if (border == null) {
                border = UIManager.getBorder("floatingBorder");
            }
            if (border != null) {
                this.slidedTabContainer.setBorder(border);
            }
            this.registerEscHandler((JComponent)this.slidedTabContainer);
        }
        return this.slidedTabContainer;
    }

    private TabbedContainer updateSlidedTabContainer(int n) {
        TabbedContainer tabbedContainer = this.getSlidedTabContainer();
        TabDataModel tabDataModel = tabbedContainer.getModel();
        SlideBarDataModel slideBarDataModel = this.slideBar.getModel();
        TabData tabData = slideBarDataModel.getTab(n);
        TabData tabData2 = new TabData(tabData.getUserObject(), tabData.getIcon(), tabData.getText(), tabData.getTooltip());
        if (tabDataModel.size() == 0) {
            tabDataModel.addTab(0, tabData2);
        } else {
            tabDataModel.setTab(0, tabData2);
        }
        tabbedContainer.getSelectionModel().setSelectedIndex(0);
        return tabbedContainer;
    }

    private void registerEscHandler(JComponent jComponent) {
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "slideOut");
        jComponent.getActionMap().put("slideOut", this.escapeAction);
    }

    boolean isCompSlided() {
        return this.curSlidedComp != null;
    }

    Component getSlidedComp() {
        if (!this.isCompSlided()) {
            return null;
        }
        return this.slidedTabContainer;
    }

    void syncWithModel() {
        if (this.curSlidedComp == null) {
            return;
        }
        if (!this.slideBar.containsComp(this.curSlidedComp)) {
            this.slideOut(false, false);
        } else {
            SlideBarDataModel slideBarDataModel = this.slideBar.getModel();
            if (this.curSlidedIndex < slideBarDataModel.size()) {
                String string = slideBarDataModel.getTab(this.curSlidedIndex).getText();
                TabDataModel tabDataModel = this.getSlidedTabContainer().getModel();
                String string2 = tabDataModel.getTab(0).getText();
                if (string2 == null || !string2.equals(string)) {
                    tabDataModel.setText(0, string);
                    this.slideBar.repaint();
                }
            }
        }
    }

    private void postEvent(ActionEvent actionEvent) {
        ((TabbedSlideAdapter)this.slideBar.getTabbed()).postActionEvent(actionEvent);
    }

    private final class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CommandManager.this.slideOut(true, true);
        }
    }
}

