/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindSubtypesVisitor
extends FindVisitor {
    private boolean recursive;

    public FindSubtypesVisitor(boolean bl, WorkingCopy workingCopy) {
        super(workingCopy);
        this.recursive = bl;
    }

    @Override
    public Tree visitClass(ClassTree classTree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return (Tree)super.visitClass(classTree, element);
        }
        if (this.recursive) {
            if (this.isSubtype(this.getCurrentPath(), element)) {
                this.addUsage(this.getCurrentPath());
            }
        } else {
            TypeElement typeElement = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            Types types = this.workingCopy.getTypes();
            if (typeElement.getSuperclass() != null && types.isSameType(types.erasure(typeElement.getSuperclass()), types.erasure(element.asType())) || this.containsType(typeElement.getInterfaces(), element.asType())) {
                this.addUsage(this.getCurrentPath());
            }
        }
        return (Tree)super.visitClass(classTree, element);
    }

    private boolean containsType(List<? extends TypeMirror> list, TypeMirror typeMirror) {
        Types types = this.workingCopy.getTypes();
        typeMirror = types.erasure(typeMirror);
        for (TypeMirror typeMirror2 : list) {
            if (!types.isSameType(typeMirror, types.erasure(typeMirror2))) continue;
            return true;
        }
        return false;
    }

    protected boolean isSubtype(TreePath treePath, Element element) {
        TypeMirror typeMirror;
        Types types = this.workingCopy.getTypes();
        Trees trees = this.workingCopy.getTrees();
        TypeMirror typeMirror2 = trees.getTypeMirror(treePath);
        if (typeMirror2 == null) {
            return false;
        }
        return types.isSubtype(typeMirror2 = types.erasure(typeMirror2), typeMirror = types.erasure(element.asType())) && !types.isSameType(typeMirror2, typeMirror);
    }
}

