/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.wsdl.websvcmgr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlDataManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WebServiceListManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WebServiceManager;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WsdlDataImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WsdlDataManagerImpl
implements WsdlDataManager,
PropertyChangeListener {
    private int precedence = 1;

    public WsdlData getWsdlData(String string, String string2, boolean bl) {
        return WebServiceListManager.getInstance().findReadyWsdlData(string);
    }

    public WsdlData addWsdlData(String string, String string2) {
        final WsdlDataImpl wsdlDataImpl = new WsdlDataImpl(string);
        wsdlDataImpl.setStatus(WsdlData.Status.WSDL_UNRETRIEVED);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    WebServiceManager.getInstance().addWebService(wsdlDataImpl, true);
                }
                catch (IOException iOException) {
                    WsdlDataManagerImpl.this.handleException(iOException);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
        return wsdlDataImpl;
    }

    public void removeWsdlData(String string, String string2) {
        WsdlDataImpl wsdlDataImpl = WebServiceListManager.getInstance().findWsdlData(string);
        if (wsdlDataImpl != null) {
            WebServiceManager.getInstance().removeWebService(wsdlDataImpl);
        }
    }

    public void refresh(WsdlData wsdlData) {
        if (wsdlData instanceof WsdlDataImpl) {
            final WsdlDataImpl wsdlDataImpl = (WsdlDataImpl)wsdlData;
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        WebServiceManager.getInstance().refreshWebService(wsdlDataImpl);
                    }
                    catch (IOException iOException) {
                        WsdlDataManagerImpl.this.handleException(iOException);
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
    }

    private void handleException(final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (exception instanceof FileNotFoundException) {
                    String string = NbBundle.getMessage(WsdlDataManagerImpl.class, (String)"INVALID_URL");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                } else {
                    String string = exception != null ? exception.getLocalizedMessage() : null;
                    String string2 = exception != null ? exception.getClass().getName() + " - " + string : null;
                    String string3 = NbBundle.getMessage(WsdlDataManagerImpl.class, (String)"WS_ADD_ERROR") + "\n\n" + string2;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public WsdlData findWsdlData(String string, String string2) {
        return WebServiceListManager.getInstance().findWsdlData(string);
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        return this.precedence;
    }
}

