/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.core.SQLOptions;
import org.netbeans.modules.db.sql.execute.ui.SQLHistoryPanel;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLCloneableEditor
extends CloneableEditor {
    private transient JSplitPane splitter;
    private transient JTabbedPane resultComponent;
    private transient JPopupMenu resultPopupMenu;
    private transient Action closeTabAction;
    private transient Action closeOtherTabsAction;
    private transient Action closeAllTabsAction;
    private transient Action closePreviousTabsAction;
    private transient Component editor;
    private transient List<Component> currentResultTabs;
    private transient SQLExecutionImpl sqlExecution;
    private transient Lookup originalLookup;
    private transient InstanceContent instanceContent = new InstanceContent();
    private transient Lookup ourLookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private transient SQLCloneableEditorLookup resultingLookup;

    public SQLCloneableEditor() {
        super(null);
        this.putClientProperty("oldInitialize", Boolean.TRUE);
    }

    public SQLCloneableEditor(SQLEditorSupport sQLEditorSupport) {
        super((CloneableEditorSupport)sQLEditorSupport);
        this.putClientProperty("oldInitialize", Boolean.TRUE);
        this.initialize();
    }

    void setResults(List<Component> list) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.resultComponent == null && list != null) {
            this.createResultComponent();
        }
        if (this.resultComponent != null) {
            this.populateResults(list);
        }
    }

    private void populateResults(List<Component> list) {
        if (this.currentResultTabs != null && this.closePreviousTabsAction != null) {
            this.closePreviousTabsAction.setEnabled(true);
        } else {
            this.closePreviousTabsAction.setEnabled(false);
        }
        if (list == null) {
            return;
        }
        this.currentResultTabs = list;
        if (!SQLOptions.getDefault().isKeepOldResultTabs()) {
            this.resultComponent.removeAll();
        }
        for (Component component : list) {
            this.resultComponent.add(component);
        }
        if (list.size() > 0) {
            this.resultComponent.setSelectedComponent(list.get(0));
        }
        this.showResultComponent();
    }

    private void createResultComponent() {
        JPanel jPanel = this.findContainer((Component)((Object)this));
        if (jPanel == null) {
            return;
        }
        this.resultComponent = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.createResultPopupMenu();
        this.editor = jPanel.getComponent(0);
        jPanel.removeAll();
        this.splitter = new JSplitPane(0, this.editor, this.resultComponent);
        this.splitter.setBorder(null);
        jPanel.add(this.splitter);
        this.splitter.setDividerLocation(250);
        this.splitter.setDividerSize(7);
        this.showResultComponent();
        this.getActionMap().setParent(new DelegateActionMap(this.getActionMap().getParent(), this.getEditorPane()));
        if (((Object)((Object)this)).equals(TopComponent.getRegistry().getActivated())) {
            this.requestFocusInWindow();
        }
    }

    private void createResultPopupMenu() {
        this.closeTabAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_TAB_ACTION", new String[0])){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLCloneableEditor.this.resultComponent.remove(SQLCloneableEditor.this.resultComponent.getSelectedComponent());
                SQLCloneableEditor.this.enableTabActions();
                if (SQLCloneableEditor.this.resultComponent.getTabCount() == 0) {
                    SQLCloneableEditor.this.hideResultComponent();
                }
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.closeOtherTabsAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_OTHER_TABS_ACTION", new String[0])){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Component component : SQLCloneableEditor.this.resultComponent.getComponents()) {
                    if (component.equals(SQLCloneableEditor.this.resultComponent.getSelectedComponent())) continue;
                    SQLCloneableEditor.this.resultComponent.remove(component);
                    SQLCloneableEditor.this.enableTabActions();
                }
                this.setEnabled(false);
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.closePreviousTabsAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_PREVIOUS_TABS_ACTION", new String[0])){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Component component : SQLCloneableEditor.this.resultComponent.getComponents()) {
                    if (SQLCloneableEditor.this.currentResultTabs == null || SQLCloneableEditor.this.currentResultTabs.contains(component)) continue;
                    SQLCloneableEditor.this.resultComponent.remove(component);
                    SQLCloneableEditor.this.enableTabActions();
                }
                this.setEnabled(false);
                if (SQLCloneableEditor.this.resultComponent.getTabCount() == 0) {
                    SQLCloneableEditor.this.hideResultComponent();
                }
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.closeAllTabsAction = new AbstractAction(SQLCloneableEditor.getMessage("CLOSE_ALL_TABS_ACTION", new String[0])){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLCloneableEditor.this.resultComponent.removeAll();
                SQLCloneableEditor.this.hideResultComponent();
                SQLCloneableEditor.this.revalidate();
            }
        };
        this.resultPopupMenu = new JPopupMenu();
        this.resultPopupMenu.add(this.closeTabAction);
        this.resultPopupMenu.add(this.closeOtherTabsAction);
        this.resultPopupMenu.add(this.closePreviousTabsAction);
        this.resultPopupMenu.add(this.closeAllTabsAction);
        this.resultComponent.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

            protected void showPopup(MouseEvent mouseEvent) {
                SQLCloneableEditor.this.resultPopupMenu.show(SQLCloneableEditor.this.resultComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.resultComponent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SQLCloneableEditor.this.enableTabActions();
            }
        });
        this.resultComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("close".equals(propertyChangeEvent.getPropertyName())) {
                    int n = SQLCloneableEditor.this.resultComponent.getSelectedIndex();
                    SQLCloneableEditor.this.resultComponent.remove((Component)propertyChangeEvent.getNewValue());
                    SQLCloneableEditor.this.enableTabActions();
                    int n2 = SQLCloneableEditor.this.resultComponent.getTabCount();
                    if (n > 0) {
                        --n;
                    }
                    if (n >= 0 && n < n2) {
                        SQLCloneableEditor.this.resultComponent.setSelectedIndex(n);
                    }
                    if (n2 == 0) {
                        SQLCloneableEditor.this.hideResultComponent();
                    }
                    SQLCloneableEditor.this.revalidate();
                }
            }
        });
    }

    private void enableTabActions() {
        int n = this.resultComponent.getTabCount();
        if (n == 0) {
            this.hideResultComponent();
        } else if (n == 1) {
            this.closeAllTabsAction.setEnabled(true);
            this.closeOtherTabsAction.setEnabled(false);
            this.closePreviousTabsAction.setEnabled(false);
        } else {
            this.closeAllTabsAction.setEnabled(true);
            this.closeOtherTabsAction.setEnabled(true);
        }
    }

    private static String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(SQLCloneableEditor.class, (String)string, (Object[])stringArray);
    }

    private void hideResultComponent() {
        if (this.splitter == null) {
            return;
        }
        this.splitter.setBottomComponent(null);
    }

    private void showResultComponent() {
        JPanel jPanel = this.findContainer((Component)((Object)this));
        if (jPanel == null) {
            return;
        }
        if (this.splitter == null) {
            return;
        }
        if (this.splitter.getBottomComponent() == null) {
            this.splitter.setBottomComponent(this.resultComponent);
            this.splitter.setDividerLocation(250);
            this.splitter.setDividerSize(7);
            jPanel.invalidate();
            jPanel.validate();
            jPanel.repaint();
        }
        this.enableTabActions();
    }

    private JPanel findContainer(Component component) {
        if (!(component instanceof JComponent)) {
            return null;
        }
        Component[] componentArray = ((JComponent)component).getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component2 = componentArray[i];
            if (component2 instanceof JPanel && "sqlEditorContainer".equals(component2.getName())) {
                return (JPanel)component2;
            }
            JPanel jPanel = this.findContainer(component2);
            if (jPanel == null) continue;
            return jPanel;
        }
        return null;
    }

    public synchronized Lookup getLookup() {
        Lookup lookup = super.getLookup();
        if (lookup != this.originalLookup) {
            this.originalLookup = lookup;
            if (this.resultingLookup == null) {
                this.resultingLookup = new SQLCloneableEditorLookup();
            }
            this.resultingLookup.updateLookups(new Lookup[]{this.originalLookup, this.ourLookup});
        }
        return this.resultingLookup;
    }

    protected void componentDeactivated() {
        SQLEditorSupport sQLEditorSupport = this.sqlEditorSupport();
        if (sQLEditorSupport.isConsole() && sQLEditorSupport.isValid()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        super.componentDeactivated();
    }

    protected void componentClosed() {
        this.sqlExecution.editorClosed();
        super.componentClosed();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.sqlEditorSupport().isConsole()) {
            try {
                this.cloneableEditorSupport().saveDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.initialize();
    }

    private void initialize() {
        this.sqlExecution = new SQLExecutionImpl();
        this.instanceContent.add((Object)this.sqlExecution);
    }

    private SQLEditorSupport sqlEditorSupport() {
        return (SQLEditorSupport)this.cloneableEditorSupport();
    }

    private final class SQLExecutionImpl
    implements SQLExecution,
    PropertyChangeListener {
        private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

        public SQLExecutionImpl() {
            SQLCloneableEditor.this.sqlEditorSupport().addSQLPropertyChangeListener(this);
        }

        private void editorClosed() {
            SQLCloneableEditor.this.sqlEditorSupport().removeSQLPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.propChangeSupport.firePropertyChange(propertyChangeEvent);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public DatabaseConnection getDatabaseConnection() {
            return SQLCloneableEditor.this.sqlEditorSupport().getActiveDatabaseConnection();
        }

        public void setDatabaseConnection(DatabaseConnection databaseConnection) {
            SQLCloneableEditor.this.sqlEditorSupport().setDatabaseConnection(databaseConnection);
        }

        public void execute() {
            String string = (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    return SQLExecutionImpl.this.getText(SQLCloneableEditor.this.getEditorPane());
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(string, 0, string.length());
        }

        public void executeSelection() {
            final int[] nArray = new int[2];
            String string = (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    int n;
                    JEditorPane jEditorPane = SQLCloneableEditor.this.getEditorPane();
                    int n2 = jEditorPane.getSelectionStart();
                    if (n2 == (n = jEditorPane.getSelectionEnd())) {
                        nArray[0] = nArray[1] = jEditorPane.getCaretPosition();
                    } else {
                        nArray[0] = n2;
                        nArray[1] = n;
                    }
                    return SQLExecutionImpl.this.getText(jEditorPane);
                }
            });
            SQLCloneableEditor.this.sqlEditorSupport().execute(string, nArray[0], nArray[1]);
        }

        public boolean isExecuting() {
            return SQLCloneableEditor.this.sqlEditorSupport().isExecuting();
        }

        public boolean isSelection() {
            Boolean bl = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    JEditorPane jEditorPane = SQLCloneableEditor.this.getEditorPane();
                    return jEditorPane.getSelectionStart() < jEditorPane.getSelectionEnd();
                }
            });
            return bl;
        }

        public String toString() {
            return "SQLExecution[support=" + SQLCloneableEditor.this.sqlEditorSupport().messageName() + ", dbconn=" + SQLCloneableEditor.this.sqlEditorSupport().getActiveDatabaseConnection() + "]";
        }

        private String getText(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            try {
                return document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
                return "";
            }
        }

        public void showHistory() {
            SQLCloneableEditor.this.getComponent().setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        SQLHistoryPanel sQLHistoryPanel = new SQLHistoryPanel(SQLCloneableEditor.this.getEditorPane());
                        Object[] objectArray = new Object[]{DialogDescriptor.CLOSED_OPTION};
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sQLHistoryPanel, NbBundle.getMessage(SQLCloneableEditor.class, (String)"LBL_SQL_HISTORY_TITLE"), false, objectArray, DialogDescriptor.CLOSED_OPTION, 0, new HelpCtx("sql_history"), null);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLCloneableEditor.class, (String)"ACSD_DLG"));
                        dialog.setVisible(true);
                    }
                    finally {
                        SQLCloneableEditor.this.getComponent().setCursor(null);
                    }
                }
            });
        }
    }

    private static final class SQLCloneableEditorLookup
    extends ProxyLookup {
        public SQLCloneableEditorLookup() {
            super(new Lookup[0]);
        }

        public void updateLookups(Lookup[] lookupArray) {
            this.setLookups(lookupArray);
        }
    }

    private static final class DelegateActionMap
    extends ActionMap {
        private ActionMap delegate;
        private JEditorPane editorPane;

        public DelegateActionMap(ActionMap actionMap, JEditorPane jEditorPane) {
            this.delegate = actionMap;
            this.editorPane = jEditorPane;
        }

        public void remove(Object object) {
            super.remove(object);
        }

        public Action get(Object object) {
            boolean bl;
            boolean bl2 = bl = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this.editorPane;
            if (bl) {
                return this.delegate.get(object);
            }
            return null;
        }

        public void put(Object object, Action action) {
            this.delegate.put(object, action);
        }

        public void setParent(ActionMap actionMap) {
            this.delegate.setParent(actionMap);
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] keys() {
            return this.delegate.keys();
        }

        public ActionMap getParent() {
            return this.delegate.getParent();
        }

        public void clear() {
            this.delegate.clear();
        }

        public Object[] allKeys() {
            return this.delegate.allKeys();
        }
    }
}

