/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedMappings
extends Mappings {
    private static final Log log = LogFactory.getLog(ExtendedMappings.class);
    private final Map<String, IdGenerator> namedGenerators;
    private final Map<String, Map<String, Join>> joins;
    private final Map<String, AnnotatedClassType> classTypes;
    private final Map<String, Properties> generatorTables;
    private final Map<Table, List<String[]>> tableUniqueConstraints;
    private final Map<String, String> mappedByResolver;
    private final Map<String, String> propertyRefResolver;
    private final ReflectionManager reflectionManager;
    private final Set<String> defaultNamedQueryNames;
    private final Set<String> defaultNamedNativeQueryNames;
    private final Set<String> defaultSqlResulSetMappingNames;
    private final Set<String> defaultNamedGenerators;
    private final Map<String, AnyMetaDef> anyMetaDefs;

    ExtendedMappings(Map classes, Map collections, Map tables, Map queries, Map sqlqueries, Map sqlResultSetMappings, Set<String> defaultNamedQueryNames, Set<String> defaultNamedNativeQueryNames, Set<String> defaultSqlResulSetMappingNames, Set<String> defaultNamedGenerators, Map imports, List secondPasses, List propertyReferences, NamingStrategy namingStrategy, Map typeDefs, Map filterDefinitions, Map namedGenerators, Map<String, Map<String, Join>> joins, Map<String, AnnotatedClassType> classTypes, Map extendsQueue, Map<String, Mappings.TableDescription> tableNameBinding, Map<Table, Mappings.ColumnNames> columnNameBindingPerTable, List auxiliaryDatabaseObjects, Map<String, Properties> generatorTables, Map<Table, List<String[]>> tableUniqueConstraints, Map<String, String> mappedByResolver, Map<String, String> propertyRefResolver, Map<String, AnyMetaDef> anyMetaDefs, ReflectionManager reflectionManager) {
        super(classes, collections, tables, queries, sqlqueries, sqlResultSetMappings, imports, secondPasses, propertyReferences, namingStrategy, typeDefs, filterDefinitions, extendsQueue, auxiliaryDatabaseObjects, tableNameBinding, columnNameBindingPerTable);
        this.namedGenerators = namedGenerators;
        this.joins = joins;
        this.classTypes = classTypes;
        this.generatorTables = generatorTables;
        this.tableUniqueConstraints = tableUniqueConstraints;
        this.mappedByResolver = mappedByResolver;
        this.propertyRefResolver = propertyRefResolver;
        this.reflectionManager = reflectionManager;
        this.defaultNamedQueryNames = defaultNamedQueryNames;
        this.defaultNamedNativeQueryNames = defaultNamedNativeQueryNames;
        this.defaultSqlResulSetMappingNames = defaultSqlResulSetMappingNames;
        this.defaultNamedGenerators = defaultNamedGenerators;
        this.anyMetaDefs = anyMetaDefs;
    }

    public void addGenerator(IdGenerator generator) throws MappingException {
        IdGenerator old;
        if (!this.defaultNamedGenerators.contains(generator.getName()) && (old = this.namedGenerators.put(generator.getName(), generator)) != null) {
            log.warn((Object)("duplicate generator name: " + generator.getName()));
        }
    }

    public void addJoins(PersistentClass persistentClass, Map<String, Join> joins) throws MappingException {
        Map<String, Join> old = this.joins.put(persistentClass.getEntityName(), joins);
        if (old != null) {
            log.warn((Object)("duplicate joins for class: " + persistentClass.getEntityName()));
        }
    }

    public AnnotatedClassType addClassType(XClass clazz) {
        AnnotatedClassType type = clazz.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (clazz.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (clazz.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
        this.classTypes.put(clazz.getName(), type);
        return type;
    }

    public AnnotatedClassType getClassType(XClass clazz) {
        AnnotatedClassType type = this.classTypes.get(clazz.getName());
        if (type == null) {
            return this.addClassType(clazz);
        }
        return type;
    }

    public IdGenerator getGenerator(String name) {
        return this.getGenerator(name, null);
    }

    public Map<String, Join> getJoins(String persistentClass) {
        return this.joins.get(persistentClass);
    }

    public IdGenerator getGenerator(String name, Map<String, IdGenerator> localGenerators) {
        IdGenerator result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        return this.namedGenerators.get(name);
    }

    public void addGeneratorTable(String name, Properties params) {
        Properties old = this.generatorTables.put(name, params);
        if (old != null) {
            log.warn((Object)("duplicate generator table: " + name));
        }
    }

    public Properties getGeneratorTableProperties(String name, Map<String, Properties> localGeneratorTables) {
        Properties result;
        if (localGeneratorTables != null && (result = localGeneratorTables.get(name)) != null) {
            return result;
        }
        return this.generatorTables.get(name);
    }

    public void addUniqueConstraints(Table table, List uniqueConstraints) {
        List<String[]> oldConstraints = this.tableUniqueConstraints.get(table);
        if (oldConstraints == null) {
            oldConstraints = new ArrayList<String[]>();
            this.tableUniqueConstraints.put(table, oldConstraints);
        }
        oldConstraints.addAll(uniqueConstraints);
    }

    public Map<Table, List<String[]>> getTableUniqueConstraints() {
        return this.tableUniqueConstraints;
    }

    public void addMappedBy(String entityName, String propertyName, String inversePropertyName) {
        this.mappedByResolver.put(entityName + "." + propertyName, inversePropertyName);
    }

    public String getFromMappedBy(String entityName, String propertyName) {
        return this.mappedByResolver.get(entityName + "." + propertyName);
    }

    public void addPropertyReferencedAssociation(String entityName, String propertyName, String propertyRef) {
        this.propertyRefResolver.put(entityName + "." + propertyName, propertyRef);
    }

    public String getPropertyReferencedAssociation(String entityName, String propertyName) {
        return this.propertyRefResolver.get(entityName + "." + propertyName);
    }

    public void addUniquePropertyReference(String referencedClass, String propertyName) {
        super.addUniquePropertyReference(referencedClass, propertyName);
    }

    public void addPropertyReference(String referencedClass, String propertyName) {
        super.addPropertyReference(referencedClass, propertyName);
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    public void addDefaultQuery(String name, NamedQueryDefinition query) {
        super.addQuery(name, query);
        this.defaultNamedQueryNames.add(name);
    }

    public void addDefaultSQLQuery(String name, NamedSQLQueryDefinition query) {
        super.addSQLQuery(name, query);
        this.defaultNamedNativeQueryNames.add(name);
    }

    public void addDefaultGenerator(IdGenerator idGen) {
        this.addGenerator(idGen);
        this.defaultNamedGenerators.add(idGen.getName());
    }

    public void addDefaultResultSetMapping(ResultSetMappingDefinition definition) {
        String name = definition.getName();
        if (!this.defaultSqlResulSetMappingNames.contains(name) && super.getResultSetMapping(name) != null) {
            this.resultSetMappings.remove(name);
        }
        super.addResultSetMapping(definition);
        this.defaultSqlResulSetMappingNames.add(name);
    }

    public void addQuery(String name, NamedQueryDefinition query) throws MappingException {
        if (!this.defaultNamedQueryNames.contains(name)) {
            super.addQuery(name, query);
        }
    }

    public void addResultSetMapping(ResultSetMappingDefinition definition) {
        if (!this.defaultSqlResulSetMappingNames.contains(definition.getName())) {
            super.addResultSetMapping(definition);
        }
    }

    public void addSQLQuery(String name, NamedSQLQueryDefinition query) throws MappingException {
        if (!this.defaultNamedNativeQueryNames.contains(name)) {
            super.addSQLQuery(name, query);
        }
    }

    public Map getClasses() {
        return this.classes;
    }

    public void addAnyMetaDef(AnyMetaDef defAnn) {
        if (this.anyMetaDefs.containsKey(defAnn.name())) {
            throw new AnnotationException("Two @AnyMetaDef with the same name defined: " + defAnn.name());
        }
        this.anyMetaDefs.put(defAnn.name(), defAnn);
    }

    public AnyMetaDef getAnyMetaDef(String name) {
        return this.anyMetaDefs.get(name);
    }
}

