/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.model;

import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.ProducerDeserializer;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.model.XMLComponentDescriptor;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class XMLComponentProducer
extends ComponentProducer {
    private static final Lookup.Result<? extends ProducerDeserializer> result = Lookup.getDefault().lookupResult(ProducerDeserializer.class);
    public static final String COMPONENT_PRODUCER_NODE = "ComponentProducer";
    public static final String VERSION_ATTR = "version";
    public static final String PRODUCERID_ATTR = "producerID";
    public static final String MAIN_COMPONENT_TYPEID_ATTR = "mainComponentTypeID";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String TOOLTIP_ATTR = "toolTip";
    public static final String SMALL_ICON_ATTR = "smallIcon";
    public static final String LARGE_ICON_ATTR = "largeIcon";
    public static final String PREFERRED_CATEGORYID_ATTR = "preferredCategoryID";
    public static final String VERSION_VALUE_1 = "1";

    protected XMLComponentProducer(String string, TypeID typeID, PaletteDescriptor paletteDescriptor) {
        super(string, typeID, paletteDescriptor);
    }

    public static XMLComponentProducer deserialize(String string, Document document) {
        Node node = document.getFirstChild();
        if (!COMPONENT_PRODUCER_NODE.equals(node.getNodeName())) {
            Debug.warning("Invalid root node");
            return null;
        }
        String string2 = XMLComponentDescriptor.getAttributeValue(node, VERSION_ATTR);
        if (!VERSION_VALUE_1.equals(string2)) {
            Debug.warning("Invalid version", string2);
            return null;
        }
        String string3 = XMLComponentDescriptor.getAttributeValue(node, PRODUCERID_ATTR);
        if (string3 == null) {
            Debug.warning("Missing producerID attribute");
            return null;
        }
        String string4 = XMLComponentDescriptor.getAttributeValue(node, MAIN_COMPONENT_TYPEID_ATTR);
        if (string4 == null) {
            Debug.warning("Missing mainComponentTypeID attribute");
            return null;
        }
        PaletteDescriptor paletteDescriptor = new PaletteDescriptor(XMLComponentDescriptor.getAttributeValue(node, PREFERRED_CATEGORYID_ATTR), XMLComponentDescriptor.getAttributeValue(node, DISPLAY_NAME_ATTR), XMLComponentDescriptor.getAttributeValue(node, TOOLTIP_ATTR), XMLComponentDescriptor.getAttributeValue(node, SMALL_ICON_ATTR), XMLComponentDescriptor.getAttributeValue(node, LARGE_ICON_ATTR));
        return new XMLComponentProducer(string3, TypeID.createFrom(string4), paletteDescriptor);
    }

    public ComponentProducer.Result postInitialize(DesignDocument designDocument, DesignComponent designComponent) {
        ComponentProducer componentProducer;
        TypeID typeID;
        ComponentDescriptor componentDescriptor = designDocument.getDescriptorRegistry().getComponentDescriptor(this.getMainComponentTypeID());
        if (componentDescriptor != null && (typeID = componentDescriptor.getTypeDescriptor().getSuperType()) != null && (componentProducer = DocumentSupport.getComponentProducer(designDocument, typeID.toString())) != null) {
            componentProducer.postInitialize(designDocument, designComponent);
        }
        return super.postInitialize(designDocument, designComponent);
    }

    public Boolean checkValidity(final DesignDocument designDocument, boolean bl) {
        if (!this.checkValidityByDeserializers(designDocument)) {
            return false;
        }
        final ComponentProducer[] componentProducerArray = new ComponentProducer[1];
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                TypeID typeID;
                ComponentDescriptor componentDescriptor = designDocument.getDescriptorRegistry().getComponentDescriptor(XMLComponentProducer.this.getMainComponentTypeID());
                if (componentDescriptor != null && (typeID = componentDescriptor.getTypeDescriptor().getSuperType()) != null) {
                    componentProducerArray[0] = DocumentSupport.getComponentProducer(designDocument, typeID.toString());
                }
            }
        });
        if (componentProducerArray[0] == null) {
            return true;
        }
        return componentProducerArray[0].checkValidity(designDocument, bl);
    }

    private boolean checkValidityByDeserializers(DesignDocument designDocument) {
        String string = designDocument.getDocumentInterface().getProjectType();
        for (ProducerDeserializer producerDeserializer : result.allInstances()) {
            if (!string.equals(producerDeserializer.getProjectType()) || producerDeserializer.checkValidity(designDocument, this)) continue;
            return false;
        }
        return true;
    }
}

