/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueFinderUtils {
    private IssueFinderUtils() {
    }

    public static int[] getIssueSpans(String string) {
        Collection collection = Lookup.getDefault().lookupAll(IssueFinder.class);
        if (collection.isEmpty()) {
            return new int[0];
        }
        int[] nArray = null;
        int n = 0;
        for (IssueFinder issueFinder : collection) {
            int[] nArray2 = issueFinder.getIssueSpans(string);
            boolean bl = IssueFinderUtils.checkIssueSpans(nArray2, string.length(), issueFinder);
            if (!bl || nArray2.length == 0) continue;
            if (++n == 1) {
                nArray = nArray2;
                continue;
            }
            assert (nArray != null);
            nArray = IssueFinderUtils.append(nArray, nArray2);
        }
        return nArray != null ? nArray : new int[]{};
    }

    public static List<HyperlinkSpanInfo> getIssueSpansExt(String string) {
        Collection collection = Lookup.getDefault().lookupAll(IssueFinder.class);
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HyperlinkSpanInfo> arrayList = new ArrayList<HyperlinkSpanInfo>(4);
        int n = 0;
        for (IssueFinder issueFinder : collection) {
            int[] nArray = issueFinder.getIssueSpans(string);
            boolean bl = IssueFinderUtils.checkIssueSpans(nArray, string.length(), issueFinder);
            if (!bl || nArray.length == 0) continue;
            ++n;
            for (int i = 0; i < nArray.length; i += 2) {
                arrayList.add(new HyperlinkSpanInfo(issueFinder, nArray[i], nArray[i + 1]));
            }
        }
        return arrayList;
    }

    public static String getIssueNumber(String string, int n, int n2) {
        IssueFinder issueFinder = IssueFinderUtils.determineIssueFinder(string, n, n2);
        if (issueFinder == null) {
            return null;
        }
        return issueFinder.getIssueId(string.substring(n2, n2));
    }

    public static IssueFinder determineIssueFinder(String string, int n, int n2) {
        Collection collection = Lookup.getDefault().lookupAll(IssueFinder.class);
        for (IssueFinder issueFinder : collection) {
            int[] nArray = issueFinder.getIssueSpans(string);
            if (!IssueFinderUtils.checkSpansContainsPair(nArray, n, n2)) continue;
            return issueFinder;
        }
        return null;
    }

    private static boolean checkSpansContainsPair(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] != n || nArray[i + 1] != n2) continue;
            return true;
        }
        return false;
    }

    private static int[] append(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private static boolean checkIssueSpans(int[] nArray, int n, IssueFinder issueFinder) {
        if (nArray == null) {
            Logger.global.warning("Issue finder " + issueFinder.getClass().getName() + " returned <null> from getIssueSpans(...).");
            return false;
        }
        if (nArray.length % 2 != 0) {
            Logger.global.warning("Issue finder " + issueFinder.getClass().getName() + " returned array containing odd number of " + " elements from method getIssueSpans().");
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2++];
            int n4 = nArray[n2++];
            if (n3 < 0 || n4 < 0) {
                Logger.global.warning("Issue finder " + issueFinder.getClass().getName() + " returned invalid data from method" + " getIssueSpans() (negative index).");
                return false;
            }
            if (n3 >= n4) {
                Logger.global.warning("Issue finder " + issueFinder.getClass().getName() + " returned invalid data from method" + " getIssueSpans() (start >= end).");
                return false;
            }
            if (n4 <= n) continue;
            Logger.global.warning("Issue finder " + issueFinder.getClass().getName() + " returned invalid data from method" + " getIssueSpans() (index > text length).");
            return false;
        }
        return true;
    }

    public static class HyperlinkSpanInfo {
        public final IssueFinder issueFinder;
        public final int startOffset;
        public final int endOffset;

        public HyperlinkSpanInfo(IssueFinder issueFinder, int n, int n2) {
            this.issueFinder = issueFinder;
            this.startOffset = n;
            this.endOffset = n2;
        }
    }
}

