/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class QueryTableCellRenderer
extends DefaultTableCellRenderer {
    private Query query;
    private static final int VISIBLE_START_CHARS = 0;
    private static Icon seenValueIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/seen-value.png"));
    private static final MessageFormat issueNewFormat = QueryTableCellRenderer.getFormat("issueNewFormat");
    private static final MessageFormat issueObsoleteFormat = QueryTableCellRenderer.getFormat("issueObsoleteFormat");
    private static final MessageFormat issueModifiedFormat = QueryTableCellRenderer.getFormat("issueModifiedFormat");
    private static final Color unevenLineColor = new Color(15988477);
    private static final Color newHighlightColor = new Color(46080);
    private static final Color modifiedHighlightColor = new Color(255);
    private static final Color obsoleteHighlightColor = new Color(0x999999);

    public QueryTableCellRenderer(Query query) {
        this.query = query;
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage(IssueTable.class, (String)string);
        return new MessageFormat(string2);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        jLabel.setIcon(null);
        if (!this.query.isSaved()) {
            TableCellStyle tableCellStyle = QueryTableCellRenderer.getDefaultCellStyle(jTable, bl, n);
            QueryTableCellRenderer.setRowColors(tableCellStyle, jLabel);
            return jLabel;
        }
        TableCellStyle tableCellStyle = null;
        if (object instanceof IssueNode.SeenProperty) {
            object2 = (IssueNode.SeenProperty)object;
            jLabel.setIcon(((IssueNode.SeenProperty)object2).getValue() == false ? seenValueIcon : null);
            jLabel.setText("");
        }
        if (object instanceof IssueNode.IssueProperty) {
            tableCellStyle = QueryTableCellRenderer.getCellStyle(jTable, this.query, (IssueNode.IssueProperty)object, bl, n);
        }
        if (jLabel instanceof JComponent && tableCellStyle != null) {
            object2 = jLabel;
            ((JComponent)object2).putClientProperty("format", tableCellStyle.format);
            jLabel.setToolTipText(tableCellStyle.tooltip);
            QueryTableCellRenderer.setRowColors(tableCellStyle, (JComponent)object2);
        }
        return jLabel;
    }

    protected void paintComponent(Graphics graphics) {
        QueryTableCellRenderer.fitText(this);
        super.paintComponent(graphics);
    }

    public static void fitText(JLabel jLabel) {
        MessageFormat messageFormat = (MessageFormat)jLabel.getClientProperty("format");
        String string = QueryTableCellRenderer.computeFitText(jLabel);
        if (messageFormat != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            string = TextUtils.escapeForHTMLLabel(string);
            messageFormat.format(new Object[]{string}, stringBuffer, (FieldPosition)null);
            stringBuffer.append("</html>");
            string = stringBuffer.toString();
        }
        jLabel.setText(string);
    }

    private static String computeFitText(JLabel jLabel) {
        String string;
        FontMetrics fontMetrics;
        int n;
        String string2 = jLabel.getText();
        if (string2 == null || string2.length() <= 3) {
            return string2;
        }
        Icon icon = jLabel.getIcon();
        int n2 = icon != null ? icon.getIconWidth() : 0;
        int n3 = jLabel.getSize().width - n2;
        int n4 = n3 - (n = (fontMetrics = jLabel.getFontMetrics(jLabel.getFont())).stringWidth(string = "..."));
        if (n4 <= 0) {
            return string2;
        }
        for (int i = 0; i <= string2.length() - 1; ++i) {
            String string3 = string2.substring(0, i);
            int n5 = fontMetrics.stringWidth(string3);
            if (n5 < n4) continue;
            return string3.length() > 0 ? string3 + string : string2;
        }
        return string2;
    }

    public static TableCellStyle getCellStyle(JTable jTable, Query query, IssueNode.IssueProperty issueProperty, boolean bl, int n) {
        TableCellStyle tableCellStyle = QueryTableCellRenderer.getDefaultCellStyle(jTable, bl, n);
        try {
            Issue issue = issueProperty.getIssue();
            if (!query.contains(issue)) {
                tableCellStyle.format = bl ? tableCellStyle.format : QueryTableCellRenderer.issueObsoleteFormat;
                tableCellStyle.background = bl ? QueryTableCellRenderer.obsoleteHighlightColor : tableCellStyle.background;
            } else {
                int n2 = query.getIssueStatus(issue);
                if (!IssueCacheUtils.wasSeen(issue)) {
                    switch (n2) {
                        case 4: {
                            tableCellStyle.format = bl ? tableCellStyle.format : QueryTableCellRenderer.issueNewFormat;
                            tableCellStyle.background = bl ? QueryTableCellRenderer.newHighlightColor : tableCellStyle.background;
                            break;
                        }
                        case 8: {
                            tableCellStyle.format = bl ? tableCellStyle.format : QueryTableCellRenderer.issueModifiedFormat;
                            tableCellStyle.background = bl ? QueryTableCellRenderer.modifiedHighlightColor : tableCellStyle.background;
                        }
                    }
                }
            }
            Object object = issueProperty.getValue();
            if (object instanceof String) {
                tableCellStyle.tooltip = (String)object;
            }
        }
        catch (Exception exception) {
            BugtrackingManager.LOG.log(Level.WARNING, null, exception);
        }
        return tableCellStyle;
    }

    public static TableCellStyle getDefaultCellStyle(JTable jTable, boolean bl, int n) {
        return new TableCellStyle(null, bl ? jTable.getSelectionBackground() : QueryTableCellRenderer.getUnselectedBackground(n), bl ? Color.WHITE : jTable.getForeground(), null);
    }

    private static Color getUnselectedBackground(int n) {
        return n % 2 != 0 ? unevenLineColor : Color.WHITE;
    }

    public static void setRowColors(TableCellStyle tableCellStyle, JComponent jComponent) {
        if (tableCellStyle == null) {
            assert (false);
            return;
        }
        if (tableCellStyle.background != null) {
            jComponent.setBackground(tableCellStyle.background);
        }
        if (tableCellStyle.foreground != null) {
            jComponent.setForeground(tableCellStyle.foreground);
        }
    }

    public static class TableCellStyle {
        private MessageFormat format;
        private Color background;
        private Color foreground;
        private String tooltip;

        public TableCellStyle(MessageFormat messageFormat, Color color, Color color2, String string) {
            this.background = color;
            this.foreground = color2;
            this.tooltip = string;
            this.format = messageFormat;
        }

        public Color getBackground() {
            return this.background;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public MessageFormat getFormat() {
            return this.format;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            stringBuffer.append("background=");
            stringBuffer.append(this.background);
            stringBuffer.append(", foreground=");
            stringBuffer.append(this.foreground);
            stringBuffer.append(", format=");
            stringBuffer.append(this.format != null ? this.format.toPattern() : null);
            stringBuffer.append(", tooltip=");
            stringBuffer.append(this.tooltip);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TableCellStyle tableCellStyle = (TableCellStyle)object;
            if (!(this.format == tableCellStyle.format || this.format != null && this.format.equals(tableCellStyle.format))) {
                return false;
            }
            if (!(this.background == tableCellStyle.background || this.background != null && this.background.equals(tableCellStyle.background))) {
                return false;
            }
            if (!(this.foreground == tableCellStyle.foreground || this.foreground != null && this.foreground.equals(tableCellStyle.foreground))) {
                return false;
            }
            return !(this.tooltip == null ? tableCellStyle.tooltip != null : !this.tooltip.equals(tableCellStyle.tooltip));
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

