/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatManagerConfig;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.TomcatModuleConfig;
import org.netbeans.modules.tomcat5.util.LogViewer;
import org.netbeans.modules.tomcat5.util.ServerLog;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.netbeans.modules.tomcat5.util.UnsupportedLoggerException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class LogManager {
    private ServerLog serverLog;
    private LogViewer sharedContextLogViewer;
    private LogViewer juliLogViewer;
    private Map tomcatModuleConfigs = Collections.synchronizedMap(new WeakHashMap());
    private Map contextLogViewers = Collections.synchronizedMap(new HashMap());
    private TomcatManager manager;
    private final Object serverLogLock = new Object();
    private final Object sharedContextLogLock = new Object();
    private final Object juliLogLock = new Object();
    private final Object contextLogLock = new Object();
    private Boolean juliJarExist;

    public LogManager(TomcatManager tomcatManager) {
        this.manager = tomcatManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openServerLog() {
        final Process process = this.manager.getTomcatProcess();
        assert (process != null);
        Object object = this.serverLogLock;
        synchronized (object) {
            if (this.serverLog != null) {
                this.serverLog.takeFocus();
                return;
            }
            this.serverLog = new ServerLog(this.manager, this.manager.getTomcatProperties().getDisplayName(), new InputStreamReader(process.getInputStream()), new InputStreamReader(process.getErrorStream()), true, false);
            this.serverLog.start();
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    process.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    LogManager.this.closeServerLog();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeServerLog() {
        Object object = this.serverLogLock;
        synchronized (object) {
            if (this.serverLog != null) {
                this.serverLog.interrupt();
                this.serverLog = null;
            }
        }
    }

    public boolean hasServerLog() {
        return this.manager.getTomcatProcess() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSharedContextLog() {
        Object object;
        TomcatManagerConfig tomcatManagerConfig = this.manager.getTomcatManagerConfig();
        tomcatManagerConfig.refresh();
        if (!tomcatManagerConfig.hasLogger()) {
            return;
        }
        LogViewer logViewer = null;
        try {
            object = this.manager.getTomcatProperties();
            logViewer = new LogViewer(this.manager, null, tomcatManagerConfig.loggerClassName(), tomcatManagerConfig.loggerDir(), tomcatManagerConfig.loggerPrefix(), tomcatManagerConfig.loggerSuffix(), tomcatManagerConfig.loggerTimestamp(), false);
        }
        catch (UnsupportedLoggerException unsupportedLoggerException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(LogManager.class, (String)"MSG_UnsupportedLogger", (Object)unsupportedLoggerException.getLoggerClassName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        catch (NullPointerException nullPointerException) {
            Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, nullPointerException);
        }
        object = this.sharedContextLogLock;
        synchronized (object) {
            if (this.sharedContextLogViewer != null && this.sharedContextLogViewer.isOpen() && !this.sharedContextLogViewer.equals(logViewer)) {
                this.sharedContextLogViewer.removeAllLogViewerStopListener();
                this.sharedContextLogViewer.close();
                this.sharedContextLogViewer = logViewer;
                this.sharedContextLogViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void callOnStop() {
                        Object object = LogManager.this.sharedContextLogLock;
                        synchronized (object) {
                            LogManager.this.sharedContextLogViewer = null;
                        }
                    }
                });
                this.sharedContextLogViewer.start();
            } else if (this.sharedContextLogViewer == null || !this.sharedContextLogViewer.isOpen()) {
                if (this.sharedContextLogViewer != null) {
                    this.sharedContextLogViewer.removeAllLogViewerStopListener();
                }
                this.sharedContextLogViewer = logViewer;
                this.sharedContextLogViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void callOnStop() {
                        Object object = LogManager.this.sharedContextLogLock;
                        synchronized (object) {
                            LogManager.this.sharedContextLogViewer = null;
                        }
                    }
                });
                this.sharedContextLogViewer.start();
            }
            this.sharedContextLogViewer.takeFocus();
        }
    }

    public boolean hasSharedLogger() {
        TomcatManagerConfig tomcatManagerConfig = this.manager.getTomcatManagerConfig();
        tomcatManagerConfig.refresh();
        return tomcatManagerConfig.hasLogger();
    }

    public synchronized boolean hasJuliLog() {
        if (this.juliJarExist == null) {
            this.juliJarExist = new File(this.manager.getTomcatProperties().getCatalinaHome(), "bin/tomcat-juli.jar").exists() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.juliJarExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openJuliLog() {
        Object object = this.juliLogLock;
        synchronized (object) {
            if (this.juliLogViewer == null || !this.juliLogViewer.isOpen()) {
                if (this.juliLogViewer != null) {
                    this.juliLogViewer.removeAllLogViewerStopListener();
                }
                try {
                    TomcatProperties tomcatProperties = this.manager.getTomcatProperties();
                    this.juliLogViewer = new LogViewer(this.manager, null, null, null, "localhost.", null, true, false);
                    this.juliLogViewer.setDisplayName(NbBundle.getMessage(LogManager.class, (String)"TXT_JuliLogDisplayName", (Object)tomcatProperties.getDisplayName()));
                }
                catch (UnsupportedLoggerException unsupportedLoggerException) {
                    Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, unsupportedLoggerException);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, nullPointerException);
                    return;
                }
                this.juliLogViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void callOnStop() {
                        Object object = LogManager.this.juliLogLock;
                        synchronized (object) {
                            LogManager.this.juliLogViewer = null;
                        }
                    }
                });
                this.juliLogViewer.start();
            }
            this.juliLogViewer.takeFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openContextLog(TomcatModule tomcatModule) {
        final String string = tomcatModule.getModuleID();
        Object v = this.tomcatModuleConfigs.get(tomcatModule);
        TomcatModuleConfig tomcatModuleConfig = null;
        LogViewer logViewer = null;
        if (v == null) {
            tomcatModuleConfig = new TomcatModuleConfig(tomcatModule.getDocRoot(), tomcatModule.getPath(), this.manager.getTomcatManagerConfig().serverXmlPath());
            this.tomcatModuleConfigs.put(tomcatModule, tomcatModuleConfig);
        } else {
            tomcatModuleConfig = (TomcatModuleConfig)v;
            tomcatModuleConfig.refresh();
        }
        if (!tomcatModuleConfig.hasLogger()) {
            return;
        }
        logViewer = (LogViewer)this.contextLogViewers.get(string);
        LogViewer logViewer2 = null;
        try {
            logViewer2 = new LogViewer(this.manager, tomcatModule.getPath(), tomcatModuleConfig.loggerClassName(), tomcatModuleConfig.loggerDir(), tomcatModuleConfig.loggerPrefix(), tomcatModuleConfig.loggerSuffix(), tomcatModuleConfig.loggerTimestamp(), false);
        }
        catch (UnsupportedLoggerException unsupportedLoggerException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(LogManager.class, (String)"MSG_UnsupportedLogger", (Object)unsupportedLoggerException.getLoggerClassName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        catch (NullPointerException nullPointerException) {
            Logger.getLogger(LogManager.class.getName()).log(Level.INFO, null, nullPointerException);
        }
        Object object = this.contextLogLock;
        synchronized (object) {
            if (logViewer != null && logViewer.isOpen() && !logViewer.equals(logViewer2)) {
                logViewer.removeAllLogViewerStopListener();
                logViewer.close();
                logViewer = logViewer2;
                logViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    public void callOnStop() {
                        LogManager.this.contextLogViewers.remove(string);
                    }
                });
                this.contextLogViewers.put(string, logViewer);
                logViewer.start();
            } else if (logViewer == null || !logViewer.isOpen()) {
                if (logViewer != null) {
                    logViewer.removeAllLogViewerStopListener();
                }
                logViewer = logViewer2;
                logViewer.addLogViewerStopListener(new LogViewer.LogViewerStopListener(){

                    public void callOnStop() {
                        LogManager.this.contextLogViewers.remove(string);
                    }
                });
                this.contextLogViewers.put(string, logViewer);
                logViewer.start();
            }
        }
        logViewer.takeFocus();
    }

    public boolean hasContextLogger(TomcatModule tomcatModule) {
        Object v = this.tomcatModuleConfigs.get(tomcatModule);
        TomcatModuleConfig tomcatModuleConfig = null;
        if (v == null) {
            tomcatModuleConfig = new TomcatModuleConfig(tomcatModule.getDocRoot(), tomcatModule.getPath(), this.manager.getTomcatManagerConfig().serverXmlPath());
            this.tomcatModuleConfigs.put(tomcatModule, tomcatModuleConfig);
        } else {
            tomcatModuleConfig = (TomcatModuleConfig)v;
            tomcatModuleConfig.refresh();
        }
        return tomcatModuleConfig.hasLogger();
    }
}

