/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.operations;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.maven.project.MavenProject;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.api.validation.adapters.NotificationLineSupportAdapter;
import org.netbeans.modules.maven.MavenValidators;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.DialogDescriptor;
import org.openide.LifecycleManager;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RenameProjectPanel
extends JPanel {
    private final NbMavenProjectImpl project;
    private ValidationGroup vg;
    private NotificationLineSupport nls;
    private JCheckBox cbArtifactId;
    private JCheckBox cbDisplayName;
    private JCheckBox cbFolder;
    private JLabel lblRename;
    private JTextArea taWarning;
    private JTextField txtArtifactId;
    private JTextField txtDisplayName;
    private JTextField txtFolder;
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    static final int MAX_WORK = 100;

    RenameProjectPanel(NbMavenProjectImpl nbMavenProjectImpl) {
        this.initComponents();
        this.txtFolder.putClientProperty("_name", NbBundle.getMessage(RenameProjectPanel.class, (String)"NAME_Folder"));
        this.txtArtifactId.putClientProperty("_name", NbBundle.getMessage(RenameProjectPanel.class, (String)"NAME_Artifact"));
        this.project = nbMavenProjectImpl;
        String string = this.project.getProjectDirectory().getNameExt();
        this.txtFolder.setText(string);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MavenProject mavenProject = RenameProjectPanel.this.project.getOriginalMavenProject();
                final String string = mavenProject.getName();
                final String string2 = mavenProject.getArtifactId();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RenameProjectPanel.this.txtArtifactId.setText(string2);
                        RenameProjectPanel.this.txtDisplayName.setText(string);
                        RenameProjectPanel.this.lblRename.setText(NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.lblRename.text2", (Object)string));
                    }
                });
            }
        });
    }

    void createValidations(DialogDescriptor dialogDescriptor) {
        this.nls = dialogDescriptor.createNotificationLineSupport();
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new NotificationLineSupportAdapter(this.nls), new DialogDescriptorAdapter(dialogDescriptor)});
        this.vg.add((JTextComponent)this.txtFolder, new Validator[]{new OptionalValidator(this.cbFolder, (Validator<String>)Validators.merge((boolean)true, (Validator[])new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, Validators.REQUIRE_VALID_FILENAME, new FileNameExists(FileUtil.toFile((FileObject)this.project.getProjectDirectory().getParent()))}))});
        this.vg.add((JTextComponent)this.txtArtifactId, new Validator[]{new OptionalValidator(this.cbArtifactId, MavenValidators.createArtifactIdValidators())});
        this.checkEnablement();
    }

    private void checkEnablement() {
        this.txtArtifactId.setEnabled(this.cbArtifactId.isSelected());
        this.txtDisplayName.setEnabled(this.cbDisplayName.isSelected());
        this.txtFolder.setEnabled(this.cbFolder.isSelected());
        this.taWarning.setText(this.cbFolder.isSelected() ? NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.taWarning.text") : "");
    }

    private void initComponents() {
        this.lblRename = new JLabel();
        this.cbDisplayName = new JCheckBox();
        this.txtDisplayName = new JTextField();
        this.cbArtifactId = new JCheckBox();
        this.txtArtifactId = new JTextField();
        this.cbFolder = new JCheckBox();
        this.txtFolder = new JTextField();
        this.taWarning = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.lblRename, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.lblRename.text"));
        this.cbDisplayName.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbDisplayName, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbDisplayName.text"));
        this.cbDisplayName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameProjectPanel.this.cbDisplayNameActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbArtifactId, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbArtifactId.text"));
        this.cbArtifactId.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameProjectPanel.this.cbArtifactIdActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbFolder, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbFolder.text"));
        this.cbFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameProjectPanel.this.cbFolderActionPerformed(actionEvent);
            }
        });
        this.taWarning.setColumns(20);
        this.taWarning.setEditable(false);
        this.taWarning.setForeground(UIManager.getColor("nb.errorForeground"));
        this.taWarning.setLineWrap(true);
        this.taWarning.setRows(5);
        this.taWarning.setText(NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.taWarning.text"));
        this.taWarning.setWrapStyleWord(true);
        this.taWarning.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.lblRename).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.taWarning, -2, 395, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbArtifactId).add((Component)this.cbDisplayName).add((Component)this.cbFolder)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtDisplayName, -1, 258, Short.MAX_VALUE).add((Component)this.txtArtifactId, -1, 258, Short.MAX_VALUE).add((Component)this.txtFolder, -1, 258, Short.MAX_VALUE)))))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblRename).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbDisplayName).add((Component)this.txtDisplayName, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbArtifactId).add((Component)this.txtArtifactId, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbFolder).add((Component)this.txtFolder, -2, -1, -2)).addPreferredGap(0).add((Component)this.taWarning, -2, 66, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cbDisplayNameActionPerformed(ActionEvent actionEvent) {
        this.vg.validateAll();
        this.checkEnablement();
    }

    private void cbArtifactIdActionPerformed(ActionEvent actionEvent) {
        this.vg.validateAll();
        this.checkEnablement();
    }

    private void cbFolderActionPerformed(ActionEvent actionEvent) {
        this.vg.validateAll();
        this.checkEnablement();
    }

    void renameProject() {
        final boolean bl = this.cbArtifactId.isSelected();
        final boolean bl2 = this.cbDisplayName.isSelected();
        final boolean bl3 = this.cbFolder.isSelected();
        final String string = this.txtArtifactId.getText().trim();
        final String string2 = this.txtDisplayName.getText().trim();
        final String string3 = this.txtFolder.getText().trim();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (bl) {
                    arrayList.add(new ArtIdOperation(string));
                }
                if (bl2) {
                    arrayList.add(new DNameOperation(string2));
                }
                FileObject fileObject = RenameProjectPanel.this.project.getProjectDirectory().getFileObject("pom.xml");
                Utilities.performPOMModelOperations((FileObject)fileObject, arrayList);
                if (!bl3) return;
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)("Rename Project" + bl2));
                progressHandle.start(100);
                try {
                    RenameProjectPanel.this.checkParentProject(RenameProjectPanel.this.project.getProjectDirectory().getNameExt(), string3);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                try {
                    try {
                        RenameProjectPanel.doMoveProject(progressHandle, RenameProjectPanel.this.project, string3, RenameProjectPanel.this.project.getProjectDirectory().getParent());
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                        Object var6_7 = null;
                        progressHandle.finish();
                        return;
                    }
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    progressHandle.finish();
                    throw throwable;
                }
                progressHandle.finish();
            }
        });
    }

    private void checkParentProject(final String string, final String string2) throws IOException {
        NbMavenProjectImpl nbMavenProjectImpl;
        FileObject fileObject = this.project.getProjectDirectory().getParent();
        Project project = ProjectManager.getDefault().findProject(fileObject);
        if (project != null && (nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class)) != null) {
            FileObject fileObject2 = nbMavenProjectImpl.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    List list = pOMModel.getProject().getModules();
                    if (list != null && list.contains(string2)) {
                        pOMModel.getProject().removeModule(string2);
                        pOMModel.getProject().addModule(string);
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)fileObject2, Collections.singletonList(modelOperation));
        }
    }

    static void doMoveProject(ProgressHandle progressHandle, Project project, String string, FileObject fileObject) throws Exception {
        boolean bl = true;
        Project project2 = OpenProjects.getDefault().getMainProject();
        boolean bl2 = project2 != null && project.getProjectDirectory().equals(project2.getProjectDirectory());
        FileObject fileObject2 = null;
        try {
            int n;
            int n2 = 100;
            double d = 0.0;
            progressHandle.progress((int)d);
            RenameProjectPanel.close(project);
            d = (double)n2 * 0.1;
            progressHandle.progress((int)d);
            FileObject fileObject3 = project.getProjectDirectory();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject4 : fileObject3.getChildren()) {
                if (!fileObject4.isValid()) continue;
                arrayList.add(fileObject4);
            }
            double d2 = (double)n2 * 0.7000000000000001 / (double)arrayList.size() / 2.0;
            fileObject2 = fileObject.createFolder(string);
            for (FileObject fileObject4 : arrayList) {
                RenameProjectPanel.doCopy(project, fileObject4, fileObject2);
                n = (int)d;
                if (n >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            bl = false;
            for (FileObject fileObject4 : arrayList) {
                RenameProjectPanel.doDelete(project, fileObject4);
                n = (int)d;
                if (n >= (int)(d += d2)) continue;
                progressHandle.progress((int)d);
            }
            if (fileObject3.getChildren().length == 0) {
                fileObject3.delete();
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project project3 = ProjectManager.getDefault().findProject(fileObject2);
            progressHandle.progress((int)(d += (double)n2 * 0.1));
            assert (project3 != null);
            progressHandle.progress((int)(d += (double)n2 * 0.1));
            ProjectManager.getDefault().saveProject(project3);
            RenameProjectPanel.open(project3, bl2);
            progressHandle.progress(n2);
        }
        catch (Exception exception) {
            if (bl) {
                RenameProjectPanel.open(project, bl2);
            } else {
                assert (fileObject2 != null);
                ProjectManager.getDefault().clearNonProjectCache();
                Project project4 = ProjectManager.getDefault().findProject(fileObject2);
                assert (project4 != null);
                RenameProjectPanel.open(project4, bl2);
            }
            throw exception;
        }
    }

    private static boolean doDelete(Project project, FileObject fileObject) throws IOException {
        block7: {
            if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
                return false;
            }
            if (fileObject.isFolder()) {
                boolean bl = true;
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    bl &= RenameProjectPanel.doDelete(project, fileObject2);
                }
                if (bl) {
                    DataFolder.findFolder((FileObject)fileObject).delete();
                }
                return bl;
            }
            assert (fileObject.isData());
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                dataObject.delete();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if (!fileObject.isValid()) break block7;
                fileObject.delete();
            }
        }
        return true;
    }

    private static void doCopy(Project project, FileObject fileObject, FileObject fileObject2) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return;
        }
        if (SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fileObject)) == 2) {
            return;
        }
        if (fileObject.isFolder()) {
            FileObject fileObject3 = fileObject2.createFolder(fileObject.getNameExt());
            for (FileObject fileObject4 : fileObject.getChildren()) {
                RenameProjectPanel.doCopy(project, fileObject4, fileObject3);
            }
        } else {
            assert (fileObject.isData());
            FileObject fileObject5 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
        }
    }

    private static void close(final Project project) {
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                LifecycleManager.getDefault().saveAll();
                OpenProjects.getDefault().close(new Project[]{project});
                return null;
            }
        });
    }

    private static void open(final Project project, final boolean bl) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                OpenProjects.getDefault().open(new Project[]{project}, false);
                if (bl) {
                    OpenProjects.getDefault().setMainProject(project);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNameExists
    implements Validator<String> {
        private final File parent;

        public FileNameExists(File file) {
            assert (file.isDirectory() && file.exists());
            this.parent = file;
        }

        public boolean validate(Problems problems, String string, String string2) {
            File file = new File(this.parent, string2);
            if (file.exists()) {
                problems.add("Folder with name '" + string2 + "' already exists.", Severity.FATAL);
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OptionalValidator
    implements Validator<String> {
        private final JCheckBox checkbox;
        private final Validator<String> delegate;

        public OptionalValidator(JCheckBox jCheckBox, Validator<String> validator) {
            this.checkbox = jCheckBox;
            this.delegate = validator;
        }

        public boolean validate(Problems problems, String string, String string2) {
            if (this.checkbox.isSelected()) {
                return this.delegate.validate(problems, string, (Object)string2);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DNameOperation
    implements ModelOperation<POMModel> {
        private final String name;

        DNameOperation(String string) {
            this.name = string;
        }

        public void performOperation(POMModel pOMModel) {
            pOMModel.getProject().setName(this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtIdOperation
    implements ModelOperation<POMModel> {
        private final String artifactId;

        ArtIdOperation(String string) {
            this.artifactId = string;
        }

        public void performOperation(POMModel pOMModel) {
            pOMModel.getProject().setArtifactId(this.artifactId);
        }
    }
}

