/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.MavenValidators;
import org.netbeans.modules.maven.newproject.ArchetypeWizardUtils;
import org.netbeans.modules.maven.newproject.EAWizardPanel;
import org.netbeans.modules.maven.newproject.ProjectInfo;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class EAVisualPanel
extends JPanel {
    private EAWizardPanel panel;
    private final ValidationGroup vg;
    private JCheckBox chkEjb;
    private JCheckBox chkWeb;
    private JComboBox cmbEEVersion;
    private JLabel lblEEVersion;
    private JLabel lblEar;
    private JTextField tfEar;
    private JTextField tfEjb;
    private JTextField tfWeb;

    public EAVisualPanel(EAWizardPanel eAWizardPanel) {
        this.panel = eAWizardPanel;
        this.initComponents();
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[0]);
        this.vg.add((JTextComponent)this.tfWeb, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{MavenValidators.createArtifactIdValidators(), Validators.REQUIRE_VALID_FILENAME})});
        this.vg.add((JTextComponent)this.tfEar, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{MavenValidators.createArtifactIdValidators(), Validators.REQUIRE_VALID_FILENAME})});
        this.vg.add((JTextComponent)this.tfEjb, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{MavenValidators.createArtifactIdValidators(), Validators.REQUIRE_VALID_FILENAME})});
        this.tfWeb.putClientProperty("_name", "Web ArtifactId");
        this.tfEar.putClientProperty("_name", "Ear ArtifactId");
        this.tfEjb.putClientProperty("_name", "Ejb ArtifactId");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"LBL_EESettings"));
    }

    public String getName() {
        return NbBundle.getMessage(EAWizardPanel.class, (String)"LBL_EESettings");
    }

    void readSettings(WizardDescriptor wizardDescriptor) {
        this.fillTextFields(wizardDescriptor);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EAVisualPanel.this.panel.getValidationGroup().addValidationGroup(EAVisualPanel.this.vg, true);
            }
        });
    }

    void storeSettings(WizardDescriptor wizardDescriptor) {
        String string;
        int n = Math.max(this.cmbEEVersion.getSelectedIndex(), 0);
        File file = (File)wizardDescriptor.getProperty("projdir");
        String string2 = this.tfEar.getText().trim();
        wizardDescriptor.putProperty("ear_projdir", (Object)new File(file, string2));
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
        projectInfo.artifactId = string2;
        projectInfo.version = (String)wizardDescriptor.getProperty("version");
        wizardDescriptor.putProperty("ear_versionInfo", (Object)projectInfo);
        wizardDescriptor.putProperty("ear_archetype", (Object)ArchetypeWizardUtils.EAR_ARCHS[n]);
        if (this.chkEjb.isSelected()) {
            string = this.tfEjb.getText().trim();
            wizardDescriptor.putProperty("ejb_projdir", (Object)new File(file, string));
            projectInfo = new ProjectInfo();
            projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
            projectInfo.artifactId = string;
            projectInfo.version = (String)wizardDescriptor.getProperty("version");
            wizardDescriptor.putProperty("ejb_versionInfo", (Object)projectInfo);
            wizardDescriptor.putProperty("ejb_archetype", (Object)ArchetypeWizardUtils.EJB_ARCHS[n]);
        } else {
            wizardDescriptor.putProperty("ejb_projdir", null);
            wizardDescriptor.putProperty("ejb_versionInfo", null);
            wizardDescriptor.putProperty("ejb_archetype", null);
        }
        if (this.chkWeb.isSelected()) {
            string = this.tfWeb.getText().trim();
            wizardDescriptor.putProperty("web_projdir", (Object)new File(file, string));
            projectInfo = new ProjectInfo();
            projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
            projectInfo.artifactId = string;
            projectInfo.version = (String)wizardDescriptor.getProperty("version");
            wizardDescriptor.putProperty("web_versionInfo", (Object)projectInfo);
            wizardDescriptor.putProperty("web_archetype", (Object)ArchetypeWizardUtils.WEB_APP_ARCHS[n]);
        } else {
            wizardDescriptor.putProperty("web_projdir", null);
            wizardDescriptor.putProperty("web_versionInfo", null);
            wizardDescriptor.putProperty("web_archetype", null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EAVisualPanel.this.panel.getValidationGroup().removeValidationGroup(EAVisualPanel.this.vg);
            }
        });
    }

    private void fillTextFields(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty("artifactId");
        this.tfEar.setText(string + "-ear");
        this.tfWeb.setText(string + "-web");
        this.tfEjb.setText(string + "-ejb");
    }

    private void initComponents() {
        this.cmbEEVersion = new JComboBox();
        this.lblEEVersion = new JLabel();
        this.chkEjb = new JCheckBox();
        this.chkWeb = new JCheckBox();
        this.lblEar = new JLabel();
        this.tfWeb = new JTextField();
        this.tfEjb = new JTextField();
        this.tfEar = new JTextField();
        this.cmbEEVersion.setModel(new DefaultComboBoxModel<String>(ArchetypeWizardUtils.EE_LEVELS));
        this.lblEEVersion.setLabelFor(this.cmbEEVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblEEVersion, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.lblEEVersion.text"));
        this.chkEjb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkEjb, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkEjb.text"));
        this.chkEjb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EAVisualPanel.this.chkEjbActionPerformed(actionEvent);
            }
        });
        this.chkWeb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkWeb, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkWeb.text"));
        this.chkWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EAVisualPanel.this.chkWebActionPerformed(actionEvent);
            }
        });
        this.lblEar.setLabelFor(this.tfEar);
        Mnemonics.setLocalizedText((JLabel)this.lblEar, (String)NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.lblEar.text"));
        this.tfWeb.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.text"));
        this.tfEjb.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.text"));
        this.tfEar.setText(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEar.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblEEVersion).addPreferredGap(0).add((Component)this.cmbEEVersion, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkWeb).add((Component)this.chkEjb).add((Component)this.lblEar)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tfEjb, -1, 201, Short.MAX_VALUE).add((Component)this.tfWeb, -1, 201, Short.MAX_VALUE).add((Component)this.tfEar, -1, 201, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblEEVersion).add((Component)this.cmbEEVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tfEjb, -2, -1, -2).add((Component)this.chkEjb)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.chkWeb).add((Component)this.tfWeb, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tfEar, -2, -1, -2).add((Component)this.lblEar)).addContainerGap(174, Short.MAX_VALUE)));
        this.cmbEEVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.cmbEEVersion.AccessibleContext.accessibleDescription"));
        this.chkEjb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkEjb.AccessibleContext.accessibleDescription"));
        this.chkWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.chkWeb.AccessibleContext.accessibleDescription"));
        this.tfWeb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.AccessibleContext.accessibleName"));
        this.tfWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfWeb.AccessibleContext.accessibleDescription"));
        this.tfEjb.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.AccessibleContext.accessibleName"));
        this.tfEjb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEjb.AccessibleContext.accessibleDescription"));
        this.tfEar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EAVisualPanel.class, (String)"EAVisualPanel.tfEar.AccessibleContext.accessibleDescription"));
    }

    private void chkEjbActionPerformed(ActionEvent actionEvent) {
        this.tfEjb.setEnabled(this.chkEjb.isSelected());
        this.vg.validateAll();
    }

    private void chkWebActionPerformed(ActionEvent actionEvent) {
        this.tfWeb.setEnabled(this.chkWeb.isSelected());
        this.vg.validateAll();
    }
}

