/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReplaceTokenProvider
implements ReplaceTokenProvider,
ActionConvertor {
    private static final String ARTIFACTID = "artifactId";
    private static final String CLASSPATHSCOPE = "classPathScope";
    private static final String GROUPID = "groupId";
    private final Project project;
    private static final String CLASSNAME = "className";
    private static final String CLASSNAME_EXT = "classNameWithExtension";
    private static final String PACK_CLASSNAME = "packageClassName";
    public static final String METHOD_NAME = "nb.single.run.methodName";
    private static final String VARIABLE_PREFIX = "var.";

    public DefaultReplaceTokenProvider(Project project) {
        this.project = project;
    }

    protected static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        FileObject fileObject;
        Object object2;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Object object2 : lookup.lookup(new Lookup.Template(DataObject.class)).allInstances()) {
            fileObject = object2.getPrimaryFile();
            arrayList.add(fileObject);
        }
        object2 = lookup.lookupAll(SingleMethod.class);
        if (object2.size() == 1) {
            fileObject = (SingleMethod)object2.iterator().next();
            arrayList.add(fileObject.getFile());
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    @Override
    public Map<String, String> createReplacements(String string, Lookup lookup) {
        Object object;
        Collection collection;
        FileObject[] fileObjectArray = DefaultReplaceTokenProvider.extractFileObjectsfromLookup(lookup);
        Tuple tuple = new Tuple(null, null);
        FileObject fileObject = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = DefaultReplaceTokenProvider.readVariables();
        hashMap.putAll(map);
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        hashMap.put(GROUPID, nbMavenProject.getMavenProject().getGroupId());
        hashMap.put(ARTIFACTID, nbMavenProject.getMavenProject().getArtifactId());
        if (fileObjectArray.length > 0) {
            fileObject = fileObjectArray[0];
            collection = (Sources)this.project.getLookup().lookup(Sources.class);
            if ("text/x-java".equals(fileObject.getMIMEType())) {
                tuple = DefaultReplaceTokenProvider.checkSG(collection.getSourceGroups("java"), hashMap, fileObject);
            }
            if ("text/x-groovy".equals(fileObject.getMIMEType())) {
                tuple = DefaultReplaceTokenProvider.checkSG(collection.getSourceGroups("groovy"), hashMap, fileObject);
            }
            if ("text/x-scala".equals(fileObject.getMIMEType())) {
                tuple = DefaultReplaceTokenProvider.checkSG(collection.getSourceGroups("scala"), hashMap, fileObject);
            }
            if (tuple.relPath == null) {
                hashMap.put(CLASSNAME_EXT, "");
                hashMap.put(CLASSNAME, "");
                hashMap.put(PACK_CLASSNAME, "");
            }
        }
        if ((collection = lookup.lookupAll(SingleMethod.class)).size() == 1) {
            object = (SingleMethod)collection.iterator().next();
            hashMap.put(METHOD_NAME, object.getMethodName());
        }
        if (tuple.group != null && ("2TestSourceRoot".equals(tuple.group.getName()) || "82GroovyTestSourceRoot".equals(tuple.group.getName()) || "92ScalaTestSourceRoot".equals(tuple.group.getName()))) {
            hashMap.put(CLASSPATHSCOPE, "test");
        } else {
            hashMap.put(CLASSPATHSCOPE, "runtime");
        }
        if (tuple.group != null && "1SourceRoot".equals(tuple.group.getName()) && ("test.single".equals(string) || "debug.test.single".equals(string)) && (object = hashMap.get(CLASSNAME_EXT)) != null && ((String)object).endsWith(".java")) {
            hashMap.put(CLASSNAME_EXT, ((String)object).replace(".java", "Test.java"));
            hashMap.put(CLASSNAME, hashMap.get(CLASSNAME) + "Test");
            hashMap.put(PACK_CLASSNAME, hashMap.get(PACK_CLASSNAME) + "Test");
        }
        return hashMap;
    }

    private static Tuple checkSG(SourceGroup[] sourceGroupArray, HashMap<String, String> hashMap, FileObject fileObject) {
        String string = null;
        SourceGroup sourceGroup = null;
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
            if (string == null) continue;
            sourceGroup = sourceGroupArray[i];
            hashMap.put(CLASSNAME_EXT, fileObject.getNameExt());
            hashMap.put(CLASSNAME, fileObject.getName());
            String string2 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject.getParent());
            if (string2 != null) {
                hashMap.put(PACK_CLASSNAME, (string2 + (string2.length() > 0 ? "." : "") + fileObject.getName()).replace('/', '.'));
                break;
            }
            hashMap.put(PACK_CLASSNAME, fileObject.getName());
            break;
        }
        return new Tuple(string, sourceGroup);
    }

    public static Map<String, String> readVariables() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
        for (Map.Entry entry : editableProperties.entrySet()) {
            if (!((String)entry.getKey()).startsWith(VARIABLE_PREFIX)) continue;
            hashMap.put(((String)entry.getKey()).substring(VARIABLE_PREFIX.length()), FileUtil.normalizeFile((File)new File((String)entry.getValue())).getAbsolutePath());
        }
        return hashMap;
    }

    @Override
    public String convert(String string, Lookup lookup) {
        FileObject[] fileObjectArray;
        if ("debug.single.method".equals(string)) {
            return "debug.test.single";
        }
        if ("run.single.method".equals(string)) {
            return "test.single";
        }
        if (("run.single".equals(string) || "debug.single".equals(string)) && (fileObjectArray = DefaultReplaceTokenProvider.extractFileObjectsfromLookup(lookup)).length > 0) {
            FileObject fileObject = fileObjectArray[0];
            if ("text/x-java".equals(fileObject.getMIMEType())) {
                Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    String string2 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
                    if (string2 == null || SourceUtils.isScanInProgress() || SourceUtils.getMainClasses((FileObject)fileObject).isEmpty()) continue;
                    return string + ".main";
                }
            }
            if ("text/x-groovy".equals(fileObject.getMIMEType())) {
                return string + ".main";
            }
            if ("text/x-scala".equals(fileObject.getMIMEType())) {
                return string + ".main";
            }
        }
        return null;
    }

    private static class Tuple {
        final String relPath;
        final SourceGroup group;

        public Tuple(String string, SourceGroup sourceGroup) {
            this.relPath = string;
            this.group = sourceGroup;
        }
    }
}

