/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.profile.Profile;
import org.netbeans.modules.maven.model.profile.Properties;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CompilePanel
extends JPanel
implements WindowFocusListener {
    private static final String[] LABELS = new String[]{NbBundle.getMessage(CompilePanel.class, (String)"COS_ALL"), NbBundle.getMessage(CompilePanel.class, (String)"COS_APP"), NbBundle.getMessage(CompilePanel.class, (String)"COS_TESTS"), NbBundle.getMessage(CompilePanel.class, (String)"COS_NONE")};
    private static final String[] VALUES = new String[]{"all", "app", "test", "none"};
    private static final String PARAM_DEBUG = "debug";
    private static final String PARAM_DEPRECATION = "showDeprecation";
    private static final int COS_ALL = 0;
    private static final int COS_APP = 1;
    private static final int COS_TESTS = 2;
    private static final int COS_NONE = 3;
    private ComboBoxUpdater<String> listener;
    private final ModelHandle handle;
    private final Project project;
    private CheckBoxUpdater debugUpdater;
    private CheckBoxUpdater deprecateUpdater;
    private static boolean warningShown = false;
    private Color origComPlatformFore;
    private JButton btnMngPlatform;
    private JButton btnSetupHome;
    private JCheckBox cbDebug;
    private JCheckBox cbDeprecate;
    private JComboBox comCompileOnSave;
    private JComboBox comJavaPlatform;
    private JLabel lblCompileOnSave;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJavaPlatform;
    private JLabel lblWarnPlatform;
    private static final String CONFIGURATION_EL = "configuration";

    public CompilePanel(ModelHandle modelHandle, Project project) {
        this.initComponents();
        this.handle = modelHandle;
        this.project = project;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(LABELS);
        this.comCompileOnSave.setModel(defaultComboBoxModel);
        this.comJavaPlatform.setModel(new PlatformsModel());
        this.comJavaPlatform.setRenderer(new PlatformsRenderer());
        this.origComPlatformFore = this.comJavaPlatform.getForeground();
        this.initValues();
    }

    private String valueToLabel(String string) {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].equalsIgnoreCase(string)) continue;
            return LABELS[i];
        }
        return LABELS[2];
    }

    private String labelToValue(String string) {
        for (int i = 0; i < LABELS.length; ++i) {
            if (!LABELS[i].equalsIgnoreCase(string)) continue;
            return VALUES[i];
        }
        return VALUES[2];
    }

    private void initValues() {
        this.listener = new ComboBoxUpdater<String>(this.comCompileOnSave, this.lblCompileOnSave){

            @Override
            public String getDefaultValue() {
                return LABELS[2];
            }

            @Override
            public String getValue() {
                Properties properties;
                Profile profile = CompilePanel.this.handle.getNetbeansPrivateProfile(false);
                String string = null;
                if (profile != null && (properties = profile.getProperties()) != null && properties.getProperty("netbeans.compile.on.save") != null) {
                    string = profile.getProperties().getProperty("netbeans.compile.on.save");
                }
                if (string == null && (properties = CompilePanel.this.handle.getPOMModel().getProject().getProperties()) != null) {
                    string = properties.getProperty("netbeans.compile.on.save");
                }
                if (string == null) {
                    string = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
                }
                if (string != null) {
                    return CompilePanel.this.valueToLabel(string);
                }
                return LABELS[2];
            }

            @Override
            public void setValue(String string) {
                Properties properties;
                Profile profile;
                String string2 = CompilePanel.this.labelToValue(string);
                if (string2 != null && string2.equals(VALUES[2])) {
                    string2 = null;
                }
                if ((VALUES[0].equals(string2) || VALUES[1].equals(string2)) && !warningShown && DontShowAgainSettings.getDefault().showWarningAboutApplicationCoS()) {
                    WarnPanel warnPanel = new WarnPanel(NbBundle.getMessage(CompilePanel.class, (String)"HINT_ApplicationCoS"));
                    profile = new NotifyDescriptor.Message((Object)warnPanel, -1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)profile);
                    if (warnPanel.disabledWarning()) {
                        DontShowAgainSettings.getDefault().dontshowWarningAboutApplicationCoSAnymore();
                    }
                    warningShown = true;
                }
                boolean bl = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true) != null;
                profile = CompilePanel.this.handle.getNetbeansPrivateProfile(false);
                if (profile != null && (properties = profile.getProperties()) != null && properties.getProperty("netbeans.compile.on.save") != null) {
                    properties.setProperty("netbeans.compile.on.save", string2 == null ? null : string2);
                    if (bl) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", null, true);
                    }
                    CompilePanel.this.handle.markAsModified(CompilePanel.this.handle.getProfileModel());
                    return;
                }
                if (CompilePanel.this.handle.getProject().getProperties().containsKey("netbeans.compile.on.save")) {
                    properties = CompilePanel.this.handle.getPOMModel().getProject().getProperties();
                    if (properties == null) {
                        properties = CompilePanel.this.handle.getPOMModel().getFactory().createProperties();
                        CompilePanel.this.handle.getPOMModel().getProject().setProperties((org.netbeans.modules.maven.model.pom.Properties)properties);
                    }
                    properties.setProperty("netbeans.compile.on.save", string2 == null ? null : string2);
                    CompilePanel.this.handle.markAsModified(CompilePanel.this.handle.getPOMModel());
                    if (bl) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", null, true);
                    }
                    return;
                }
                CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", string2 == null ? null : string2, true);
            }
        };
        this.debugUpdater = new CheckBoxUpdater(this.cbDebug){

            public Boolean getValue() {
                String string = CompilePanel.getCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEBUG);
                if (string != null) {
                    return Boolean.valueOf(string);
                }
                return null;
            }

            public void setValue(Boolean bl) {
                String string = bl == null ? "true" : bl.toString();
                CompilePanel.checkCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEBUG, string);
            }

            public boolean getDefaultValue() {
                return true;
            }
        };
        this.deprecateUpdater = new CheckBoxUpdater(this.cbDeprecate){

            public Boolean getValue() {
                String string = CompilePanel.getCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEPRECATION);
                if (string != null) {
                    return Boolean.valueOf(string);
                }
                return null;
            }

            public void setValue(Boolean bl) {
                String string = bl == null ? "false" : bl.toString();
                CompilePanel.checkCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEPRECATION, string);
            }

            public boolean getDefaultValue() {
                return false;
            }
        };
        new ComboBoxUpdater<JavaPlatform>(this.comJavaPlatform, this.lblJavaPlatform){

            @Override
            public JavaPlatform getValue() {
                Properties properties;
                Profile profile = CompilePanel.this.handle.getNetbeansPrivateProfile(false);
                String string = null;
                if (profile != null && (properties = profile.getProperties()) != null && properties.getProperty("netbeans.hint.jdkPlatform") != null) {
                    string = properties.getProperty("netbeans.hint.jdkPlatform");
                }
                if (string == null && (properties = CompilePanel.this.handle.getPOMModel().getProject().getProperties()) != null) {
                    string = properties.getProperty("netbeans.hint.jdkPlatform");
                }
                if (string == null) {
                    string = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true);
                }
                if (string != null) {
                    return BootClassPathImpl.getActivePlatform(string);
                }
                return CompilePanel.this.getSelPlatform();
            }

            @Override
            public JavaPlatform getDefaultValue() {
                return CompilePanel.this.getSelPlatform();
            }

            @Override
            public void setValue(JavaPlatform javaPlatform) {
                Properties properties;
                JavaPlatform javaPlatform2 = javaPlatform == null ? JavaPlatformManager.getDefault().getDefaultPlatform() : javaPlatform;
                String string = (String)javaPlatform2.getProperties().get("platform.ant.name");
                if (JavaPlatformManager.getDefault().getDefaultPlatform().equals(javaPlatform2)) {
                    string = null;
                }
                boolean bl = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true) != null;
                Profile profile = CompilePanel.this.handle.getNetbeansPrivateProfile(false);
                if (profile != null && (properties = profile.getProperties()) != null && properties.getProperty("netbeans.hint.jdkPlatform") != null) {
                    properties.setProperty("netbeans.hint.jdkPlatform", string);
                    if (bl) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", null, true);
                    }
                    CompilePanel.this.handle.markAsModified(CompilePanel.this.handle.getProfileModel());
                    return;
                }
                if (CompilePanel.this.handle.getProject().getProperties().containsKey("netbeans.hint.jdkPlatform")) {
                    properties = CompilePanel.this.handle.getPOMModel().getProject().getProperties();
                    if (properties == null) {
                        properties = CompilePanel.this.handle.getPOMModel().getFactory().createProperties();
                        CompilePanel.this.handle.getPOMModel().getProject().setProperties((org.netbeans.modules.maven.model.pom.Properties)properties);
                    }
                    properties.setProperty("netbeans.hint.jdkPlatform", string);
                    CompilePanel.this.handle.markAsModified(CompilePanel.this.handle.getPOMModel());
                    if (bl) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", null, true);
                    }
                    return;
                }
                CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", string, true);
            }
        };
        this.checkExternalMaven();
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.getWindowAncestor(this).addWindowFocusListener(this);
    }

    private JavaPlatform getSelPlatform() {
        String string = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        return BootClassPathImpl.getActivePlatform(string);
    }

    private boolean isExternalMaven() {
        AuxiliaryProperties auxiliaryProperties = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        String string = auxiliaryProperties.get("netbeans.hint.useExternalMaven", true);
        boolean bl = "false".equalsIgnoreCase(string);
        return !bl && MavenSettings.canFindExternalMaven();
    }

    private void checkExternalMaven() {
        if (this.isExternalMaven()) {
            this.lblWarnPlatform.setVisible(false);
            this.btnSetupHome.setVisible(false);
            this.comJavaPlatform.setEnabled(true);
        } else {
            this.comJavaPlatform.setEnabled(false);
            this.lblWarnPlatform.setVisible(true);
            this.btnSetupHome.setVisible(true);
        }
    }

    private void initComponents() {
        this.lblCompileOnSave = new JLabel();
        this.comCompileOnSave = new JComboBox();
        this.lblHint1 = new JLabel();
        this.lblHint2 = new JLabel();
        this.cbDebug = new JCheckBox();
        this.cbDeprecate = new JCheckBox();
        this.lblJavaPlatform = new JLabel();
        this.comJavaPlatform = new JComboBox();
        this.btnMngPlatform = new JButton();
        this.lblWarnPlatform = new JLabel();
        this.btnSetupHome = new JButton();
        this.setPreferredSize(new Dimension(576, 303));
        this.lblCompileOnSave.setLabelFor(this.comCompileOnSave);
        Mnemonics.setLocalizedText((JLabel)this.lblCompileOnSave, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblCompileOnSave.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDebug.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDeprecate, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDeprecate.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblJavaPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblJavaPlatform.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMngPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.text"));
        this.btnMngPlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompilePanel.this.btnMngPlatformActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblWarnPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblWarnPlatform.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetupHome, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnSetupHome.text"));
        this.btnSetupHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompilePanel.this.btnSetupHomeActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblHint1, -1, 566, Short.MAX_VALUE).add((Component)this.lblHint2, -1, 566, Short.MAX_VALUE).add((Component)this.cbDebug).add((Component)this.cbDeprecate).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblCompileOnSave).add((Component)this.lblJavaPlatform)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.comJavaPlatform, 0, 302, Short.MAX_VALUE).add((Component)this.comCompileOnSave, 0, 302, Short.MAX_VALUE)).add(16, 16, 16).add((Component)this.btnMngPlatform)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblWarnPlatform, -1, 389, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnSetupHome))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJavaPlatform).add((Component)this.comJavaPlatform, -2, -1, -2).add((Component)this.btnMngPlatform)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblCompileOnSave).add((Component)this.comCompileOnSave, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblHint1).addPreferredGap(0).add((Component)this.lblHint2).add(18, 18, 18).add((Component)this.cbDebug).addPreferredGap(0).add((Component)this.cbDeprecate).addPreferredGap(0, 109, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.btnSetupHome).add((Component)this.lblWarnPlatform)).addContainerGap()));
        this.btnMngPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.AccessibleContext.accessibleDescription"));
        this.btnSetupHome.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnSetupHome.AccessibleContext.accessibleDescription"));
    }

    private void btnMngPlatformActionPerformed(ActionEvent actionEvent) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelPlatform());
    }

    private void btnSetupHomeActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("Advanced/Maven");
    }

    public static void checkCompilerParam(ModelHandle modelHandle, String string, String string2) {
        Plugin plugin;
        String string3 = PluginPropertyUtils.getPluginProperty(modelHandle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", string, "compile");
        if (string3 != null && string3.contains(string2)) {
            return;
        }
        POMModel pOMModel = modelHandle.getPOMModel();
        Plugin plugin2 = null;
        Build build = pOMModel.getProject().getBuild();
        if (build != null) {
            plugin2 = build.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
        } else {
            build = pOMModel.getFactory().createBuild();
            pOMModel.getProject().setBuild(build);
        }
        if (plugin2 != null) {
            plugin = plugin2;
        } else {
            plugin = pOMModel.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
            build.addPlugin(plugin);
        }
        Configuration configuration = plugin.getConfiguration();
        if (configuration == null) {
            configuration = pOMModel.getFactory().createConfiguration();
            plugin.setConfiguration(configuration);
        }
        configuration.setSimpleParameter(string, string2);
        modelHandle.markAsModified(modelHandle.getPOMModel());
    }

    public static String getCompilerParam(ModelHandle modelHandle, String string) {
        String string2;
        Configuration configuration;
        Object object;
        Build build = modelHandle.getPOMModel().getProject().getBuild();
        if (build != null && (object = build.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin")) != null && (configuration = object.getConfiguration()) != null && (string2 = configuration.getSimpleParameter(string)) != null) {
            return string2;
        }
        object = PluginPropertyUtils.getPluginProperty(modelHandle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", string, "compile");
        if (object != null) {
            return object;
        }
        return null;
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        this.checkExternalMaven();
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private class PlatformsRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            JavaPlatform javaPlatform = (JavaPlatform)object;
            if (javaPlatform != null) {
                this.setText(javaPlatform.getDisplayName());
            } else {
                this.setText("");
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(CompilePanel.this.isExternalMaven() ? jList.getSelectionForeground() : SystemColor.textInactiveText);
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(CompilePanel.this.isExternalMaven() ? jList.getForeground() : SystemColor.textInactiveText);
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private static class PlatformsModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private JavaPlatform[] data;
        private Object sel;

        public PlatformsModel() {
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            this.data = javaPlatformManager.getInstalledPlatforms();
            javaPlatformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)javaPlatformManager));
            this.sel = javaPlatformManager.getDefaultPlatform();
        }

        public int getSize() {
            return this.data.length;
        }

        public Object getElementAt(int n) {
            return this.data[n];
        }

        public void setSelectedItem(Object object) {
            this.sel = object;
            this.fireContentsChanged(this, 0, this.data.length);
        }

        public Object getSelectedItem() {
            return this.sel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            this.data = javaPlatformManager.getInstalledPlatforms();
            this.fireContentsChanged(this, 0, this.data.length);
        }
    }
}

