/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class AbstractCheckboxTag
extends AbstractHtmlInputElementTag {
    protected void renderSingleValue(Object resolvedValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.getDisplayString(resolvedValue, this.getPropertyEditor()));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected void renderFromCollection(Object resolvedValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", this.getDisplayString(resolvedValue, this.getPropertyEditor()));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected void renderFromBoolean(Boolean boundValue, TagWriter tagWriter) throws JspException {
        tagWriter.writeAttribute("value", "true");
        if (boundValue.booleanValue()) {
            tagWriter.writeAttribute("checked", "checked");
        }
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }

    protected abstract int writeTagContent(TagWriter var1) throws JspException;
}

