/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.spi.cos.AdditionalDestination;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnSave
extends FileChangeAdapter
implements PropertyChangeListener,
AdditionalDestination,
J2eeModuleProvider.DeployOnSaveSupport {
    private FileObject docBase = null;
    private Project project;
    private WebModuleProviderImpl provider;
    boolean active = false;
    private NbMavenProject mavenproject;
    private final List<ArtifactListener> listeners = new ArrayList<ArtifactListener>();
    private static final String NB_COS = ".netbeans_automatic_build";

    CopyOnSave(Project project, WebModuleProviderImpl webModuleProviderImpl) {
        this.project = project;
        this.provider = webModuleProviderImpl;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySrcToDest(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (fileObject2 != null && !fileObject.isFolder()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            FileLock fileLock = null;
            try {
                inputStream = fileObject.getInputStream();
                fileLock = fileObject2.lock();
                outputStream = fileObject2.getOutputStream(fileLock);
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    private WebModule getWebModule() {
        return this.provider.findWebModule(this.project.getProjectDirectory());
    }

    private J2eeModule getJ2eeModule() {
        return this.provider.getJ2eeModule();
    }

    private boolean isInPlace() throws IOException {
        FileObject fileObject = this.getJ2eeModule().getContentDirectory();
        return fileObject != null && fileObject.equals(this.getWebModule().getDocumentBase());
    }

    public void initialize() throws FileStateInvalidException {
        if (!this.active) {
            this.smallinitialize();
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
            this.active = true;
        }
    }

    public void cleanup() throws FileStateInvalidException {
        if (this.active) {
            this.smallcleanup();
            NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
            this.active = false;
        }
    }

    private void smallinitialize() throws FileStateInvalidException {
        this.docBase = this.getWebModule().getDocumentBase();
        if (this.docBase != null) {
            this.docBase.getFileSystem().addFileChangeListener((FileChangeListener)this);
        }
    }

    private void smallcleanup() throws FileStateInvalidException {
        if (this.docBase != null) {
            this.docBase.getFileSystem().removeFileChangeListener((FileChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
            try {
                if (this.active) {
                    this.smallcleanup();
                    this.smallinitialize();
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
    }

    public void fileChanged(final FileEvent fileEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyOnSave.this.fileChanged(fileEvent);
                }
            });
            return;
        }
        try {
            if (!this.isInPlace()) {
                this.handleCopyFileToDestDir(fileEvent.getFile());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileDataCreated(final FileEvent fileEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyOnSave.this.fileDataCreated(fileEvent);
                }
            });
            return;
        }
        try {
            if (!this.isInPlace()) {
                this.handleCopyFileToDestDir(fileEvent.getFile());
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileRenamed(final FileRenameEvent fileRenameEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyOnSave.this.fileRenamed(fileRenameEvent);
                }
            });
            return;
        }
        try {
            if (this.isInPlace()) {
                return;
            }
            FileObject fileObject = fileRenameEvent.getFile();
            FileObject fileObject2 = this.findWebDocRoot(fileObject);
            if (fileObject2 != null) {
                this.handleCopyFileToDestDir(fileObject);
                FileObject fileObject3 = fileObject.getParent();
                String string = FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3) ? FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()) + "/" + fileRenameEvent.getName() + "." + fileRenameEvent.getExt() : fileRenameEvent.getName() + "." + fileRenameEvent.getExt();
                if (!this.isSynchronizationAppropriate(string)) {
                    return;
                }
                this.handleDeleteFileInDestDir(fileObject, string);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileDeleted(final FileEvent fileEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyOnSave.this.fileDeleted(fileEvent);
                }
            });
            return;
        }
        try {
            if (this.isInPlace()) {
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            this.handleDeleteFileInDestDir(fileObject, null);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private boolean isSynchronizationAppropriate(String string) {
        if (string.startsWith("WEB-INF/classes")) {
            return false;
        }
        if (string.startsWith("WEB-INF/src")) {
            return false;
        }
        return !string.startsWith("WEB-INF/lib");
    }

    private void handleDeleteFileInDestDir(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = this.findWebDocRoot(fileObject);
        if (fileObject2 != null) {
            FileObject fileObject3;
            String string2 = string = string != null ? string : FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (!this.isSynchronizationAppropriate(string)) {
                return;
            }
            FileObject fileObject4 = this.getJ2eeModule().getContentDirectory();
            if (fileObject4 != null && (fileObject3 = fileObject4.getFileObject(string)) != null) {
                File file = FileUtil.toFile((FileObject)fileObject3);
                fileObject3.delete();
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)file)));
            }
        }
    }

    private void handleCopyFileToDestDir(FileObject fileObject) throws IOException {
        FileObject fileObject2;
        if (!fileObject.isVirtual() && (fileObject2 = this.findWebDocRoot(fileObject)) != null) {
            String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (!this.isSynchronizationAppropriate(string)) {
                return;
            }
            FileObject fileObject3 = this.getJ2eeModule().getContentDirectory();
            if (fileObject3 != null) {
                if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject2)) {
                    return;
                }
                FileObject fileObject4 = this.ensureDestinationFileExists(fileObject3, string, fileObject.isFolder());
                File file = FileUtil.toFile((FileObject)fileObject4);
                this.copySrcToDest(fileObject, fileObject4);
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)file)));
            }
        }
    }

    private FileObject findWebDocRoot(FileObject fileObject) {
        FileObject fileObject2 = this.getWebModule().getDocumentBase();
        if (fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return fileObject2;
        }
        return null;
    }

    private FileObject ensureDestinationFileExists(FileObject fileObject, String string, boolean bl) throws IOException {
        FileObject fileObject2 = fileObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            FileObject fileObject3 = fileObject2.getFileObject(string2);
            if (fileObject3 == null) {
                fileObject3 = bl || stringTokenizer.hasMoreTokens() ? FileUtil.createFolder((FileObject)fileObject2, (String)string2) : FileUtil.createData((FileObject)fileObject2, (String)string2);
            }
            fileObject2 = fileObject3;
        }
        return fileObject2;
    }

    public void copy(FileObject fileObject, String string) {
        try {
            FileObject fileObject2 = this.getJ2eeModule().getContentDirectory();
            if (fileObject2 != null) {
                FileObject fileObject3 = this.ensureDestinationFileExists(fileObject2, "WEB-INF/classes/" + string, fileObject.isFolder());
                File file = FileUtil.toFile((FileObject)fileObject3);
                this.copySrcToDest(fileObject, fileObject3);
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)file)));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void delete(FileObject fileObject, String string) {
        try {
            FileObject fileObject2;
            FileObject fileObject3;
            FileObject fileObject4 = this.getJ2eeModule().getContentDirectory();
            if (fileObject4 != null && (fileObject3 = fileObject4.getFileObject("WEB-INF/classes")) != null && (fileObject2 = fileObject3.getFileObject(string)) != null) {
                File file = FileUtil.toFile((FileObject)fileObject2);
                fileObject2.delete();
                this.fireArtifactChange(Collections.singleton(ArtifactListener.Artifact.forFile((File)file)));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifactListener(ArtifactListener artifactListener) {
        List<ArtifactListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(artifactListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArtifactListener(ArtifactListener artifactListener) {
        List<ArtifactListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(artifactListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireArtifactChange(Iterable<ArtifactListener.Artifact> iterable) {
        List<ArtifactListener> list = this.listeners;
        synchronized (list) {
            for (ArtifactListener artifactListener : this.listeners) {
                artifactListener.artifactsUpdated(iterable);
            }
        }
    }

    public boolean containsIdeArtifacts() {
        MavenProject mavenProject = this.mavenproject.getMavenProject();
        if (mavenProject.getBuild() != null) {
            File file = new File(mavenProject.getBuild().getOutputDirectory());
            file = FileUtil.normalizeFile((File)file);
            File file2 = new File(file, NB_COS);
            return file2.exists();
        }
        return false;
    }
}

