/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.UnicodeClasses;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.AttlistDecl;
import org.netbeans.tax.spec.Attribute;
import org.netbeans.tax.spec.CDATASection;
import org.netbeans.tax.spec.CharacterReference;
import org.netbeans.tax.spec.Comment;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.ElementDecl;
import org.netbeans.tax.spec.EntityDecl;
import org.netbeans.tax.spec.GeneralEntityReference;
import org.netbeans.tax.spec.NotationDecl;
import org.netbeans.tax.spec.ParameterEntityReference;
import org.netbeans.tax.spec.ProcessingInstruction;
import org.netbeans.tax.spec.Text;

public final class TreeUtilities {
    private static Constraints constraints = new Constraints();

    public static final void checkAttributeName(TreeName treeName) throws InvalidArgumentException {
        constraints.checkAttributeName(treeName);
    }

    public static final boolean isValidAttributeName(TreeName treeName) {
        return constraints.isValidAttributeName(treeName);
    }

    public static final void checkElementTagName(TreeName treeName) throws InvalidArgumentException {
        constraints.checkElementTagName(treeName);
    }

    public static final boolean isValidElementTagName(TreeName treeName) {
        return constraints.isValidElementTagName(treeName);
    }

    public static final void checkNotationDeclSystemId(String string) throws InvalidArgumentException {
        constraints.checkNotationDeclSystemId(string);
    }

    public static final boolean isValidNotationDeclSystemId(String string) {
        return constraints.isValidNotationDeclSystemId(string);
    }

    public static final void checkDocumentEncoding(String string) throws InvalidArgumentException {
        constraints.checkDocumentEncoding(string);
    }

    public static final boolean isValidDocumentEncoding(String string) {
        return constraints.isValidDocumentEncoding(string);
    }

    public static final void checkDTDEncoding(String string) throws InvalidArgumentException {
        constraints.checkDTDEncoding(string);
    }

    public static final boolean isValidDTDEncoding(String string) {
        return constraints.isValidDTDEncoding(string);
    }

    public static final void checkCharacterReferenceName(String string) throws InvalidArgumentException {
        constraints.checkCharacterReferenceName(string);
    }

    public static final boolean isValidCharacterReferenceName(String string) {
        return constraints.isValidCharacterReferenceName(string);
    }

    public static final void checkEntityDeclInternalText(String string) throws InvalidArgumentException {
        constraints.checkEntityDeclInternalText(string);
    }

    public static final boolean isValidEntityDeclInternalText(String string) {
        return constraints.isValidEntityDeclInternalText(string);
    }

    public static final void checkAttlistDeclElementName(String string) throws InvalidArgumentException {
        constraints.checkAttlistDeclElementName(string);
    }

    public static final boolean isValidAttlistDeclElementName(String string) {
        return constraints.isValidAttlistDeclElementName(string);
    }

    public static final void checkDTDVersion(String string) throws InvalidArgumentException {
        constraints.checkDTDVersion(string);
    }

    public static final boolean isValidDTDVersion(String string) {
        return constraints.isValidDTDVersion(string);
    }

    public static final void checkDocumentTypeSystemId(String string) throws InvalidArgumentException {
        constraints.checkDocumentTypeSystemId(string);
    }

    public static final boolean isValidDocumentTypeSystemId(String string) {
        return constraints.isValidDocumentTypeSystemId(string);
    }

    public static final void checkDocumentTypeElementName(String string) throws InvalidArgumentException {
        constraints.checkDocumentTypeElementName(string);
    }

    public static final boolean isValidDocumentTypeElementName(String string) {
        return constraints.isValidDocumentTypeElementName(string);
    }

    public static final void checkDocumentStandalone(String string) throws InvalidArgumentException {
        constraints.checkDocumentStandalone(string);
    }

    public static final boolean isValidDocumentStandalone(String string) {
        return constraints.isValidDocumentStandalone(string);
    }

    public static final void checkEntityDeclName(String string) throws InvalidArgumentException {
        constraints.checkEntityDeclName(string);
    }

    public static final boolean isValidEntityDeclName(String string) {
        return constraints.isValidEntityDeclName(string);
    }

    public static final void checkAttlistDeclAttributeEnumeratedType(String[] stringArray) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeEnumeratedType(stringArray);
    }

    public static final boolean isValidAttlistDeclAttributeEnumeratedType(String[] stringArray) {
        return constraints.isValidAttlistDeclAttributeEnumeratedType(stringArray);
    }

    public static final void checkProcessingInstructionData(String string) throws InvalidArgumentException {
        constraints.checkProcessingInstructionData(string);
    }

    public static final boolean isValidProcessingInstructionData(String string) {
        return constraints.isValidProcessingInstructionData(string);
    }

    public static final void checkEntityDeclNotationName(String string) throws InvalidArgumentException {
        constraints.checkEntityDeclNotationName(string);
    }

    public static final boolean isValidEntityDeclNotationName(String string) {
        return constraints.isValidEntityDeclNotationName(string);
    }

    public static final void checkElementDeclName(String string) throws InvalidArgumentException {
        constraints.checkElementDeclName(string);
    }

    public static final boolean isValidElementDeclName(String string) {
        return constraints.isValidElementDeclName(string);
    }

    public static final void checkGeneralEntityReferenceName(String string) throws InvalidArgumentException {
        constraints.checkGeneralEntityReferenceName(string);
    }

    public static final boolean isValidGeneralEntityReferenceName(String string) {
        return constraints.isValidGeneralEntityReferenceName(string);
    }

    public static final void checkEntityDeclSystemId(String string) throws InvalidArgumentException {
        constraints.checkEntityDeclSystemId(string);
    }

    public static final boolean isValidEntityDeclSystemId(String string) {
        return constraints.isValidEntityDeclSystemId(string);
    }

    public static final void checkProcessingInstructionTarget(String string) throws InvalidArgumentException {
        constraints.checkProcessingInstructionTarget(string);
    }

    public static final boolean isValidProcessingInstructionTarget(String string) {
        return constraints.isValidProcessingInstructionTarget(string);
    }

    public static final void checkEntityDeclPublicId(String string) throws InvalidArgumentException {
        constraints.checkEntityDeclPublicId(string);
    }

    public static final boolean isValidEntityDeclPublicId(String string) {
        return constraints.isValidEntityDeclPublicId(string);
    }

    public static final void checkAttlistDeclAttributeDefaultValue(String string) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeDefaultValue(string);
    }

    public static final boolean isValidAttlistDeclAttributeDefaultValue(String string) {
        return constraints.isValidAttlistDeclAttributeDefaultValue(string);
    }

    public static final void checkDocumentFragmentVersion(String string) throws InvalidArgumentException {
        constraints.checkDocumentFragmentVersion(string);
    }

    public static final boolean isValidDocumentFragmentVersion(String string) {
        return constraints.isValidDocumentFragmentVersion(string);
    }

    public static final void checkNotationDeclName(String string) throws InvalidArgumentException {
        constraints.checkNotationDeclName(string);
    }

    public static final boolean isValidNotationDeclName(String string) {
        return constraints.isValidNotationDeclName(string);
    }

    public static final void checkAttributeValue(String string) throws InvalidArgumentException {
        constraints.checkAttributeValue(string);
    }

    public static final boolean isValidAttributeValue(String string) {
        return constraints.isValidAttributeValue(string);
    }

    public static final void checkParameterEntityReferenceName(String string) throws InvalidArgumentException {
        constraints.checkParameterEntityReferenceName(string);
    }

    public static final boolean isValidParameterEntityReferenceName(String string) {
        return constraints.isValidParameterEntityReferenceName(string);
    }

    public static final void checkDocumentFragmentEncoding(String string) throws InvalidArgumentException {
        constraints.checkDocumentFragmentEncoding(string);
    }

    public static final boolean isValidDocumentFragmentEncoding(String string) {
        return constraints.isValidDocumentFragmentEncoding(string);
    }

    public static final void checkTextData(String string) throws InvalidArgumentException {
        constraints.checkTextData(string);
    }

    public static final boolean isValidTextData(String string) {
        return constraints.isValidTextData(string);
    }

    public static final void checkDocumentTypePublicId(String string) throws InvalidArgumentException {
        constraints.checkDocumentTypePublicId(string);
    }

    public static final boolean isValidDocumentTypePublicId(String string) {
        return constraints.isValidDocumentTypePublicId(string);
    }

    public static final void checkElementDeclContentType(TreeElementDecl.ContentType contentType) throws InvalidArgumentException {
        constraints.checkElementDeclContentType(contentType);
    }

    public static final boolean isValidElementDeclContentType(TreeElementDecl.ContentType contentType) {
        return constraints.isValidElementDeclContentType(contentType);
    }

    public static final void checkDocumentVersion(String string) throws InvalidArgumentException {
        constraints.checkDocumentVersion(string);
    }

    public static final boolean isValidDocumentVersion(String string) {
        return constraints.isValidDocumentVersion(string);
    }

    public static final void checkCDATASectionData(String string) throws InvalidArgumentException {
        constraints.checkCDATASectionData(string);
    }

    public static final boolean isValidCDATASectionData(String string) {
        return constraints.isValidCDATASectionData(string);
    }

    public static final void checkNotationDeclPublicId(String string) throws InvalidArgumentException {
        constraints.checkNotationDeclPublicId(string);
    }

    public static final boolean isValidNotationDeclPublicId(String string) {
        return constraints.isValidNotationDeclPublicId(string);
    }

    public static final void checkAttlistDeclAttributeName(String string) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeName(string);
    }

    public static final boolean isValidAttlistDeclAttributeName(String string) {
        return constraints.isValidAttlistDeclAttributeName(string);
    }

    public static final void checkCommentData(String string) throws InvalidArgumentException {
        constraints.checkCommentData(string);
    }

    public static final boolean isValidCommentData(String string) {
        return constraints.isValidCommentData(string);
    }

    public static final void checkAttlistDeclAttributeType(short s) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeType(s);
    }

    public static final boolean isValidAttlistDeclAttributeType(short s) {
        return constraints.isValidAttlistDeclAttributeType(s);
    }

    public static final void checkAttlistDeclAttributeDefaultType(short s) throws InvalidArgumentException {
        constraints.checkAttlistDeclAttributeDefaultType(s);
    }

    public static final boolean isValidAttlistDeclAttributeDefaultType(short s) {
        return constraints.isValidAttlistDeclAttributeDefaultType(s);
    }

    public static final Collection getSupportedEncodings() {
        return EncodingUtil.getIANA2JavaMap().keySet();
    }

    public static final String iana2java(String string) {
        String string2 = (String)EncodingUtil.getIANA2JavaMap().get(string.toUpperCase());
        return string2 == null ? string : string2;
    }

    static class EncodingUtil {
        protected static final Map encodingIANA2JavaMap = new TreeMap();
        protected static final Map encodingIANADescriptionMap = new TreeMap();
        protected static final Map encodingIANAAliasesMap = new TreeMap();

        EncodingUtil() {
        }

        public static Map getIANA2JavaMap() {
            return encodingIANA2JavaMap;
        }

        static {
            encodingIANA2JavaMap.put("BIG5", "Big5");
            encodingIANADescriptionMap.put("BIG5", Util.THIS.getString("NAME_BIG5"));
            encodingIANAAliasesMap.put("BIG5", "BIG5");
            encodingIANA2JavaMap.put("IBM037", "CP037");
            encodingIANADescriptionMap.put("IBM037", Util.THIS.getString("NAME_IBM037"));
            encodingIANAAliasesMap.put("IBM037", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-US", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-CA", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-NL", "IBM037");
            encodingIANAAliasesMap.put("EBCDIC-CP-WT", "IBM037");
            encodingIANA2JavaMap.put("IBM277", "CP277");
            encodingIANADescriptionMap.put("IBM277", Util.THIS.getString("NAME_IBM277"));
            encodingIANAAliasesMap.put("IBM277", "IBM277");
            encodingIANAAliasesMap.put("EBCDIC-CP-DK", "IBM277");
            encodingIANAAliasesMap.put("EBCDIC-CP-NO", "IBM277");
            encodingIANA2JavaMap.put("IBM278", "CP278");
            encodingIANADescriptionMap.put("IBM278", Util.THIS.getString("NAME_IBM277"));
            encodingIANAAliasesMap.put("IBM278", "IBM278");
            encodingIANAAliasesMap.put("EBCDIC-CP-FI", "IBM278");
            encodingIANAAliasesMap.put("EBCDIC-CP-SE", "IBM278");
            encodingIANA2JavaMap.put("IBM280", "CP280");
            encodingIANADescriptionMap.put("IBM280", Util.THIS.getString("NAME_IBM280"));
            encodingIANAAliasesMap.put("IBM280", "IBM280");
            encodingIANAAliasesMap.put("EBCDIC-CP-IT", "IBM280");
            encodingIANA2JavaMap.put("IBM284", "CP284");
            encodingIANADescriptionMap.put("IBM284", Util.THIS.getString("NAME_IBM284"));
            encodingIANAAliasesMap.put("IBM284", "IBM284");
            encodingIANAAliasesMap.put("EBCDIC-CP-ES", "IBM284");
            encodingIANA2JavaMap.put("IBM285", "CP285");
            encodingIANADescriptionMap.put("IBM285", Util.THIS.getString("NAME_IBM285"));
            encodingIANAAliasesMap.put("IBM285", "IBM285");
            encodingIANAAliasesMap.put("EBCDIC-CP-GB", "IBM285");
            encodingIANA2JavaMap.put("IBM297", "CP297");
            encodingIANADescriptionMap.put("IBM297", Util.THIS.getString("NAME_IBM297"));
            encodingIANAAliasesMap.put("IBM297", "IBM297");
            encodingIANAAliasesMap.put("EBCDIC-CP-FR", "IBM297");
            encodingIANA2JavaMap.put("IBM424", "CP424");
            encodingIANADescriptionMap.put("IBM424", Util.THIS.getString("NAME_IBM424"));
            encodingIANAAliasesMap.put("IBM424", "IBM424");
            encodingIANAAliasesMap.put("EBCDIC-CP-HE", "IBM424");
            encodingIANA2JavaMap.put("IBM500", "CP500");
            encodingIANADescriptionMap.put("IBM500", Util.THIS.getString("NAME_IBM500"));
            encodingIANAAliasesMap.put("IBM500", "IBM500");
            encodingIANAAliasesMap.put("EBCDIC-CP-CH", "IBM500");
            encodingIANAAliasesMap.put("EBCDIC-CP-BE", "IBM500");
            encodingIANA2JavaMap.put("IBM870", "CP870");
            encodingIANADescriptionMap.put("IBM870", Util.THIS.getString("NAME_IBM870"));
            encodingIANAAliasesMap.put("IBM870", "IBM870");
            encodingIANAAliasesMap.put("EBCDIC-CP-ROECE", "IBM870");
            encodingIANAAliasesMap.put("EBCDIC-CP-YU", "IBM870");
            encodingIANA2JavaMap.put("IBM871", "CP871");
            encodingIANADescriptionMap.put("IBM871", Util.THIS.getString("NAME_IBM871"));
            encodingIANAAliasesMap.put("IBM871", "IBM871");
            encodingIANAAliasesMap.put("EBCDIC-CP-IS", "IBM871");
            encodingIANA2JavaMap.put("IBM918", "CP918");
            encodingIANADescriptionMap.put("IBM918", Util.THIS.getString("NAME_IBM918"));
            encodingIANAAliasesMap.put("IBM918", "IBM918");
            encodingIANAAliasesMap.put("EBCDIC-CP-AR2", "IBM918");
            encodingIANA2JavaMap.put("EUC-JP", "EUCJIS");
            encodingIANADescriptionMap.put("EUC-JP", Util.THIS.getString("NAME_EUC-JP"));
            encodingIANAAliasesMap.put("EUC-JP", "EUC-JP");
            encodingIANA2JavaMap.put("EUC-KR", "KSC5601");
            encodingIANADescriptionMap.put("EUC-KR", Util.THIS.getString("NAME_EUC-KR"));
            encodingIANAAliasesMap.put("EUC-KR", "EUC-KR");
            encodingIANA2JavaMap.put("GB2312", "GB2312");
            encodingIANADescriptionMap.put("GB2312", Util.THIS.getString("NAME_GB2312"));
            encodingIANAAliasesMap.put("GB2312", "GB2312");
            encodingIANA2JavaMap.put("ISO-2022-JP", "JIS");
            encodingIANADescriptionMap.put("ISO-2022-JP", Util.THIS.getString("NAME_ISO-2022-JP"));
            encodingIANAAliasesMap.put("ISO-2022-JP", "ISO-2022-JP");
            encodingIANA2JavaMap.put("ISO-2022-KR", "ISO2022KR");
            encodingIANADescriptionMap.put("ISO-2022-KR", Util.THIS.getString("NAME_ISO-2022-KR"));
            encodingIANAAliasesMap.put("ISO-2022-KR", "ISO-2022-KR");
            encodingIANA2JavaMap.put("ISO-8859-1", "8859_1");
            encodingIANADescriptionMap.put("ISO-8859-1", Util.THIS.getString("NAME_ISO-8859-1"));
            encodingIANAAliasesMap.put("ISO-8859-1", "ISO-8859-1");
            encodingIANAAliasesMap.put("LATIN1", "ISO-8859-1");
            encodingIANAAliasesMap.put("L1", "ISO-8859-1");
            encodingIANAAliasesMap.put("IBM819", "ISO-8859-1");
            encodingIANAAliasesMap.put("CP819", "ISO-8859-1");
            encodingIANA2JavaMap.put("ISO-8859-2", "8859_2");
            encodingIANADescriptionMap.put("ISO-8859-2", Util.THIS.getString("NAME_ISO-8859-2"));
            encodingIANAAliasesMap.put("ISO-8859-2", "ISO-8859-2");
            encodingIANAAliasesMap.put("LATIN2", "ISO-8859-2");
            encodingIANAAliasesMap.put("L2", "ISO-8859-2");
            encodingIANA2JavaMap.put("ISO-8859-3", "8859_3");
            encodingIANADescriptionMap.put("ISO-8859-3", Util.THIS.getString("NAME_ISO-8859-3"));
            encodingIANAAliasesMap.put("ISO-8859-3", "ISO-8859-3");
            encodingIANAAliasesMap.put("LATIN3", "ISO-8859-3");
            encodingIANAAliasesMap.put("L3", "ISO-8859-3");
            encodingIANA2JavaMap.put("ISO-8859-4", "8859_4");
            encodingIANADescriptionMap.put("ISO-8859-4", Util.THIS.getString("NAME_ISO-8859-4"));
            encodingIANAAliasesMap.put("ISO-8859-4", "ISO-8859-4");
            encodingIANAAliasesMap.put("LATIN4", "ISO-8859-4");
            encodingIANAAliasesMap.put("L4", "ISO-8859-4");
            encodingIANA2JavaMap.put("ISO-8859-5", "8859_5");
            encodingIANADescriptionMap.put("ISO-8859-5", Util.THIS.getString("NAME_ISO-8859-5"));
            encodingIANAAliasesMap.put("ISO-8859-5", "ISO-8859-5");
            encodingIANAAliasesMap.put("CYRILLIC", "ISO-8859-5");
            encodingIANA2JavaMap.put("ISO-8859-6", "8859_6");
            encodingIANADescriptionMap.put("ISO-8859-6", Util.THIS.getString("NAME_ISO-8859-6"));
            encodingIANAAliasesMap.put("ISO-8859-6", "ISO-8859-6");
            encodingIANA2JavaMap.put("ISO-8859-7", "8859_7");
            encodingIANADescriptionMap.put("ISO-8859-7", Util.THIS.getString("NAME_ISO-8859-7"));
            encodingIANAAliasesMap.put("ISO-8859-7", "ISO-8859-7");
            encodingIANAAliasesMap.put("GREEK", "ISO-8859-7");
            encodingIANAAliasesMap.put("GREEK8", "ISO-8859-7");
            encodingIANA2JavaMap.put("ISO-8859-8", "8859_8");
            encodingIANADescriptionMap.put("ISO-8859-8", Util.THIS.getString("NAME_ISO-8859-8"));
            encodingIANAAliasesMap.put("ISO-8859-8", "ISO-8859-8");
            encodingIANAAliasesMap.put("HEBREW", "ISO-8859-8");
            encodingIANA2JavaMap.put("ISO-8859-9", "8859_9");
            encodingIANADescriptionMap.put("ISO-8859-9", Util.THIS.getString("NAME_ISO-8859-9"));
            encodingIANAAliasesMap.put("ISO-8859-9", "ISO-8859-9");
            encodingIANAAliasesMap.put("LATIN5", "ISO-8859-9");
            encodingIANAAliasesMap.put("L5", "ISO-8859-9");
            encodingIANA2JavaMap.put("KOI8-R", "KOI8_R");
            encodingIANADescriptionMap.put("KOI8-R", Util.THIS.getString("NAME_KOI8-R"));
            encodingIANAAliasesMap.put("KOI8-R", "KOI8-R");
            encodingIANA2JavaMap.put("US-ASCII", "8859_1");
            encodingIANADescriptionMap.put("US-ASCII", Util.THIS.getString("NAME_ASCII"));
            encodingIANAAliasesMap.put("ASCII", "US-ASCII");
            encodingIANAAliasesMap.put("US-ASCII", "US-ASCII");
            encodingIANAAliasesMap.put("ISO646-US", "US-ASCII");
            encodingIANAAliasesMap.put("IBM367", "US-ASCII");
            encodingIANAAliasesMap.put("CP367", "US-ASCII");
            encodingIANA2JavaMap.put("UTF-8", "UTF8");
            encodingIANADescriptionMap.put("UTF-8", Util.THIS.getString("NAME_UTF-8"));
            encodingIANAAliasesMap.put("UTF-8", "UTF-8");
            encodingIANA2JavaMap.put("UTF-16", "Unicode");
            encodingIANADescriptionMap.put("UTF-16", Util.THIS.getString("NAME_UTF-16"));
            encodingIANAAliasesMap.put("UTF-16", "UTF-16");
        }
    }

    private static final class Constraints
    extends UnicodeClasses
    implements AttlistDecl.Constraints,
    Attribute.Constraints,
    CDATASection.Constraints,
    CharacterReference.Constraints,
    Comment.Constraints,
    ConditionalSection.Constraints,
    DocumentFragment.Constraints,
    Document.Constraints,
    DocumentType.Constraints,
    DTD.Constraints,
    ElementDecl.Constraints,
    Element.Constraints,
    EntityDecl.Constraints,
    GeneralEntityReference.Constraints,
    NotationDecl.Constraints,
    ParameterEntityReference.Constraints,
    ProcessingInstruction.Constraints,
    Text.Constraints {
        private Constraints() {
        }

        private static void checkNullArgument(String string, Object object) throws InvalidArgumentException {
            if (object == null) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_null_value"));
            }
        }

        private static void checkEmptyString(String string, String string2, boolean bl) throws InvalidArgumentException {
            if (string2.length() == 0 || bl && string2.trim().equals("")) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_empty_value"));
            }
        }

        private static void checkXMLName(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkEmptyString(string, string2, true);
            char c = string2.charAt(0);
            if (!Constraints.isXMLNameStartChar(c)) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_first_char", String.valueOf(c)));
            }
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c2 = string2.charAt(i);
                if (Constraints.isXMLNameChar(c2)) continue;
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_content_char", String.valueOf(c2)));
            }
        }

        private static void checkNmToken(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkEmptyString(string, string2, true);
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (Constraints.isXMLNameChar(c)) continue;
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_content_char", String.valueOf(c)));
            }
        }

        private static void checkXMLNCName(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkEmptyString(string, string2, true);
            char c = string2.charAt(0);
            if (!Constraints.isXMLNCNameStartChar(c)) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_first_char", String.valueOf(c)));
            }
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c2 = string2.charAt(i);
                if (Constraints.isXMLNCNameChar(c2)) continue;
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_content_char", String.valueOf(c2)));
            }
        }

        private static void checkNamespacePrefix(String string) throws InvalidArgumentException {
            String string2 = Util.THIS.getString("PROP_NamespacePrefix");
            Constraints.checkXMLNCName(string2, string);
        }

        private static void checkNamespaceURI(String string) throws InvalidArgumentException {
            String string2 = Util.THIS.getString("PROP_NamespaceURI");
            Constraints.checkAttributeValue(string2, string);
        }

        private static void checkElementName(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkXMLName(string, string2);
        }

        private static void checkAttributeName(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkXMLName(string, string2);
        }

        private static void checkAttributeValue(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkCharacterData(string, string2);
            int n = string2.indexOf(60);
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_invalid_attribute_value", string2));
            }
            n = string2.indexOf(38);
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_invalid_attribute_value", string2));
            }
            boolean bl = false;
            boolean bl2 = false;
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (c == '\'') {
                    if (bl2) {
                        throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_invalid_attribute_value", string2));
                    }
                    bl = true;
                }
                if (c != '\"') continue;
                if (bl) {
                    throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_invalid_attribute_value", string2));
                }
                bl2 = true;
            }
        }

        private static void checkCharacterData(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (Constraints.isXMLChar(c)) continue;
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_content_char", "0x" + Integer.toHexString(c)));
            }
        }

        private static void checkSystemId(String string, String string2) throws InvalidArgumentException {
            boolean bl = false;
            boolean bl2 = false;
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '\'') {
                    if (bl2) {
                        throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_Invalid_system_id", string2));
                    }
                    bl = true;
                }
                if (c != '\"') continue;
                if (bl) {
                    throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_Invalid_system_id", string2));
                }
                bl2 = true;
            }
        }

        private static void checkPublicId(String string, String string2) throws InvalidArgumentException {
            boolean bl = false;
            boolean bl2 = false;
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '\'') {
                    if (bl2) {
                        throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_Invalid_public_id", string2));
                    }
                    bl = true;
                    continue;
                }
                if (c == '\"') {
                    if (bl) {
                        throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_Invalid_public_id", string2));
                    }
                    bl2 = true;
                    continue;
                }
                if (Constraints.isXMLPubidLiteral(c)) continue;
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_Invalid_public_id", string2));
            }
        }

        private static void checkNotationName(String string, String string2) throws InvalidArgumentException {
            Constraints.checkNullArgument(string, string2);
            Constraints.checkXMLName(string, string2);
        }

        private static void checkEncoding(String string, String string2) throws InvalidArgumentException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TreeUtilities::checkEncoding: encoding = " + string2);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("      ::checkEncoding: stream = " + byteArrayInputStream);
            }
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, TreeUtilities.iana2java(string2));
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("      ::checkEncoding: reader = " + inputStreamReader);
                }
            }
            catch (IOException iOException) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("      ::checkEncoding: IOException !!!", iOException);
                }
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("EXC_Invalid_encoding", string2));
            }
        }

        public void checkAttributeName(TreeName treeName) throws InvalidArgumentException {
            String string = Util.THIS.getString("PROP_AttributeName");
            Constraints.checkAttributeName(string, treeName.getQualifiedName());
        }

        public boolean isValidAttributeName(TreeName treeName) {
            try {
                this.checkAttributeName(treeName);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkElementTagName(TreeName treeName) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_ElementTagName"), treeName.getQualifiedName());
        }

        public boolean isValidElementTagName(TreeName treeName) {
            try {
                this.checkElementTagName(treeName);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkNotationDeclSystemId(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkSystemId(Util.THIS.getString("PROP_NotationDeclSystemId"), string);
        }

        public boolean isValidNotationDeclSystemId(String string) {
            try {
                this.checkNotationDeclSystemId(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentEncoding(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkEncoding(Util.THIS.getString("PROP_DocumentEncoding"), string);
        }

        public boolean isValidDocumentEncoding(String string) {
            try {
                this.checkDocumentEncoding(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDTDEncoding(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkEncoding(Util.THIS.getString("PROP_DTDEncoding"), string);
        }

        public boolean isValidDTDEncoding(String string) {
            try {
                this.checkDTDEncoding(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkCharacterReferenceName(String string) throws InvalidArgumentException {
            String string2 = Util.THIS.getString("PROP_CharacterReferenceName");
            Constraints.checkNullArgument(string2, string);
            Constraints.checkEmptyString(string2, string, true);
            int n = 0;
            char c = string.charAt(n);
            if (c != '#') {
                throw new InvalidArgumentException((Object)string2, Util.THIS.getString("PROP_invalid_first_char", String.valueOf(c)));
            }
            if (string.length() <= ++n) {
                throw new InvalidArgumentException((Object)string2, Util.THIS.getString("PROP_invalid_empty_value"));
            }
            char c2 = string.charAt(n);
            int n2 = 10;
            if (c2 == 'x') {
                n2 = 16;
                if (string.length() <= ++n) {
                    throw new InvalidArgumentException((Object)string2, Util.THIS.getString("PROP_invalid_empty_value"));
                }
            }
            String string3 = string.substring(n);
            try {
                Short.parseShort(string3, n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidArgumentException((Object)string2, Util.THIS.getString("PROP_invalid_content_char", string3));
            }
        }

        public boolean isValidCharacterReferenceName(String string) {
            try {
                this.checkCharacterReferenceName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkEntityDeclInternalText(String string) throws InvalidArgumentException {
            Constraints.checkNullArgument(Util.THIS.getString("PROP_EntityDeclInternalText"), string);
            boolean bl = false;
            boolean bl2 = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    if (bl2) {
                        throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_EntityDeclInternalText"), Util.THIS.getString("EXC_Invalid_Entity_Decl_Internal_text", string));
                    }
                    bl = true;
                }
                if (c != '\"') continue;
                if (bl) {
                    throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_EntityDeclInternalText"), Util.THIS.getString("EXC_Invalid_Entity_Decl_Internal_text", string));
                }
                bl2 = true;
            }
        }

        public boolean isValidEntityDeclInternalText(String string) {
            try {
                this.checkEntityDeclInternalText(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttlistDeclElementName(String string) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_AttlistDeclElementName"), string);
        }

        public boolean isValidAttlistDeclElementName(String string) {
            try {
                this.checkAttlistDeclElementName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDTDVersion(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            if (!string.equals("1.0")) {
                String string2 = Util.THIS.getString("PROP_DTDVersion");
                String string3 = Util.THIS.getString("PROP_invalid_version_number", string);
                throw new InvalidArgumentException((Object)string2, string3);
            }
        }

        public boolean isValidDTDVersion(String string) {
            try {
                this.checkDTDVersion(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentTypeSystemId(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkSystemId(Util.THIS.getString("PROP_DocumentTypeSystemId"), string);
        }

        public boolean isValidDocumentTypeSystemId(String string) {
            try {
                this.checkDocumentTypeSystemId(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentTypeElementName(String string) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_DocumentTypeElementName"), string);
        }

        public boolean isValidDocumentTypeElementName(String string) {
            try {
                this.checkDocumentTypeElementName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentStandalone(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            if (string.equals("yes")) {
                return;
            }
            if (string.equals("no")) {
                return;
            }
            throw new InvalidArgumentException((Object)string, string + Util.THIS.getString("PROP_is_not_valid_standalone_value"));
        }

        public boolean isValidDocumentStandalone(String string) {
            try {
                this.checkDocumentStandalone(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkEntityDeclName(String string) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_EntityDeclName"), string);
        }

        public boolean isValidEntityDeclName(String string) {
            try {
                this.checkEntityDeclName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttlistDeclAttributeEnumeratedType(String[] stringArray) throws InvalidArgumentException {
            if (stringArray == null) {
                return;
            }
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Constraints.checkNmToken(Util.THIS.getString("PROP_AttlistDeclAttributeEnumeratedType"), stringArray[i]);
            }
        }

        public boolean isValidAttlistDeclAttributeEnumeratedType(String[] stringArray) {
            try {
                this.checkAttlistDeclAttributeEnumeratedType(stringArray);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkProcessingInstructionData(String string) throws InvalidArgumentException {
            Constraints.checkCharacterData(Util.THIS.getString("PROP_ProcessingInstructionData"), string);
            int n = string.indexOf("?>");
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_processing_instruction_data"));
            }
        }

        public boolean isValidProcessingInstructionData(String string) {
            try {
                this.checkProcessingInstructionData(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkEntityDeclNotationName(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkNotationName(Util.THIS.getString("PROP_EntityDeclNotationName"), string);
        }

        public boolean isValidEntityDeclNotationName(String string) {
            try {
                this.checkEntityDeclNotationName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkElementDeclName(String string) throws InvalidArgumentException {
            Constraints.checkElementName(Util.THIS.getString("PROP_ElementDeclName"), string);
        }

        public boolean isValidElementDeclName(String string) {
            try {
                this.checkElementDeclName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkGeneralEntityReferenceName(String string) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_GeneralEntityReferenceName"), string);
        }

        public boolean isValidGeneralEntityReferenceName(String string) {
            try {
                this.checkGeneralEntityReferenceName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkEntityDeclSystemId(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkSystemId(Util.THIS.getString("PROP_EntityDeclSystemId"), string);
        }

        public boolean isValidEntityDeclSystemId(String string) {
            try {
                this.checkEntityDeclSystemId(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkProcessingInstructionTarget(String string) throws InvalidArgumentException {
            String string2 = Util.THIS.getString("PROP_ProcessingInstructionTarget");
            Constraints.checkXMLName(string2, string);
            if (string.equalsIgnoreCase("xml")) {
                throw new InvalidArgumentException((Object)string2, Util.THIS.getString("PROP_invalid_content_char", string));
            }
        }

        public boolean isValidProcessingInstructionTarget(String string) {
            try {
                this.checkProcessingInstructionTarget(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkEntityDeclPublicId(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkPublicId(Util.THIS.getString("PROP_EntityDeclPublicId"), string);
        }

        public boolean isValidEntityDeclPublicId(String string) {
            try {
                this.checkEntityDeclPublicId(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttlistDeclAttributeDefaultValue(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    if (bl2) {
                        throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_AttlistDeclAttributeDefaultValue"), Util.THIS.getString("EXC_invalid_attribute_default_value", string));
                    }
                    bl = true;
                }
                if (c != '\"') continue;
                if (bl) {
                    throw new InvalidArgumentException((Object)Util.THIS.getString("PROP_AttlistDeclAttributeDefaultValue"), Util.THIS.getString("EXC_invalid_attribute_default_value", string));
                }
                bl2 = true;
            }
        }

        public boolean isValidAttlistDeclAttributeDefaultValue(String string) {
            try {
                this.checkAttlistDeclAttributeDefaultValue(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentFragmentVersion(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            if (!string.equals("1.0")) {
                String string2 = Util.THIS.getString("PROP_DocumentFragmentVersion");
                String string3 = Util.THIS.getString("PROP_invalid_version_number", string);
                throw new InvalidArgumentException((Object)string2, string3);
            }
        }

        public boolean isValidDocumentFragmentVersion(String string) {
            try {
                this.checkDocumentFragmentVersion(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkNotationDeclName(String string) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_NotationDeclName"), string);
        }

        public boolean isValidNotationDeclName(String string) {
            try {
                this.checkNotationDeclName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttributeValue(String string) throws InvalidArgumentException {
            String string2 = Util.THIS.getString("PROP_AttributeValue");
            Constraints.checkAttributeValue(string2, string);
        }

        public boolean isValidAttributeValue(String string) {
            try {
                this.checkAttributeValue(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkParameterEntityReferenceName(String string) throws InvalidArgumentException {
            Constraints.checkXMLName(Util.THIS.getString("PROP_ParameterEntityReferenceName"), string);
        }

        public boolean isValidParameterEntityReferenceName(String string) {
            try {
                this.checkParameterEntityReferenceName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentFragmentEncoding(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkEncoding(Util.THIS.getString("PROP_DocumentFragmentEncoding"), string);
        }

        public boolean isValidDocumentFragmentEncoding(String string) {
            try {
                this.checkDocumentFragmentEncoding(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkTextData(String string) throws InvalidArgumentException {
            String string2 = Util.THIS.getString("PROP_TextData");
            Constraints.checkCharacterData(string2, string);
            Constraints.checkEmptyString(string2, string, false);
            int n = string.indexOf(60);
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_text_data"));
            }
            n = string.indexOf(38);
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_text_data"));
            }
            n = string.indexOf("]]>");
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_text_data"));
            }
        }

        public boolean isValidTextData(String string) {
            try {
                this.checkTextData(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentTypePublicId(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkPublicId(Util.THIS.getString("PROP_DocumentTypePublicId"), string);
        }

        public boolean isValidDocumentTypePublicId(String string) {
            try {
                this.checkDocumentTypePublicId(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkElementDeclContentType(TreeElementDecl.ContentType contentType) throws InvalidArgumentException {
            Constraints.checkNullArgument(Util.THIS.getString("PROP_ElementDeclContentType"), contentType);
        }

        public boolean isValidElementDeclContentType(TreeElementDecl.ContentType contentType) {
            try {
                this.checkElementDeclContentType(contentType);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkDocumentVersion(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            if (!string.equals("1.0")) {
                String string2 = Util.THIS.getString("PROP_DocumentVersion");
                String string3 = Util.THIS.getString("PROP_invalid_version_number", string);
                throw new InvalidArgumentException((Object)string2, string3);
            }
        }

        public boolean isValidDocumentVersion(String string) {
            try {
                this.checkDocumentVersion(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkCDATASectionData(String string) throws InvalidArgumentException {
            Constraints.checkCharacterData(Util.THIS.getString("PROP_CDATASectionData"), string);
            int n = string.indexOf("]]>");
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_cdata_section_data"));
            }
        }

        public boolean isValidCDATASectionData(String string) {
            try {
                this.checkCDATASectionData(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkNotationDeclPublicId(String string) throws InvalidArgumentException {
            if (string == null) {
                return;
            }
            Constraints.checkPublicId(Util.THIS.getString("PROP_NotationDeclPublicId"), string);
        }

        public boolean isValidNotationDeclPublicId(String string) {
            try {
                this.checkNotationDeclPublicId(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttlistDeclAttributeName(String string) throws InvalidArgumentException {
            Constraints.checkAttributeName(Util.THIS.getString("PROP_AttlistDeclAttributeName"), string);
        }

        public boolean isValidAttlistDeclAttributeName(String string) {
            try {
                this.checkAttlistDeclAttributeName(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkCommentData(String string) throws InvalidArgumentException {
            Constraints.checkCharacterData(Util.THIS.getString("PROP_CommentData"), string);
            int n = string.indexOf("--");
            if (n != -1) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_comment_data"));
            }
            if (string.endsWith("-")) {
                throw new InvalidArgumentException((Object)string, Util.THIS.getString("PROP_invalid_comment_data_end"));
            }
        }

        public boolean isValidCommentData(String string) {
            try {
                this.checkCommentData(string);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttlistDeclAttributeType(short s) throws InvalidArgumentException {
            if (s != 0 && s != 1 && s != 2 && s != 3 && s != 4 && s != 5 && s != 6 && s != 7 && s != 8 && s != 9) {
                throw new InvalidArgumentException(new Short(s), Util.THIS.getString("PROP_invalid_attribute_list_declaration_type"));
            }
        }

        public boolean isValidAttlistDeclAttributeType(short s) {
            try {
                this.checkAttlistDeclAttributeType(s);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }

        public void checkAttlistDeclAttributeDefaultType(short s) throws InvalidArgumentException {
            if (s != 0 && s != 1 && s != 2 && s != 3) {
                throw new InvalidArgumentException(new Short(s), Util.THIS.getString("PROP_invalid_attribute_list_declaration_default_type"));
            }
        }

        public boolean isValidAttlistDeclAttributeDefaultType(short s) {
            try {
                this.checkAttlistDeclAttributeDefaultType(s);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                return false;
            }
            return true;
        }
    }
}

