/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.cpu;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.datacollector.CpuSamplingSupport;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.visualizers.api.CallersCalleesVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class DLightCPUToolConfigurationProvider
implements DLightToolConfigurationProvider {
    public static final int INDICATOR_POSITION = 100;
    public static final String ID = "dlight.tool.cpu";
    private static final String TOOL_NAME = DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ToolName", new String[0]);
    private static final String DETAILED_TOOL_NAME = DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.DetailedToolName", new String[0]);
    private static final boolean CPU_TREE_TABLE = Boolean.valueOf(System.getProperty("cpu.tree.table", "false"));

    public DLightToolConfiguration create() {
        FunctionDatatableDescription functionDatatableDescription;
        CallersCalleesVisualizerConfiguration callersCalleesVisualizerConfiguration;
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(ID, TOOL_NAME);
        dLightToolConfiguration.setLongName(DETAILED_TOOL_NAME);
        dLightToolConfiguration.setDescription(DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.Description", new String[0]));
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/cpu/resources/cpu.png");
        SunStudioDCConfiguration sunStudioDCConfiguration = new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.FUNCTIONS_LIST);
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)sunStudioDCConfiguration);
        DataTableMetadata dataTableMetadata = SunStudioDCConfiguration.getCPUTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_iUser, SunStudioDCConfiguration.c_eUser});
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setDisplayedName(SunStudioDCConfiguration.c_name.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_iUser.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_incl", new String[0]), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnTooltip.time_incl", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_eUser.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_excl", new String[0]), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnTooltip.time_excl", new String[0]));
        if (CPU_TREE_TABLE) {
            callersCalleesVisualizerConfiguration = new CallersCalleesVisualizerConfiguration(dataTableMetadata, "name", false);
            callersCalleesVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        } else {
            functionDatatableDescription = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
            callersCalleesVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata, functionDatatableDescription, Arrays.asList(SunStudioDCConfiguration.c_eUser, SunStudioDCConfiguration.c_iUser));
            ((FunctionsListViewVisualizerConfiguration)callersCalleesVisualizerConfiguration).setColumnsUIMapping(columnsUIMapping);
            ((FunctionsListViewVisualizerConfiguration)callersCalleesVisualizerConfiguration).setEmptyAnalyzeMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
            ((FunctionsListViewVisualizerConfiguration)callersCalleesVisualizerConfiguration).setEmptyRunningMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        }
        functionDatatableDescription = DTDCConfiguration.createCpuSamplingConfiguration();
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)functionDatatableDescription);
        VisualizerConfiguration visualizerConfiguration = this.createDTraceBasedVisualizerConfiguration(CpuSamplingSupport.CPU_SAMPLE_TABLE);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)new ProcDataProviderConfiguration());
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.CPU));
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        arrayList.add(ProcDataProviderConfiguration.USR_TIME);
        arrayList.add(ProcDataProviderConfiguration.SYS_TIME);
        arrayList.addAll(LLDataCollectorConfiguration.CPU_TABLE.getColumns());
        IndicatorMetadata indicatorMetadata = new IndicatorMetadata(arrayList);
        TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 100);
        timeSeriesIndicatorConfiguration.setActionTooltip(DLightCPUToolConfigurationProvider.loc("indicator.action.tooltip", new String[0]));
        timeSeriesIndicatorConfiguration.setTitle(DLightCPUToolConfigurationProvider.loc("indicator.title", new String[0]));
        timeSeriesIndicatorConfiguration.setGraphScale(100);
        timeSeriesIndicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor(new Color(255, 199, 38), DLightCPUToolConfigurationProvider.loc("graph.description.system", new String[0]), TimeSeriesDescriptor.Kind.REL_SURFACE), new TimeSeriesDescriptor(new Color(231, 111, 0), DLightCPUToolConfigurationProvider.loc("graph.description.user", new String[0]), TimeSeriesDescriptor.Kind.REL_SURFACE)});
        timeSeriesIndicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToCpu(Arrays.asList(ProcDataProviderConfiguration.USR_TIME), Arrays.asList(ProcDataProviderConfiguration.SYS_TIME)));
        timeSeriesIndicatorConfiguration.setActionDisplayName(DLightCPUToolConfigurationProvider.loc("indicator.action", new String[0]));
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration(visualizerConfiguration);
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)callersCalleesVisualizerConfiguration);
        dLightToolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)timeSeriesIndicatorConfiguration);
        return dLightToolConfiguration;
    }

    private VisualizerConfiguration createDTraceBasedVisualizerConfiguration(DataTableMetadata dataTableMetadata) {
        String string;
        FunctionMetric functionMetric2;
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        ArrayList<DataTableMetadata.Column> arrayList2 = new ArrayList<DataTableMetadata.Column>();
        DataTableMetadata.Column column = new DataTableMetadata.Column("name", String.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.name", new String[0]), null);
        arrayList.add(column);
        List list = StackDataStorage.METRICS;
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        for (FunctionMetric functionMetric2 : list) {
            string = functionMetric2.getMetricID();
            String string2 = DLightCPUToolConfigurationProvider.locMetricDisplayedName(string);
            String string3 = DLightCPUToolConfigurationProvider.locMetricTooltip(string);
            if (string2 != null) {
                columnsUIMapping.setDisplayedName(string, string2);
            }
            if (string3 != null) {
                columnsUIMapping.setTooltip(string, string3);
            }
            DataTableMetadata.Column column2 = new DataTableMetadata.Column(string, functionMetric2.getMetricValueClass(), functionMetric2.getMetricDisplayedName(), null);
            arrayList.add(column2);
            arrayList2.add(column2);
        }
        DataTableMetadata dataTableMetadata2 = new DataTableMetadata("DtraceStack", arrayList, null, Arrays.asList(dataTableMetadata));
        if (CPU_TREE_TABLE) {
            functionMetric2 = new CallersCalleesVisualizerConfiguration(dataTableMetadata2, "name", false);
            functionMetric2.setColumnsUIMapping(columnsUIMapping);
            return functionMetric2;
        }
        functionMetric2 = new FunctionDatatableDescription(column.getColumnName(), null, column.getColumnName());
        string = new FunctionsListViewVisualizerConfiguration(dataTableMetadata2, (FunctionDatatableDescription)functionMetric2, arrayList2);
        string.setEmptyAnalyzeMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        string.setEmptyRunningMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        string.setColumnsUIMapping(columnsUIMapping);
        return string;
    }

    private static String locMetricDisplayedName(String string) {
        try {
            return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)("FunctionMetric." + string));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String locMetricTooltip(String string) {
        try {
            return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)("FunctionMetric.tooltip." + string));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)string, (Object[])stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataRowToCpu
    implements DataRowToTimeSeries {
        private final List<DataTableMetadata.Column> usrColumns;
        private final List<DataTableMetadata.Column> sysColumns;

        public DataRowToCpu(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2) {
            this.usrColumns = new ArrayList<DataTableMetadata.Column>(list);
            this.sysColumns = new ArrayList<DataTableMetadata.Column>(list2);
        }

        public float[] getData(DataRow dataRow) {
            float[] fArray = null;
            for (String string : dataRow.getColumnNames()) {
                for (DataTableMetadata.Column column : this.usrColumns) {
                    if (!column.getColumnName().equals(string)) continue;
                    if (fArray == null) {
                        fArray = new float[2];
                    }
                    fArray[1] = DataUtil.toInt((Object)dataRow.getData(string));
                }
                for (DataTableMetadata.Column column : this.sysColumns) {
                    if (!column.getColumnName().equals(string)) continue;
                    if (fArray == null) {
                        fArray = new float[2];
                    }
                    fArray[0] = DataUtil.toInt((Object)dataRow.getData(string));
                }
            }
            return fArray;
        }

        public Map<String, String> getDetails() {
            return Collections.emptyMap();
        }
    }
}

