/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.J2SEPlatformModule;
import org.netbeans.modules.java.j2seplatform.UpdateLogger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Exceptions;

public final class UpdateTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UpdateLogger.class.getName());
    private static final UpdateTask instance = new UpdateTask();
    private final AtomicBoolean done = new AtomicBoolean();

    private UpdateTask() {
    }

    public static UpdateTask getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.fine("Requesting update");
        if (!this.done.getAndSet(true)) {
            boolean bl = false;
            try {
                UpdateTask.updateBuildProperties();
                bl = true;
                LOG.fine("Update: " + (bl ? "OK" : "Failed"));
            }
            catch (Throwable throwable) {
                LOG.fine("Update: " + (bl ? "OK" : "Failed"));
                throw throwable;
            }
        }
    }

    private static boolean updateSourceLevel(EditableProperties editableProperties) {
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        String string = javaPlatform.getSpecification().getVersion().toString();
        if (!string.equals(editableProperties.getProperty("default.javac.source"))) {
            editableProperties.setProperty("default.javac.source", string);
            editableProperties.setProperty("default.javac.target", string);
            return true;
        }
        return false;
    }

    private static boolean updateBuildProperties(EditableProperties editableProperties) {
        boolean bl = false;
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string;
            String string2;
            if (javaPlatformArray[i].equals(JavaPlatformManager.getDefault().getDefaultPlatform()) || !(javaPlatformArray[i] instanceof J2SEPlatformImpl) || editableProperties.containsKey((Object)(string2 = PlatformConvertor.createName(string = ((J2SEPlatformImpl)javaPlatformArray[i]).getAntName(), "home")))) continue;
            try {
                PlatformConvertor.generatePlatformProperties(javaPlatformArray[i], string, editableProperties);
                bl = true;
                continue;
            }
            catch (PlatformConvertor.BrokenPlatformException brokenPlatformException) {
                Logger.getLogger(J2SEPlatformModule.class.getName()).info("Platform: " + javaPlatformArray[i].getDisplayName() + " is missing: " + brokenPlatformException.getMissingTool());
                continue;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl;
    }

    private static void updateBuildProperties() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = UpdateTask.updateSourceLevel(editableProperties);
                    if (bl |= UpdateTask.updateBuildProperties(editableProperties)) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }
}

