/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.unedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.command.edit.EditCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class UneditCommand
extends BasicCommand {
    private Watch temporaryWatch;

    public UneditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        try {
            super.execute(clientServices, eventManager);
            this.addRequestForWorkingDirectory(clientServices);
            this.addRequest(CommandRequest.NOOP);
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String string = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "U", string));
        try {
            this.uneditFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("unedit ");
        stringBuffer.append(this.getCVSArguments());
        this.appendFileArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch watch) {
        this.temporaryWatch = watch;
    }

    private void uneditFile(File file) throws IOException {
        this.removeBaserevEntry(file);
        EditCommand.getEditBackupFile(file).delete();
        FileUtils.setFileReadOnly(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBaserevEntry(File file) throws IOException {
        File file2 = new File(file.getParentFile(), "CVS/Baserev");
        File file3 = new File(file2.getAbsolutePath() + '~');
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string = 'B' + file.getName() + '/';
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file3));
            bufferedReader = new BufferedReader(new FileReader(file2));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!string2.startsWith(string)) {
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        file2.delete();
        if (file3.length() > 0L) {
            file3.renameTo(file2);
        } else {
            file3.delete();
        }
    }
}

