/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateBuilder;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;

public class AnnotateInformation
extends FileInfoContainer {
    private File file;
    private List linesList;
    private Iterator iterator;
    private File tempFile;
    private File tempDir;
    private BufferedOutputStream tempOutStream;

    public AnnotateInformation() {
        this.tempDir = null;
    }

    public AnnotateInformation(File file) {
        this.tempDir = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        return stringBuffer.toString();
    }

    public AnnotateLine createAnnotateLine() {
        return new AnnotateLine();
    }

    public void addLine(AnnotateLine annotateLine) {
        this.linesList.add(annotateLine);
    }

    public AnnotateLine getFirstLine() {
        if (this.linesList == null) {
            this.linesList = this.createLinesList();
        }
        this.iterator = this.linesList.iterator();
        return this.getNextLine();
    }

    public AnnotateLine getNextLine() {
        if (this.iterator == null) {
            return null;
        }
        if (!this.iterator.hasNext()) {
            return null;
        }
        return (AnnotateLine)this.iterator.next();
    }

    protected void addToTempFile(String string) throws IOException {
        if (this.tempOutStream == null) {
            try {
                this.tempFile = File.createTempFile("ann", ".cvs", this.tempDir);
                this.tempFile.deleteOnExit();
                this.tempOutStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.tempOutStream.write(string.getBytes());
        this.tempOutStream.write(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTempFile() throws IOException {
        if (this.tempOutStream == null) {
            return;
        }
        try {
            this.tempOutStream.flush();
        }
        finally {
            this.tempOutStream.close();
        }
    }

    public File getTempFile() {
        return this.tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List createLinesList() {
        LinkedList<AnnotateLine> linkedList = new LinkedList<AnnotateLine>();
        BufferedReader bufferedReader = null;
        if (this.tempFile == null) {
            return linkedList;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(this.tempFile));
            String string = bufferedReader.readLine();
            int n = 1;
            while (string != null) {
                AnnotateLine annotateLine = AnnotateBuilder.processLine(string);
                if (annotateLine != null) {
                    annotateLine.setLineNum(n);
                    linkedList.add(annotateLine);
                    ++n;
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return linkedList;
    }
}

