/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.newproject;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.newproject.ContentPanel;
import org.netbeans.modules.ide.ergonomics.newproject.FeatureOnDemandWizardIterator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private ContentPanel panel;
    private ProgressHandle handle = null;
    private Collection<UpdateElement> forEnable = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static FindComponentModules finder = null;
    private FeatureInfo info;
    private WizardDescriptor wd;
    private final ConfigurationPanel configPanel;
    private PresentModules findModules = new PresentModules();

    public DescriptionStep(boolean bl) {
        this.configPanel = new ConfigurationPanel(new Callable<JComponent>(){

            @Override
            public JComponent call() throws Exception {
                FoDFileSystem.getInstance().refresh();
                DescriptionStep.this.waitForDelegateWizard();
                return new JLabel(" ");
            }
        }, (Boolean)bl);
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.panel = new ContentPanel(DescriptionStep.getBundle("DescriptionPanel_Name", new Object[0]));
            this.panel.addPropertyChangeListener(this.findModules);
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return false;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        DescriptionStep descriptionStep = this;
        synchronized (descriptionStep) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void presentModulesForActivation() {
        this.forEnable = this.getFinder().getModulesForEnable();
        this.presentModulesForEnable();
    }

    private void presentModulesForEnable() {
        Collection<UpdateElement> collection;
        if (this.handle != null) {
            this.handle.finish();
            this.panel.replaceComponents(new JComponent[0]);
            this.handle = null;
        }
        if ((collection = this.getFinder().getModulesForEnable()) != null && !collection.isEmpty()) {
            Collection<UpdateElement> collection2 = this.getFinder().getVisibleUpdateElements(collection);
            String string = ModulesInstaller.presentUpdateElements(collection2);
            this.configPanel.setInfo(this.info);
            this.configPanel.setPanelName(string);
            this.panel.replaceComponents(this.configPanel);
            this.forEnable = collection;
            this.fireChange();
        } else {
            FoDFileSystem.getInstance().refresh();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DescriptionStep.this.waitForDelegateWizard();
                    DescriptionStep.this.fireChange();
                }
            });
        }
    }

    private FindComponentModules getFinder() {
        assert (finder != null) : "Finder needs to be created first!";
        return finder;
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(DescriptionStep.class, (String)string, (Object[])objectArray);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wd = wizardDescriptor;
        Object object = wizardDescriptor.getProperty("chosen-template");
        assert (object != null && object instanceof FileObject) : object + " is not null and instanceof FileObject.";
        FileObject fileObject = (FileObject)object;
        this.info = FoDFileSystem.getInstance().whichProvides(fileObject);
        finder = new FindComponentModules(this.info, new FeatureInfo[0]);
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        if (this.forEnable != null && !this.forEnable.isEmpty()) {
            wizardDescriptor.putProperty("chosen-elements-for-enable", this.forEnable);
            this.fireChange();
        }
    }

    private void waitForDelegateWizard() {
        Object object = this.wd.getProperty("chosen-template");
        assert (object != null && object instanceof FileObject) : object + " is not null and instanceof FileObject";
        String string = ((FileObject)object).getPath();
        FileObject fileObject = null;
        WizardDescriptor.InstantiatingIterator instantiatingIterator = null;
        int n = 0;
        while (fileObject == null || instantiatingIterator == null) {
            Collection collection;
            FileObject fileObject2;
            Object object2;
            block12: {
                FoDFileSystem.getInstance().refresh();
                FoDFileSystem.getInstance().waitFinished();
                if (string.startsWith("Servers/WizardProvider")) {
                    try {
                        object2 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                        fileObject2 = Class.forName("org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory", true, (ClassLoader)object2);
                        collection = Lookups.forPath((String)("J2EE/DeploymentPlugins/" + string.substring(string.indexOf(45) + 1, string.indexOf(46)) + "/")).lookupAll(fileObject2);
                        if (!collection.isEmpty()) {
                            Object e = collection.iterator().next();
                            Method method = e.getClass().getMethod("getAddInstanceIterator", new Class[0]);
                            instantiatingIterator = (WizardDescriptor.InstantiatingIterator)method.invoke(e, new Object[0]);
                            fileObject = (FileObject)object;
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                        break;
                    }
                }
                fileObject = FileUtil.getConfigFile((String)string);
                instantiatingIterator = DescriptionStep.readWizard(fileObject);
            }
            if (!(instantiatingIterator instanceof FeatureOnDemandWizardIterator)) continue;
            object2 = Logger.getLogger(DescriptionStep.class.getName());
            ((Logger)object2).warning("There is still wrong interator " + instantiatingIterator.getClass().getName() + " for file object " + fileObject);
            FeatureManager.dumpModules(Level.INFO, Level.INFO);
            instantiatingIterator = null;
            if (++n == 10) {
                Logger.getLogger(DescriptionStep.class.getName()).severe("Giving up to find iterator for " + fileObject);
                Logger.getLogger(DescriptionStep.class.getName()).severe(DescriptionStep.threadDump());
                boolean bl = false;
                if (!$assertionsDisabled) {
                    bl = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl) {
                    throw new NullPointerException("Send us the messages.log please!");
                }
                return;
            }
            ((Logger)object2).info("Forcing refresh");
            FoDFileSystem.getInstance().refreshForce();
            ((Logger)object2).info("Done with refresh");
            fileObject2 = FileUtil.getConfigFile((String)string);
            if (fileObject2 == null) {
                ((Logger)object2).warning("no " + string + " on FoD: " + fileObject2);
                for (collection = fileObject; collection != null; collection = collection.getParent()) {
                    ((Logger)object2).info("  parent: " + collection + " children: " + Arrays.asList(collection.getChildren()));
                }
                continue;
            }
            ((Logger)object2).info("fake found " + fileObject2);
            ((Logger)object2).info("its wizard is " + DescriptionStep.readWizard(fileObject2));
        }
        instantiatingIterator.initialize(this.wd);
        this.wd.putProperty("delegate-iterator", instantiatingIterator);
        this.fireChange();
    }

    public static WizardDescriptor.InstantiatingIterator<?> readWizard(FileObject fileObject) {
        Object object;
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        Object object2 = fileObject.getAttribute("instantiatingIterator");
        if ((object2 == null || object2 instanceof FeatureOnDemandWizardIterator) && (object = fileObject.getAttribute("templateWizardIterator")) != null) {
            object2 = object;
        }
        if (!(object2 instanceof WizardDescriptor.InstantiatingIterator) && object2 instanceof TemplateWizard.Iterator) {
            object = (TemplateWizard.Iterator)object2;
            object2 = new WizardDescriptor.InstantiatingIterator<WizardDescriptor>((TemplateWizard.Iterator)object){
                private TemplateWizard tw;
                final /* synthetic */ TemplateWizard.Iterator val$it;
                {
                    this.val$it = iterator;
                }

                public Set instantiate() throws IOException {
                    return this.val$it.instantiate(this.tw);
                }

                public void initialize(WizardDescriptor wizardDescriptor) {
                    this.tw = (TemplateWizard)wizardDescriptor;
                    try {
                        FileObject fileObject = this.tw.getTemplate().getPrimaryFile();
                        if (!fileObject.isValid()) {
                            fileObject = FileUtil.getConfigFile((String)fileObject.getPath());
                        }
                        this.tw.setTemplate(DataObject.find((FileObject)fileObject));
                        this.val$it.initialize(this.tw);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Logger.getLogger(DescriptionStep.class.getName()).severe(dataObjectNotFoundException.toString());
                    }
                }

                public void uninitialize(WizardDescriptor wizardDescriptor) {
                    this.val$it.uninitialize((TemplateWizard)wizardDescriptor);
                    this.tw = null;
                }

                public WizardDescriptor.Panel<WizardDescriptor> current() {
                    return this.val$it.current();
                }

                public String name() {
                    return this.val$it.name();
                }

                public boolean hasNext() {
                    return this.val$it.hasNext();
                }

                public boolean hasPrevious() {
                    return this.val$it.hasPrevious();
                }

                public void nextPanel() {
                    this.val$it.nextPanel();
                }

                public void previousPanel() {
                    this.val$it.previousPanel();
                }

                public void addChangeListener(ChangeListener changeListener) {
                    this.val$it.addChangeListener(changeListener);
                }

                public void removeChangeListener(ChangeListener changeListener) {
                    this.val$it.removeChangeListener(changeListener);
                }
            };
        }
        assert (object2 != null && object2 instanceof WizardDescriptor.InstantiatingIterator) : object2 + " is not null and instanceof WizardDescriptor.InstantiatingIterator";
        return (WizardDescriptor.InstantiatingIterator)object2;
    }

    private static String threadDump() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Thread dump:\n");
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey().getName()).append('\n');
            if (entry.getValue() == null) {
                stringBuilder.append("  no information\n");
                continue;
            }
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                stringBuilder.append("  ");
                stringBuilder.append(stackTraceElement.getClassName()).append('.');
                stringBuilder.append(stackTraceElement.getMethodName()).append(':');
                stringBuilder.append(stackTraceElement.getLineNumber()).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private class PresentModules
    implements Runnable,
    PropertyChangeListener {
        private PresentModules() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ContentPanel.FINDING_MODULES.equals(propertyChangeEvent.getPropertyName())) {
                FeatureManager.getInstance().create(this).schedule(0);
            }
        }

        public void run() {
            assert (!SwingUtilities.isEventDispatchThread());
            DescriptionStep.this.presentModulesForActivation();
        }
    }
}

