/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.faces.renderer.AbstractRenderer;
import org.apache.struts.util.ResponseUtils;

public class WriteRenderer
extends AbstractRenderer {
    private static Log log = LogFactory.getLog((Class)WriteRenderer.class);

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getId();
        if (id != null && id.startsWith("_id")) {
            id = null;
        }
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (log.isTraceEnabled()) {
            log.trace((Object)("id='" + id + "', style='" + style + "', styleClass='" + styleClass + "'"));
        }
        if (id != null || style != null || styleClass != null) {
            writer.startElement("span", component);
            if (id != null) {
                writer.writeAttribute("id", (Object)component.getClientId(context), "id");
            }
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            writer.writeText((Object)"", null);
        }
        String text = this.getText(context, component);
        if (log.isTraceEnabled()) {
            log.trace((Object)("encodeEnd(" + component.getClientId(context) + "," + text + ")"));
        }
        writer.write(text);
        if (id != null || style != null || styleClass != null) {
            writer.endElement("span");
        }
    }

    protected String getText(FacesContext context, UIComponent component) {
        String text = this.getAsString(context, component, ((ValueHolder)component).getValue());
        Boolean filter = (Boolean)component.getAttributes().get("filter");
        if (filter == null) {
            filter = Boolean.FALSE;
        }
        if (filter.booleanValue()) {
            return ResponseUtils.filter((String)text);
        }
        return text;
    }
}

