/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.HyperCompoundModel;
import org.netbeans.modules.viewmodel.TreeModelHyperNode;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class TreeModelRoot {
    static final long serialVersionUID = -1259352660663524178L;
    private Models.CompoundModel model;
    private HyperCompoundModel hyperModel;
    private ModelChangeListener[] modelListeners;
    private TreeModelNode rootNode;
    private final WeakHashMap<Object, WeakReference<TreeModelNode>[]> objectToNode = new WeakHashMap();
    private DefaultTreeFeatures treeFeatures;
    private ExplorerManager manager;

    public TreeModelRoot(Models.CompoundModel compoundModel, TreeView treeView) {
        this.model = compoundModel;
        this.manager = ExplorerManager.find((Component)treeView);
        this.treeFeatures = new DefaultTreeFeatures(treeView);
        this.modelListeners = new ModelChangeListener[]{new ModelChangeListener(compoundModel)};
        compoundModel.addModelListener(this.modelListeners[0]);
    }

    public TreeModelRoot(HyperCompoundModel hyperCompoundModel, TreeView treeView) {
        this.hyperModel = hyperCompoundModel;
        this.model = hyperCompoundModel.getMain();
        this.manager = ExplorerManager.find((Component)treeView);
        this.treeFeatures = new DefaultTreeFeatures(treeView);
        int n = hyperCompoundModel.getModels().length;
        this.modelListeners = new ModelChangeListener[n];
        for (int i = 0; i < n; ++i) {
            Models.CompoundModel compoundModel = hyperCompoundModel.getModels()[i];
            this.modelListeners[i] = new ModelChangeListener(compoundModel);
            compoundModel.addModelListener(this.modelListeners[i]);
        }
    }

    public TreeModelRoot(Models.CompoundModel compoundModel, OutlineView outlineView) {
        this.model = compoundModel;
        this.manager = ExplorerManager.find((Component)outlineView);
        this.treeFeatures = new DefaultTreeFeatures(outlineView);
        this.modelListeners = new ModelChangeListener[]{new ModelChangeListener(compoundModel)};
        compoundModel.addModelListener(this.modelListeners[0]);
    }

    public TreeModelRoot(HyperCompoundModel hyperCompoundModel, OutlineView outlineView) {
        this.hyperModel = hyperCompoundModel;
        this.model = hyperCompoundModel.getMain();
        this.manager = ExplorerManager.find((Component)outlineView);
        this.treeFeatures = new DefaultTreeFeatures(outlineView);
        int n = hyperCompoundModel.getModels().length;
        this.modelListeners = new ModelChangeListener[n];
        for (int i = 0; i < n; ++i) {
            Models.CompoundModel compoundModel = hyperCompoundModel.getModels()[i];
            this.modelListeners[i] = new ModelChangeListener(compoundModel);
            compoundModel.addModelListener(this.modelListeners[i]);
        }
    }

    public Models.TreeFeatures getTreeFeatures() {
        return this.treeFeatures;
    }

    public TreeModelNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = this.hyperModel != null ? new TreeModelHyperNode(this.hyperModel, this, this.model.getRoot()) : new TreeModelNode(this.model, this, this.model.getRoot());
        }
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNode(Object object, TreeModelNode treeModelNode) {
        WeakHashMap<Object, WeakReference<TreeModelNode>[]> weakHashMap = this.objectToNode;
        synchronized (weakHashMap) {
            WeakReference<TreeModelNode>[] weakReferenceArray = this.objectToNode.get(object);
            if (weakReferenceArray == null) {
                this.objectToNode.put(object, new WeakReference[]{new WeakReference<TreeModelNode>(treeModelNode)});
            } else {
                for (int i = 0; i < weakReferenceArray.length; ++i) {
                    WeakReference<TreeModelNode> weakReference = weakReferenceArray[i];
                    TreeModelNode treeModelNode2 = (TreeModelNode)((Object)weakReference.get());
                    if (treeModelNode2 == treeModelNode) {
                        return;
                    }
                    if (treeModelNode2 != null) continue;
                    weakReferenceArray[i] = new WeakReference<TreeModelNode>(treeModelNode);
                    return;
                }
                WeakReference[] weakReferenceArray2 = new WeakReference[weakReferenceArray.length + 1];
                System.arraycopy(weakReferenceArray, 0, weakReferenceArray2, 0, weakReferenceArray.length);
                weakReferenceArray2[weakReferenceArray.length] = new WeakReference<TreeModelNode>(treeModelNode);
                this.objectToNode.put(object, weakReferenceArray2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeModelNode[] findNode(Object object) {
        TreeModelNode[] treeModelNodeArray = this.objectToNode;
        synchronized (this.objectToNode) {
            WeakReference<TreeModelNode>[] weakReferenceArray = this.objectToNode.get(object);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            treeModelNodeArray = null;
            if (weakReferenceArray != null) {
                for (int i = 0; i < weakReferenceArray.length; ++i) {
                    WeakReference<TreeModelNode> weakReference = weakReferenceArray[i];
                    TreeModelNode treeModelNode = (TreeModelNode)((Object)weakReference.get());
                    if (treeModelNode == null) continue;
                    if (treeModelNodeArray == null) {
                        treeModelNodeArray = new TreeModelNode[]{treeModelNode};
                        continue;
                    }
                    TreeModelNode[] treeModelNodeArray2 = new TreeModelNode[treeModelNodeArray.length + 1];
                    System.arraycopy(treeModelNodeArray, 0, treeModelNodeArray2, 0, treeModelNodeArray.length);
                    treeModelNodeArray2[treeModelNodeArray.length] = treeModelNode;
                    treeModelNodeArray = treeModelNodeArray2;
                }
            }
            if (treeModelNodeArray == null) {
                return new TreeModelNode[0];
            }
            return treeModelNodeArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.model != null) {
            for (ModelChangeListener modelChangeListener : this.modelListeners) {
                modelChangeListener.model.removeModelListener(modelChangeListener);
            }
            this.treeFeatures.destroy();
            this.treeFeatures = null;
        }
        this.model = null;
        WeakHashMap<Object, WeakReference<TreeModelNode>[]> weakHashMap = this.objectToNode;
        synchronized (weakHashMap) {
            this.objectToNode.clear();
        }
    }

    public synchronized Models.CompoundModel getModel() {
        return this.model;
    }

    private final class DefaultTreeFeatures
    extends Models.TreeFeatures
    implements TreeExpansionListener {
        private TreeView view;
        private OutlineView outline;

        private DefaultTreeFeatures(TreeView treeView) {
            JTree jTree;
            this.view = treeView;
            try {
                Field field = TreeView.class.getDeclaredField("tree");
                field.setAccessible(true);
                jTree = (JTree)field.get(treeView);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return;
            }
            jTree.addTreeExpansionListener(this);
        }

        private DefaultTreeFeatures(OutlineView outlineView) {
            this.outline = outlineView;
            outlineView.addTreeExpansionListener((TreeExpansionListener)this);
        }

        public void destroy() {
            if (this.outline != null) {
                this.outline.removeTreeExpansionListener((TreeExpansionListener)this);
            } else {
                JTree jTree;
                try {
                    Field field = TreeView.class.getDeclaredField("tree");
                    field.setAccessible(true);
                    jTree = (JTree)field.get(this.view);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    return;
                }
                jTree.removeTreeExpansionListener(this);
            }
        }

        public boolean isExpanded(Object object) {
            TreeModelNode[] treeModelNodeArray = TreeModelRoot.this.findNode(object);
            if (treeModelNodeArray.length == 0) {
                return false;
            }
            if (this.outline != null) {
                return this.outline.isExpanded((Node)treeModelNodeArray[0]);
            }
            return this.view.isExpanded((Node)treeModelNodeArray[0]);
        }

        public void expandNode(Object object) {
            TreeModelNode[] treeModelNodeArray;
            for (TreeModelNode treeModelNode : treeModelNodeArray = TreeModelRoot.this.findNode(object)) {
                if (this.outline != null) {
                    this.outline.expandNode((Node)treeModelNode);
                    continue;
                }
                this.view.expandNode((Node)treeModelNode);
            }
        }

        public void collapseNode(Object object) {
            TreeModelNode[] treeModelNodeArray;
            for (TreeModelNode treeModelNode : treeModelNodeArray = TreeModelRoot.this.findNode(object)) {
                if (this.outline != null) {
                    this.outline.collapseNode((Node)treeModelNode);
                    continue;
                }
                this.view.collapseNode((Node)treeModelNode);
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Models.CompoundModel compoundModel = TreeModelRoot.this.getModel();
            if (compoundModel != null) {
                compoundModel.nodeExpanded(this.initExpandCollapseNotify(treeExpansionEvent));
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            Models.CompoundModel compoundModel = TreeModelRoot.this.getModel();
            if (compoundModel != null) {
                compoundModel.nodeCollapsed(this.initExpandCollapseNotify(treeExpansionEvent));
            }
        }

        private Object initExpandCollapseNotify(TreeExpansionEvent treeExpansionEvent) {
            Object object;
            Node node = Visualizer.findNode((Object)treeExpansionEvent.getPath().getLastPathComponent());
            Object object2 = node.getLookup().lookup(Object.class);
            Integer n = (node = node.getParentNode()) == null ? new Integer(0) : ((object = node.getChildren()) instanceof TreeModelNode.TreeModelChildren ? ((TreeModelNode.TreeModelChildren)object).getTreeDepth() : object);
            object = TreeModelRoot.this.getModel();
            if (object != null) {
                DefaultTreeExpansionManager.get((Models.CompoundModel)object).setChildrenToActOn(n);
            }
            return object2;
        }
    }

    private final class ModelChangeListener
    implements ModelListener {
        private final Models.CompoundModel model;

        public ModelChangeListener(Models.CompoundModel compoundModel) {
            this.model = compoundModel;
        }

        public void modelChanged(final ModelEvent modelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModelEvent modelEvent2;
                    Object object;
                    if (ModelChangeListener.this.model == null) {
                        return;
                    }
                    if (modelEvent instanceof ModelEvent.TableValueChanged && (object = ((ModelEvent.TableValueChanged)(modelEvent2 = (ModelEvent.TableValueChanged)modelEvent)).getNode()) != null) {
                        TreeModelNode[] treeModelNodeArray;
                        for (TreeModelNode treeModelNode : treeModelNodeArray = TreeModelRoot.this.findNode(object)) {
                            String string = ((ModelEvent.TableValueChanged)modelEvent2).getColumnID();
                            if (string != null) {
                                treeModelNode.refreshColumn(string);
                                continue;
                            }
                            treeModelNode.refresh(ModelChangeListener.this.model);
                        }
                        return;
                    }
                    if (modelEvent instanceof ModelEvent.NodeChanged) {
                        modelEvent2 = (ModelEvent.NodeChanged)modelEvent;
                        object = ((ModelEvent.NodeChanged)modelEvent2).getNode();
                        if (object != null) {
                            TreeModelNode[] treeModelNodeArray;
                            for (TreeModelNode treeModelNode : treeModelNodeArray = TreeModelRoot.this.findNode(object)) {
                                treeModelNode.refresh(ModelChangeListener.this.model, ((ModelEvent.NodeChanged)modelEvent2).getChange());
                            }
                            return;
                        }
                        ArrayList<TreeModelNode> arrayList = new ArrayList<TreeModelNode>(TreeModelRoot.this.objectToNode.size());
                        Iterator<Object> iterator = TreeModelRoot.this.objectToNode.values().iterator();
                        while (iterator.hasNext()) {
                            WeakReference[] object2;
                            for (WeakReference weakReference : object2 = (WeakReference[])iterator.next()) {
                                TreeModelNode treeModelNode = (TreeModelNode)((Object)weakReference.get());
                                if (treeModelNode == null) continue;
                                arrayList.add(treeModelNode);
                            }
                        }
                        for (TreeModelNode treeModelNode : arrayList) {
                            treeModelNode.refresh(ModelChangeListener.this.model, ((ModelEvent.NodeChanged)modelEvent2).getChange());
                        }
                        return;
                    }
                    if (modelEvent instanceof ModelEvent.SelectionChanged) {
                        modelEvent2 = ((ModelEvent.SelectionChanged)modelEvent).getNodes();
                        SwingUtilities.invokeLater(new Runnable((Object[])modelEvent2){
                            final /* synthetic */ Object[] val$nodes;
                            {
                                this.val$nodes = objectArray;
                            }

                            public void run() {
                                ArrayList<TreeModelNode> arrayList = new ArrayList<TreeModelNode>(this.val$nodes.length);
                                for (Object object : this.val$nodes) {
                                    TreeModelNode[] treeModelNodeArray;
                                    for (TreeModelNode treeModelNode : treeModelNodeArray = TreeModelRoot.this.findNode(object)) {
                                        arrayList.add(treeModelNode);
                                    }
                                }
                                try {
                                    TreeModelRoot.this.manager.setSelectedNodes(arrayList.toArray(new Node[0]));
                                }
                                catch (PropertyVetoException propertyVetoException) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Selection of " + Arrays.toString(this.val$nodes) + " vetoed.", propertyVetoException);
                                }
                            }
                        });
                        return;
                    }
                    TreeModelRoot.this.rootNode.setObject(ModelChangeListener.this.model, ModelChangeListener.this.model.getRoot());
                }
            });
        }
    }
}

